/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.field.StatisticalKeyFigureField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.link.StatisticalKeyFigureLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.selectable.StatisticalKeyFigureSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Statistical Key Figure
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_StatisticalKeyFigureType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class StatisticalKeyFigure extends VdmEntity<StatisticalKeyFigure>
{

    /**
     * Selector for all available fields of StatisticalKeyFigure.
     *
     */
    public final static StatisticalKeyFigureSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>StatisticalKeyFigure</b>
     * </p>
     *
     * @return Statistical Key Figure
     */
    @Key
    @SerializedName( "StatisticalKeyFigure" )
    @JsonProperty( "StatisticalKeyFigure" )
    @Nullable
    @ODataField( odataName = "StatisticalKeyFigure" )
    private String statisticalKeyFigure;
    /**
     * Use with available fluent helpers to apply the <b>StatisticalKeyFigure</b> field to query operations.
     *
     */
    public final static StatisticalKeyFigureField<String> STATISTICAL_KEY_FIGURE =
        new StatisticalKeyFigureField<String>("StatisticalKeyFigure");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @return Controlling Area
     */
    @Key
    @SerializedName( "ControllingArea" )
    @JsonProperty( "ControllingArea" )
    @Nullable
    @ODataField( odataName = "ControllingArea" )
    private String controllingArea;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea</b> field to query operations.
     *
     */
    public final static StatisticalKeyFigureField<String> CONTROLLING_AREA =
        new StatisticalKeyFigureField<String>("ControllingArea");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>StstcKeyFigQuantityUnit</b>
     * </p>
     *
     * @return Unit for statistical key figure
     */
    @SerializedName( "StstcKeyFigQuantityUnit" )
    @JsonProperty( "StstcKeyFigQuantityUnit" )
    @Nullable
    @ODataField( odataName = "StstcKeyFigQuantityUnit" )
    private String ststcKeyFigQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>StstcKeyFigQuantityUnit</b> field to query operations.
     *
     */
    public final static StatisticalKeyFigureField<String> STSTC_KEY_FIG_QUANTITY_UNIT =
        new StatisticalKeyFigureField<String>("StstcKeyFigQuantityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>StstcKeyFigCategory</b>
     * </p>
     *
     * @return Statistical Key Figure Category
     */
    @SerializedName( "StstcKeyFigCategory" )
    @JsonProperty( "StstcKeyFigCategory" )
    @Nullable
    @ODataField( odataName = "StstcKeyFigCategory" )
    private String ststcKeyFigCategory;
    /**
     * Use with available fluent helpers to apply the <b>StstcKeyFigCategory</b> field to query operations.
     *
     */
    public final static StatisticalKeyFigureField<String> STSTC_KEY_FIG_CATEGORY =
        new StatisticalKeyFigureField<String>("StstcKeyFigCategory");
    /**
     * Navigation property <b>to_Text</b> for <b>StatisticalKeyFigure</b> to multiple <b>StatisticalKeyFigureText</b>.
     *
     */
    @SerializedName( "to_Text" )
    @JsonProperty( "to_Text" )
    @ODataField( odataName = "to_Text" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<StatisticalKeyFigureText> toText;
    /**
     * Use with available fluent helpers to apply the <b>to_Text</b> navigation property to query operations.
     *
     */
    public final static StatisticalKeyFigureLink<StatisticalKeyFigureText> TO_TEXT =
        new StatisticalKeyFigureLink<StatisticalKeyFigureText>("to_Text");

    @Nonnull
    @Override
    public Class<StatisticalKeyFigure> getType()
    {
        return StatisticalKeyFigure.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>StatisticalKeyFigure</b>
     * </p>
     *
     * @param statisticalKeyFigure
     *            Statistical Key Figure
     */
    public void setStatisticalKeyFigure( @Nullable final String statisticalKeyFigure )
    {
        rememberChangedField("StatisticalKeyFigure", this.statisticalKeyFigure);
        this.statisticalKeyFigure = statisticalKeyFigure;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @param controllingArea
     *            Controlling Area
     */
    public void setControllingArea( @Nullable final String controllingArea )
    {
        rememberChangedField("ControllingArea", this.controllingArea);
        this.controllingArea = controllingArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>StstcKeyFigQuantityUnit</b>
     * </p>
     *
     * @param ststcKeyFigQuantityUnit
     *            Unit for statistical key figure
     */
    public void setStstcKeyFigQuantityUnit( @Nullable final String ststcKeyFigQuantityUnit )
    {
        rememberChangedField("StstcKeyFigQuantityUnit", this.ststcKeyFigQuantityUnit);
        this.ststcKeyFigQuantityUnit = ststcKeyFigQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>StstcKeyFigCategory</b>
     * </p>
     *
     * @param ststcKeyFigCategory
     *            Statistical Key Figure Category
     */
    public void setStstcKeyFigCategory( @Nullable final String ststcKeyFigCategory )
    {
        rememberChangedField("StstcKeyFigCategory", this.ststcKeyFigCategory);
        this.ststcKeyFigCategory = ststcKeyFigCategory;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_StatisticalKeyFigure";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("StatisticalKeyFigure", getStatisticalKeyFigure());
        result.put("ControllingArea", getControllingArea());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("StatisticalKeyFigure", getStatisticalKeyFigure());
        values.put("ControllingArea", getControllingArea());
        values.put("StstcKeyFigQuantityUnit", getStstcKeyFigQuantityUnit());
        values.put("StstcKeyFigCategory", getStstcKeyFigCategory());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("StatisticalKeyFigure") ) {
                final Object value = values.remove("StatisticalKeyFigure");
                if( (value == null) || (!value.equals(getStatisticalKeyFigure())) ) {
                    setStatisticalKeyFigure(((String) value));
                }
            }
            if( values.containsKey("ControllingArea") ) {
                final Object value = values.remove("ControllingArea");
                if( (value == null) || (!value.equals(getControllingArea())) ) {
                    setControllingArea(((String) value));
                }
            }
            if( values.containsKey("StstcKeyFigQuantityUnit") ) {
                final Object value = values.remove("StstcKeyFigQuantityUnit");
                if( (value == null) || (!value.equals(getStstcKeyFigQuantityUnit())) ) {
                    setStstcKeyFigQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("StstcKeyFigCategory") ) {
                final Object value = values.remove("StstcKeyFigCategory");
                if( (value == null) || (!value.equals(getStstcKeyFigCategory())) ) {
                    setStstcKeyFigCategory(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Text") ) {
                final Object value = (values).remove("to_Text");
                if( value instanceof Iterable ) {
                    if( toText == null ) {
                        toText = Lists.newArrayList();
                    } else {
                        toText = Lists.newArrayList(toText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        StatisticalKeyFigureText entity;
                        if( toText.size() > i ) {
                            entity = toText.get(i);
                        } else {
                            entity = new StatisticalKeyFigureText();
                            toText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> StatisticalKeyFigureField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new StatisticalKeyFigureField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> StatisticalKeyFigureField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new StatisticalKeyFigureField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.StatisticalKeyFigureService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toText != null ) {
            (values).put("to_Text", toText);
        }
        return values;
    }

    /**
     * Fetches the <b>StatisticalKeyFigureText</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_Text</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>StatisticalKeyFigureText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<StatisticalKeyFigureText> fetchText()
    {
        return fetchFieldAsList("to_Text", StatisticalKeyFigureText.class);
    }

    /**
     * Retrieval of associated <b>StatisticalKeyFigureText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>StatisticalKeyFigure</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>StatisticalKeyFigureText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<StatisticalKeyFigureText> getTextOrFetch()
    {
        if( toText == null ) {
            toText = fetchText();
        }
        return toText;
    }

    /**
     * Retrieval of associated <b>StatisticalKeyFigureText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property for an entity <b>StatisticalKeyFigure</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Text</b> is already loaded, the result will contain the
     *         <b>StatisticalKeyFigureText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<StatisticalKeyFigureText>> getTextIfPresent()
    {
        return Option.of(toText);
    }

    /**
     * Overwrites the list of associated <b>StatisticalKeyFigureText</b> entities for the loaded navigation property
     * <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>StatisticalKeyFigure</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>StatisticalKeyFigureText</b> entities.
     */
    public void setText( @Nonnull final List<StatisticalKeyFigureText> value )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.clear();
        toText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>StatisticalKeyFigureText</b> entities. This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>StatisticalKeyFigure</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>StatisticalKeyFigureText</b> entities.
     */
    public void addText( StatisticalKeyFigureText... entity )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of StatisticalKeyFigure instances.
     *
     */
    public final static class StatisticalKeyFigureBuilder
    {

        private List<StatisticalKeyFigureText> toText = Lists.newArrayList();

        private StatisticalKeyFigure.StatisticalKeyFigureBuilder toText( final List<StatisticalKeyFigureText> value )
        {
            toText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Text</b> for <b>StatisticalKeyFigure</b> to multiple
         * <b>StatisticalKeyFigureText</b>.
         *
         * @param value
         *            The StatisticalKeyFigureTexts to build this StatisticalKeyFigure with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public StatisticalKeyFigure.StatisticalKeyFigureBuilder text( StatisticalKeyFigureText... value )
        {
            return toText(Lists.newArrayList(value));
        }

    }

}
