/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.field.StatisticalKeyFigureTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.link.StatisticalKeyFigureTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.selectable.StatisticalKeyFigureTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Statistical Key Figure Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_StatisticalKeyFigureTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class StatisticalKeyFigureText extends VdmEntity<StatisticalKeyFigureText>
{

    /**
     * Selector for all available fields of StatisticalKeyFigureText.
     *
     */
    public final static StatisticalKeyFigureTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static StatisticalKeyFigureTextField<String> LANGUAGE =
        new StatisticalKeyFigureTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @return Controlling Area
     */
    @Key
    @SerializedName( "ControllingArea" )
    @JsonProperty( "ControllingArea" )
    @Nullable
    @ODataField( odataName = "ControllingArea" )
    private String controllingArea;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea</b> field to query operations.
     *
     */
    public final static StatisticalKeyFigureTextField<String> CONTROLLING_AREA =
        new StatisticalKeyFigureTextField<String>("ControllingArea");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>StatisticalKeyFigure</b>
     * </p>
     *
     * @return Statistical Key Figure
     */
    @Key
    @SerializedName( "StatisticalKeyFigure" )
    @JsonProperty( "StatisticalKeyFigure" )
    @Nullable
    @ODataField( odataName = "StatisticalKeyFigure" )
    private String statisticalKeyFigure;
    /**
     * Use with available fluent helpers to apply the <b>StatisticalKeyFigure</b> field to query operations.
     *
     */
    public final static StatisticalKeyFigureTextField<String> STATISTICAL_KEY_FIGURE =
        new StatisticalKeyFigureTextField<String>("StatisticalKeyFigure");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>StatisticalKeyFigureName</b>
     * </p>
     *
     * @return Statistical Key Figure Name
     */
    @SerializedName( "StatisticalKeyFigureName" )
    @JsonProperty( "StatisticalKeyFigureName" )
    @Nullable
    @ODataField( odataName = "StatisticalKeyFigureName" )
    private String statisticalKeyFigureName;
    /**
     * Use with available fluent helpers to apply the <b>StatisticalKeyFigureName</b> field to query operations.
     *
     */
    public final static StatisticalKeyFigureTextField<String> STATISTICAL_KEY_FIGURE_NAME =
        new StatisticalKeyFigureTextField<String>("StatisticalKeyFigureName");
    /**
     * Navigation property <b>to_StatisticalKeyFigure</b> for <b>StatisticalKeyFigureText</b> to single
     * <b>StatisticalKeyFigure</b>.
     *
     */
    @SerializedName( "to_StatisticalKeyFigure" )
    @JsonProperty( "to_StatisticalKeyFigure" )
    @ODataField( odataName = "to_StatisticalKeyFigure" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private StatisticalKeyFigure toStatisticalKeyFigure;
    /**
     * Use with available fluent helpers to apply the <b>to_StatisticalKeyFigure</b> navigation property to query
     * operations.
     *
     */
    public final static StatisticalKeyFigureTextOneToOneLink<StatisticalKeyFigure> TO_STATISTICAL_KEY_FIGURE =
        new StatisticalKeyFigureTextOneToOneLink<StatisticalKeyFigure>("to_StatisticalKeyFigure");

    @Nonnull
    @Override
    public Class<StatisticalKeyFigureText> getType()
    {
        return StatisticalKeyFigureText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @param controllingArea
     *            Controlling Area
     */
    public void setControllingArea( @Nullable final String controllingArea )
    {
        rememberChangedField("ControllingArea", this.controllingArea);
        this.controllingArea = controllingArea;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>StatisticalKeyFigure</b>
     * </p>
     *
     * @param statisticalKeyFigure
     *            Statistical Key Figure
     */
    public void setStatisticalKeyFigure( @Nullable final String statisticalKeyFigure )
    {
        rememberChangedField("StatisticalKeyFigure", this.statisticalKeyFigure);
        this.statisticalKeyFigure = statisticalKeyFigure;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>StatisticalKeyFigureName</b>
     * </p>
     *
     * @param statisticalKeyFigureName
     *            Statistical Key Figure Name
     */
    public void setStatisticalKeyFigureName( @Nullable final String statisticalKeyFigureName )
    {
        rememberChangedField("StatisticalKeyFigureName", this.statisticalKeyFigureName);
        this.statisticalKeyFigureName = statisticalKeyFigureName;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_StatisticalKeyFigureText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Language", getLanguage());
        result.put("ControllingArea", getControllingArea());
        result.put("StatisticalKeyFigure", getStatisticalKeyFigure());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("ControllingArea", getControllingArea());
        values.put("StatisticalKeyFigure", getStatisticalKeyFigure());
        values.put("StatisticalKeyFigureName", getStatisticalKeyFigureName());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("ControllingArea") ) {
                final Object value = values.remove("ControllingArea");
                if( (value == null) || (!value.equals(getControllingArea())) ) {
                    setControllingArea(((String) value));
                }
            }
            if( values.containsKey("StatisticalKeyFigure") ) {
                final Object value = values.remove("StatisticalKeyFigure");
                if( (value == null) || (!value.equals(getStatisticalKeyFigure())) ) {
                    setStatisticalKeyFigure(((String) value));
                }
            }
            if( values.containsKey("StatisticalKeyFigureName") ) {
                final Object value = values.remove("StatisticalKeyFigureName");
                if( (value == null) || (!value.equals(getStatisticalKeyFigureName())) ) {
                    setStatisticalKeyFigureName(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_StatisticalKeyFigure") ) {
                final Object value = (values).remove("to_StatisticalKeyFigure");
                if( value instanceof Map ) {
                    if( toStatisticalKeyFigure == null ) {
                        toStatisticalKeyFigure = new StatisticalKeyFigure();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toStatisticalKeyFigure.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> StatisticalKeyFigureTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new StatisticalKeyFigureTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> StatisticalKeyFigureTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new StatisticalKeyFigureTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.StatisticalKeyFigureService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toStatisticalKeyFigure != null ) {
            (values).put("to_StatisticalKeyFigure", toStatisticalKeyFigure);
        }
        return values;
    }

    /**
     * Fetches the <b>StatisticalKeyFigure</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_StatisticalKeyFigure</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>StatisticalKeyFigure</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public StatisticalKeyFigure fetchStatisticalKeyFigure()
    {
        return fetchFieldAsSingle("to_StatisticalKeyFigure", StatisticalKeyFigure.class);
    }

    /**
     * Retrieval of associated <b>StatisticalKeyFigure</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_StatisticalKeyFigure</b>.
     * <p>
     * If the navigation property <b>to_StatisticalKeyFigure</b> of a queried <b>StatisticalKeyFigureText</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>StatisticalKeyFigure</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public StatisticalKeyFigure getStatisticalKeyFigureOrFetch()
    {
        if( toStatisticalKeyFigure == null ) {
            toStatisticalKeyFigure = fetchStatisticalKeyFigure();
        }
        return toStatisticalKeyFigure;
    }

    /**
     * Retrieval of associated <b>StatisticalKeyFigure</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_StatisticalKeyFigure</b>.
     * <p>
     * If the navigation property for an entity <b>StatisticalKeyFigureText</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_StatisticalKeyFigure</b> is already loaded, the result
     *         will contain the <b>StatisticalKeyFigure</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<StatisticalKeyFigure> getStatisticalKeyFigureIfPresent()
    {
        return Option.of(toStatisticalKeyFigure);
    }

    /**
     * Overwrites the associated <b>StatisticalKeyFigure</b> entity for the loaded navigation property
     * <b>to_StatisticalKeyFigure</b>.
     *
     * @param value
     *            New <b>StatisticalKeyFigure</b> entity.
     */
    public void setStatisticalKeyFigure( final StatisticalKeyFigure value )
    {
        toStatisticalKeyFigure = value;
    }

    /**
     * Helper class to allow for fluent creation of StatisticalKeyFigureText instances.
     *
     */
    public final static class StatisticalKeyFigureTextBuilder
    {

        private StatisticalKeyFigure toStatisticalKeyFigure;
        private String statisticalKeyFigure = null;

        private StatisticalKeyFigureText.StatisticalKeyFigureTextBuilder toStatisticalKeyFigure(
            final StatisticalKeyFigure value )
        {
            toStatisticalKeyFigure = value;
            return this;
        }

        /**
         * Navigation property <b>to_StatisticalKeyFigure</b> for <b>StatisticalKeyFigureText</b> to single
         * <b>StatisticalKeyFigure</b>.
         *
         * @param value
         *            The StatisticalKeyFigure to build this StatisticalKeyFigureText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public StatisticalKeyFigureText.StatisticalKeyFigureTextBuilder statisticalKeyFigure(
            final StatisticalKeyFigure value )
        {
            return toStatisticalKeyFigure(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 6
         * <p>
         * Original property name from the Odata EDM: <b>StatisticalKeyFigure</b>
         * </p>
         *
         * @param value
         *            The statisticalKeyFigure to build this StatisticalKeyFigureText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public StatisticalKeyFigureText.StatisticalKeyFigureTextBuilder statisticalKeyFigure( final String value )
        {
            statisticalKeyFigure = value;
            return this;
        }

    }

}
