/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.selectable.StatisticalKeyFigureTextSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigureText
 * StatisticalKeyFigureText} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class StatisticalKeyFigureTextByKeyFluentHelper
    extends
    FluentHelperByKey<StatisticalKeyFigureTextByKeyFluentHelper, StatisticalKeyFigureText, StatisticalKeyFigureTextSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigureText
     * StatisticalKeyFigureText} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code StatisticalKeyFigureText}
     * @param servicePath
     *            Service path to be used to fetch a single {@code StatisticalKeyFigureText}
     * @param statisticalKeyFigure
     *            Statistical Key Figure
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param controllingArea
     *            Controlling Area
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     */
    public StatisticalKeyFigureTextByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String language,
        final String controllingArea,
        final String statisticalKeyFigure )
    {
        super(servicePath, entityCollection);
        this.key.put("Language", language);
        this.key.put("ControllingArea", controllingArea);
        this.key.put("StatisticalKeyFigure", statisticalKeyFigure);
    }

    @Override
    @Nonnull
    protected Class<StatisticalKeyFigureText> getEntityClass()
    {
        return StatisticalKeyFigureText.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
