/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link StatisticalKeyFigureServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.StatisticalKeyFigureService StatisticalKeyFigureService},
 * allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultStatisticalKeyFigureServiceBatch
    extends
    BatchFluentHelperBasic<StatisticalKeyFigureServiceBatch, StatisticalKeyFigureServiceBatchChangeSet>
    implements
    StatisticalKeyFigureServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.StatisticalKeyFigureService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultStatisticalKeyFigureServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultStatisticalKeyFigureServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.StatisticalKeyFigureService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.StatisticalKeyFigureService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultStatisticalKeyFigureServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultStatisticalKeyFigureServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.StatisticalKeyFigureService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultStatisticalKeyFigureServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public StatisticalKeyFigureServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultStatisticalKeyFigureServiceBatchChangeSet(this, service);
    }

}
