/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigure;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigureText;

/**
 * Implementation of the {@link StatisticalKeyFigureServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.StatisticalKeyFigureService StatisticalKeyFigureService}.
 *
 */
public class DefaultStatisticalKeyFigureServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<StatisticalKeyFigureServiceBatch, StatisticalKeyFigureServiceBatchChangeSet>
    implements
    StatisticalKeyFigureServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.StatisticalKeyFigureService service;

    @SuppressWarnings( "deprecation" )
    DefaultStatisticalKeyFigureServiceBatchChangeSet(
        @Nonnull final DefaultStatisticalKeyFigureServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.StatisticalKeyFigureService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultStatisticalKeyFigureServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public StatisticalKeyFigureServiceBatchChangeSet createStatisticalKeyFigure(
        @Nonnull final StatisticalKeyFigure statisticalKeyFigure )
    {
        return addRequestCreate(service::createStatisticalKeyFigure, statisticalKeyFigure);
    }

    @Nonnull
    @Override
    public StatisticalKeyFigureServiceBatchChangeSet updateStatisticalKeyFigure(
        @Nonnull final StatisticalKeyFigure statisticalKeyFigure )
    {
        return addRequestUpdate(service::updateStatisticalKeyFigure, statisticalKeyFigure);
    }

    @Nonnull
    @Override
    public StatisticalKeyFigureServiceBatchChangeSet deleteStatisticalKeyFigure(
        @Nonnull final StatisticalKeyFigure statisticalKeyFigure )
    {
        return addRequestDelete(service::deleteStatisticalKeyFigure, statisticalKeyFigure);
    }

    @Nonnull
    @Override
    public StatisticalKeyFigureServiceBatchChangeSet createStatisticalKeyFigureText(
        @Nonnull final StatisticalKeyFigureText statisticalKeyFigureText )
    {
        return addRequestCreate(service::createStatisticalKeyFigureText, statisticalKeyFigureText);
    }

    @Nonnull
    @Override
    public StatisticalKeyFigureServiceBatchChangeSet updateStatisticalKeyFigureText(
        @Nonnull final StatisticalKeyFigureText statisticalKeyFigureText )
    {
        return addRequestUpdate(service::updateStatisticalKeyFigureText, statisticalKeyFigureText);
    }

    @Nonnull
    @Override
    public StatisticalKeyFigureServiceBatchChangeSet deleteStatisticalKeyFigureText(
        @Nonnull final StatisticalKeyFigureText statisticalKeyFigureText )
    {
        return addRequestDelete(service::deleteStatisticalKeyFigureText, statisticalKeyFigureText);
    }

}
