/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigure;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigureText;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.StatisticalKeyFigureService
 * StatisticalKeyFigureService}.
 *
 */
public interface StatisticalKeyFigureServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<StatisticalKeyFigureServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<StatisticalKeyFigureServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigure
     * StatisticalKeyFigure} entity and save it to the S/4HANA system.
     *
     * @param statisticalKeyFigure
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigure
     *            StatisticalKeyFigure} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    StatisticalKeyFigureServiceBatchChangeSet
        createStatisticalKeyFigure( @Nonnull final StatisticalKeyFigure statisticalKeyFigure );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigure
     * StatisticalKeyFigure} entity and save it to the S/4HANA system.
     *
     * @param statisticalKeyFigure
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigure
     *            StatisticalKeyFigure} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    StatisticalKeyFigureServiceBatchChangeSet
        updateStatisticalKeyFigure( @Nonnull final StatisticalKeyFigure statisticalKeyFigure );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigure
     * StatisticalKeyFigure} entity in the S/4HANA system.
     *
     * @param statisticalKeyFigure
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigure
     *            StatisticalKeyFigure} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    StatisticalKeyFigureServiceBatchChangeSet
        deleteStatisticalKeyFigure( @Nonnull final StatisticalKeyFigure statisticalKeyFigure );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigureText
     * StatisticalKeyFigureText} entity and save it to the S/4HANA system.
     *
     * @param statisticalKeyFigureText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigureText
     *            StatisticalKeyFigureText} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    StatisticalKeyFigureServiceBatchChangeSet
        createStatisticalKeyFigureText( @Nonnull final StatisticalKeyFigureText statisticalKeyFigureText );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigureText
     * StatisticalKeyFigureText} entity and save it to the S/4HANA system.
     *
     * @param statisticalKeyFigureText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigureText
     *            StatisticalKeyFigureText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    StatisticalKeyFigureServiceBatchChangeSet
        updateStatisticalKeyFigureText( @Nonnull final StatisticalKeyFigureText statisticalKeyFigureText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigureText
     * StatisticalKeyFigureText} entity in the S/4HANA system.
     *
     * @param statisticalKeyFigureText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigureText
     *            StatisticalKeyFigureText} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    StatisticalKeyFigureServiceBatchChangeSet
        deleteStatisticalKeyFigureText( @Nonnull final StatisticalKeyFigureText statisticalKeyFigureText );

}
