/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigure;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigure
 * StatisticalKeyFigure}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.field.StatisticalKeyFigureField
 * StatisticalKeyFigureField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.link.StatisticalKeyFigureLink
 * StatisticalKeyFigureLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigure#STATISTICAL_KEY_FIGURE
 * STATISTICAL_KEY_FIGURE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigure#CONTROLLING_AREA
 * CONTROLLING_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigure#STSTC_KEY_FIG_QUANTITY_UNIT
 * STSTC_KEY_FIG_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigure#STSTC_KEY_FIG_CATEGORY
 * STSTC_KEY_FIG_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigure#TO_TEXT
 * TO_TEXT}</li>
 * </ul>
 *
 */
public interface StatisticalKeyFigureSelectable extends EntitySelectable<StatisticalKeyFigure>
{

}
