/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigureText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigureText
 * StatisticalKeyFigureText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.field.StatisticalKeyFigureTextField
 * StatisticalKeyFigureTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.link.StatisticalKeyFigureTextLink
 * StatisticalKeyFigureTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigureText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigureText#CONTROLLING_AREA
 * CONTROLLING_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigureText#STATISTICAL_KEY_FIGURE
 * STATISTICAL_KEY_FIGURE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigureText#STATISTICAL_KEY_FIGURE_NAME
 * STATISTICAL_KEY_FIGURE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigureText#TO_STATISTICAL_KEY_FIGURE
 * TO_STATISTICAL_KEY_FIGURE}</li>
 * </ul>
 *
 */
public interface StatisticalKeyFigureTextSelectable extends EntitySelectable<StatisticalKeyFigureText>
{

}
