/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.subsequentbillingdocument;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.subsequentbillingdocument.field.SubsqntBillgDocForSelfBillgField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.subsequentbillingdocument.selectable.SubsqntBillgDocForSelfBillgSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Subsequent Billing Document
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SubsqntBillgDocForSelfBillgType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SubsqntBillgDocForSelfBillg extends VdmEntity<SubsqntBillgDocForSelfBillg>
{

    /**
     * Selector for all available fields of SubsqntBillgDocForSelfBillg.
     *
     */
    public final static SubsqntBillgDocForSelfBillgSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocument</b>
     * </p>
     *
     * @return Billing Document
     */
    @Key
    @SerializedName( "BillingDocument" )
    @JsonProperty( "BillingDocument" )
    @Nullable
    @ODataField( odataName = "BillingDocument" )
    private String billingDocument;
    /**
     * Use with available fluent helpers to apply the <b>BillingDocument</b> field to query operations.
     *
     */
    public final static SubsqntBillgDocForSelfBillgField<String> BILLING_DOCUMENT =
        new SubsqntBillgDocForSelfBillgField<String>("BillingDocument");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocumentItem</b>
     * </p>
     *
     * @return Preceding Item of an SD Document
     */
    @Key
    @SerializedName( "BillingDocumentItem" )
    @JsonProperty( "BillingDocumentItem" )
    @Nullable
    @ODataField( odataName = "BillingDocumentItem" )
    private String billingDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>BillingDocumentItem</b> field to query operations.
     *
     */
    public final static SubsqntBillgDocForSelfBillgField<String> BILLING_DOCUMENT_ITEM =
        new SubsqntBillgDocForSelfBillgField<String>("BillingDocumentItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SubsequentDocument</b>
     * </p>
     *
     * @return Subsequent Sales and Distribution Document
     */
    @Key
    @SerializedName( "SubsequentDocument" )
    @JsonProperty( "SubsequentDocument" )
    @Nullable
    @ODataField( odataName = "SubsequentDocument" )
    private String subsequentDocument;
    /**
     * Use with available fluent helpers to apply the <b>SubsequentDocument</b> field to query operations.
     *
     */
    public final static SubsqntBillgDocForSelfBillgField<String> SUBSEQUENT_DOCUMENT =
        new SubsqntBillgDocForSelfBillgField<String>("SubsequentDocument");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SubsequentDocumentItem</b>
     * </p>
     *
     * @return Subsequent Item of an SD Document
     */
    @Key
    @SerializedName( "SubsequentDocumentItem" )
    @JsonProperty( "SubsequentDocumentItem" )
    @Nullable
    @ODataField( odataName = "SubsequentDocumentItem" )
    private String subsequentDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>SubsequentDocumentItem</b> field to query operations.
     *
     */
    public final static SubsqntBillgDocForSelfBillgField<String> SUBSEQUENT_DOCUMENT_ITEM =
        new SubsqntBillgDocForSelfBillgField<String>("SubsequentDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SubsequentDocumentCategory</b>
     * </p>
     *
     * @return Document Category of Subsequent Document
     */
    @SerializedName( "SubsequentDocumentCategory" )
    @JsonProperty( "SubsequentDocumentCategory" )
    @Nullable
    @ODataField( odataName = "SubsequentDocumentCategory" )
    private String subsequentDocumentCategory;
    /**
     * Use with available fluent helpers to apply the <b>SubsequentDocumentCategory</b> field to query operations.
     *
     */
    public final static SubsqntBillgDocForSelfBillgField<String> SUBSEQUENT_DOCUMENT_CATEGORY =
        new SubsqntBillgDocForSelfBillgField<String>("SubsequentDocumentCategory");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SDDocumentCategory</b>
     * </p>
     *
     * @return SD Document Category
     */
    @SerializedName( "SDDocumentCategory" )
    @JsonProperty( "SDDocumentCategory" )
    @Nullable
    @ODataField( odataName = "SDDocumentCategory" )
    private String sDDocumentCategory;
    /**
     * Use with available fluent helpers to apply the <b>SDDocumentCategory</b> field to query operations.
     *
     */
    public final static SubsqntBillgDocForSelfBillgField<String> SD_DOCUMENT_CATEGORY =
        new SubsqntBillgDocForSelfBillgField<String>("SDDocumentCategory");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProcessFlowLevel</b>
     * </p>
     *
     * @return Level of the document flow record
     */
    @SerializedName( "ProcessFlowLevel" )
    @JsonProperty( "ProcessFlowLevel" )
    @Nullable
    @ODataField( odataName = "ProcessFlowLevel" )
    private String processFlowLevel;
    /**
     * Use with available fluent helpers to apply the <b>ProcessFlowLevel</b> field to query operations.
     *
     */
    public final static SubsqntBillgDocForSelfBillgField<String> PROCESS_FLOW_LEVEL =
        new SubsqntBillgDocForSelfBillgField<String>("ProcessFlowLevel");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Record Created On
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static SubsqntBillgDocForSelfBillgField<LocalDateTime> CREATION_DATE =
        new SubsqntBillgDocForSelfBillgField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     *
     * @return Entry time
     */
    @SerializedName( "CreationTime" )
    @JsonProperty( "CreationTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "CreationTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime creationTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationTime</b> field to query operations.
     *
     */
    public final static SubsqntBillgDocForSelfBillgField<LocalTime> CREATION_TIME =
        new SubsqntBillgDocForSelfBillgField<LocalTime>("CreationTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @return Last Changed On
     */
    @SerializedName( "LastChangeDate" )
    @JsonProperty( "LastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDate</b> field to query operations.
     *
     */
    public final static SubsqntBillgDocForSelfBillgField<LocalDateTime> LAST_CHANGE_DATE =
        new SubsqntBillgDocForSelfBillgField<LocalDateTime>("LastChangeDate");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityInBaseUnit</b>
     * </p>
     *
     * @return Referenced quantity in base unit of measure
     */
    @SerializedName( "QuantityInBaseUnit" )
    @JsonProperty( "QuantityInBaseUnit" )
    @Nullable
    @ODataField( odataName = "QuantityInBaseUnit" )
    private BigDecimal quantityInBaseUnit;
    /**
     * Use with available fluent helpers to apply the <b>QuantityInBaseUnit</b> field to query operations.
     *
     */
    public final static SubsqntBillgDocForSelfBillgField<BigDecimal> QUANTITY_IN_BASE_UNIT =
        new SubsqntBillgDocForSelfBillgField<BigDecimal>("QuantityInBaseUnit");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RefQuantityInOrdQtyUnitAsFloat</b>
     * </p>
     *
     * @return Referenced quantity in sales unit (float)
     */
    @SerializedName( "RefQuantityInOrdQtyUnitAsFloat" )
    @JsonProperty( "RefQuantityInOrdQtyUnitAsFloat" )
    @Nullable
    @ODataField( odataName = "RefQuantityInOrdQtyUnitAsFloat" )
    private Double refQuantityInOrdQtyUnitAsFloat;
    /**
     * Use with available fluent helpers to apply the <b>RefQuantityInOrdQtyUnitAsFloat</b> field to query operations.
     *
     */
    public final static SubsqntBillgDocForSelfBillgField<Double> REF_QUANTITY_IN_ORD_QTY_UNIT_AS_FLOAT =
        new SubsqntBillgDocForSelfBillgField<Double>("RefQuantityInOrdQtyUnitAsFloat");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RefQuantityInBaseUnitAsFloat</b>
     * </p>
     *
     * @return Referenced quantity in base unit of measure (float)
     */
    @SerializedName( "RefQuantityInBaseUnitAsFloat" )
    @JsonProperty( "RefQuantityInBaseUnitAsFloat" )
    @Nullable
    @ODataField( odataName = "RefQuantityInBaseUnitAsFloat" )
    private Double refQuantityInBaseUnitAsFloat;
    /**
     * Use with available fluent helpers to apply the <b>RefQuantityInBaseUnitAsFloat</b> field to query operations.
     *
     */
    public final static SubsqntBillgDocForSelfBillgField<Double> REF_QUANTITY_IN_BASE_UNIT_AS_FLOAT =
        new SubsqntBillgDocForSelfBillgField<Double>("RefQuantityInBaseUnitAsFloat");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "BaseUnit" )
    @JsonProperty( "BaseUnit" )
    @Nullable
    @ODataField( odataName = "BaseUnit" )
    private String baseUnit;
    /**
     * Use with available fluent helpers to apply the <b>BaseUnit</b> field to query operations.
     *
     */
    public final static SubsqntBillgDocForSelfBillgField<String> BASE_UNIT =
        new SubsqntBillgDocForSelfBillgField<String>("BaseUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantityUnit</b>
     * </p>
     *
     * @return Sales Unit
     */
    @SerializedName( "OrderQuantityUnit" )
    @JsonProperty( "OrderQuantityUnit" )
    @Nullable
    @ODataField( odataName = "OrderQuantityUnit" )
    private String orderQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>OrderQuantityUnit</b> field to query operations.
     *
     */
    public final static SubsqntBillgDocForSelfBillgField<String> ORDER_QUANTITY_UNIT =
        new SubsqntBillgDocForSelfBillgField<String>("OrderQuantityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SDFulfillmentCalculationRule</b>
     * </p>
     *
     * @return Quantity is calculated positively, negatively or not at all
     */
    @SerializedName( "SDFulfillmentCalculationRule" )
    @JsonProperty( "SDFulfillmentCalculationRule" )
    @Nullable
    @ODataField( odataName = "SDFulfillmentCalculationRule" )
    private String sDFulfillmentCalculationRule;
    /**
     * Use with available fluent helpers to apply the <b>SDFulfillmentCalculationRule</b> field to query operations.
     *
     */
    public final static SubsqntBillgDocForSelfBillgField<String> SD_FULFILLMENT_CALCULATION_RULE =
        new SubsqntBillgDocForSelfBillgField<String>("SDFulfillmentCalculationRule");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetAmount</b>
     * </p>
     *
     * @return Reference Value
     */
    @SerializedName( "NetAmount" )
    @JsonProperty( "NetAmount" )
    @Nullable
    @ODataField( odataName = "NetAmount" )
    private BigDecimal netAmount;
    /**
     * Use with available fluent helpers to apply the <b>NetAmount</b> field to query operations.
     *
     */
    public final static SubsqntBillgDocForSelfBillgField<BigDecimal> NET_AMOUNT =
        new SubsqntBillgDocForSelfBillgField<BigDecimal>("NetAmount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>StatisticsCurrency</b>
     * </p>
     *
     * @return Statistics currency
     */
    @SerializedName( "StatisticsCurrency" )
    @JsonProperty( "StatisticsCurrency" )
    @Nullable
    @ODataField( odataName = "StatisticsCurrency" )
    private String statisticsCurrency;
    /**
     * Use with available fluent helpers to apply the <b>StatisticsCurrency</b> field to query operations.
     *
     */
    public final static SubsqntBillgDocForSelfBillgField<String> STATISTICS_CURRENCY =
        new SubsqntBillgDocForSelfBillgField<String>("StatisticsCurrency");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>TransferOrderInWrhsMgmtIsConfd</b>
     * </p>
     *
     * @return ID: MM-WM Transfer Order Confirmed
     */
    @SerializedName( "TransferOrderInWrhsMgmtIsConfd" )
    @JsonProperty( "TransferOrderInWrhsMgmtIsConfd" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "TransferOrderInWrhsMgmtIsConfd" )
    private Boolean transferOrderInWrhsMgmtIsConfd;
    /**
     * Use with available fluent helpers to apply the <b>TransferOrderInWrhsMgmtIsConfd</b> field to query operations.
     *
     */
    public final static SubsqntBillgDocForSelfBillgField<Boolean> TRANSFER_ORDER_IN_WRHS_MGMT_IS_CONFD =
        new SubsqntBillgDocForSelfBillgField<Boolean>("TransferOrderInWrhsMgmtIsConfd");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseNumber</b>
     * </p>
     *
     * @return Warehouse Number / Warehouse Complex
     */
    @SerializedName( "WarehouseNumber" )
    @JsonProperty( "WarehouseNumber" )
    @Nullable
    @ODataField( odataName = "WarehouseNumber" )
    private String warehouseNumber;
    /**
     * Use with available fluent helpers to apply the <b>WarehouseNumber</b> field to query operations.
     *
     */
    public final static SubsqntBillgDocForSelfBillgField<String> WAREHOUSE_NUMBER =
        new SubsqntBillgDocForSelfBillgField<String>("WarehouseNumber");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocumentYear</b>
     * </p>
     *
     * @return Material Document Year
     */
    @SerializedName( "MaterialDocumentYear" )
    @JsonProperty( "MaterialDocumentYear" )
    @Nullable
    @ODataField( odataName = "MaterialDocumentYear" )
    private String materialDocumentYear;
    /**
     * Use with available fluent helpers to apply the <b>MaterialDocumentYear</b> field to query operations.
     *
     */
    public final static SubsqntBillgDocForSelfBillgField<String> MATERIAL_DOCUMENT_YEAR =
        new SubsqntBillgDocForSelfBillgField<String>("MaterialDocumentYear");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlan</b>
     * </p>
     *
     * @return Billing Plan Number / Invoicing Plan Number
     */
    @SerializedName( "BillingPlan" )
    @JsonProperty( "BillingPlan" )
    @Nullable
    @ODataField( odataName = "BillingPlan" )
    private String billingPlan;
    /**
     * Use with available fluent helpers to apply the <b>BillingPlan</b> field to query operations.
     *
     */
    public final static SubsqntBillgDocForSelfBillgField<String> BILLING_PLAN =
        new SubsqntBillgDocForSelfBillgField<String>("BillingPlan");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanItem</b>
     * </p>
     *
     * @return Item for billing plan/invoice plan/payment cards
     */
    @SerializedName( "BillingPlanItem" )
    @JsonProperty( "BillingPlanItem" )
    @Nullable
    @ODataField( odataName = "BillingPlanItem" )
    private String billingPlanItem;
    /**
     * Use with available fluent helpers to apply the <b>BillingPlanItem</b> field to query operations.
     *
     */
    public final static SubsqntBillgDocForSelfBillgField<String> BILLING_PLAN_ITEM =
        new SubsqntBillgDocForSelfBillgField<String>("BillingPlanItem");

    @Nonnull
    @Override
    public Class<SubsqntBillgDocForSelfBillg> getType()
    {
        return SubsqntBillgDocForSelfBillg.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocument</b>
     * </p>
     *
     * @param billingDocument
     *            Billing Document
     */
    public void setBillingDocument( @Nullable final String billingDocument )
    {
        rememberChangedField("BillingDocument", this.billingDocument);
        this.billingDocument = billingDocument;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocumentItem</b>
     * </p>
     *
     * @param billingDocumentItem
     *            Preceding Item of an SD Document
     */
    public void setBillingDocumentItem( @Nullable final String billingDocumentItem )
    {
        rememberChangedField("BillingDocumentItem", this.billingDocumentItem);
        this.billingDocumentItem = billingDocumentItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SubsequentDocument</b>
     * </p>
     *
     * @param subsequentDocument
     *            Subsequent Sales and Distribution Document
     */
    public void setSubsequentDocument( @Nullable final String subsequentDocument )
    {
        rememberChangedField("SubsequentDocument", this.subsequentDocument);
        this.subsequentDocument = subsequentDocument;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SubsequentDocumentItem</b>
     * </p>
     *
     * @param subsequentDocumentItem
     *            Subsequent Item of an SD Document
     */
    public void setSubsequentDocumentItem( @Nullable final String subsequentDocumentItem )
    {
        rememberChangedField("SubsequentDocumentItem", this.subsequentDocumentItem);
        this.subsequentDocumentItem = subsequentDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SubsequentDocumentCategory</b>
     * </p>
     *
     * @param subsequentDocumentCategory
     *            Document Category of Subsequent Document
     */
    public void setSubsequentDocumentCategory( @Nullable final String subsequentDocumentCategory )
    {
        rememberChangedField("SubsequentDocumentCategory", this.subsequentDocumentCategory);
        this.subsequentDocumentCategory = subsequentDocumentCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SDDocumentCategory</b>
     * </p>
     *
     * @param sDDocumentCategory
     *            SD Document Category
     */
    public void setSDDocumentCategory( @Nullable final String sDDocumentCategory )
    {
        rememberChangedField("SDDocumentCategory", this.sDDocumentCategory);
        this.sDDocumentCategory = sDDocumentCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProcessFlowLevel</b>
     * </p>
     *
     * @param processFlowLevel
     *            Level of the document flow record
     */
    public void setProcessFlowLevel( @Nullable final String processFlowLevel )
    {
        rememberChangedField("ProcessFlowLevel", this.processFlowLevel);
        this.processFlowLevel = processFlowLevel;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Record Created On
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     *
     * @param creationTime
     *            Entry time
     */
    public void setCreationTime( @Nullable final LocalTime creationTime )
    {
        rememberChangedField("CreationTime", this.creationTime);
        this.creationTime = creationTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *            Last Changed On
     */
    public void setLastChangeDate( @Nullable final LocalDateTime lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityInBaseUnit</b>
     * </p>
     *
     * @param quantityInBaseUnit
     *            Referenced quantity in base unit of measure
     */
    public void setQuantityInBaseUnit( @Nullable final BigDecimal quantityInBaseUnit )
    {
        rememberChangedField("QuantityInBaseUnit", this.quantityInBaseUnit);
        this.quantityInBaseUnit = quantityInBaseUnit;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RefQuantityInOrdQtyUnitAsFloat</b>
     * </p>
     *
     * @param refQuantityInOrdQtyUnitAsFloat
     *            Referenced quantity in sales unit (float)
     */
    public void setRefQuantityInOrdQtyUnitAsFloat( @Nullable final Double refQuantityInOrdQtyUnitAsFloat )
    {
        rememberChangedField("RefQuantityInOrdQtyUnitAsFloat", this.refQuantityInOrdQtyUnitAsFloat);
        this.refQuantityInOrdQtyUnitAsFloat = refQuantityInOrdQtyUnitAsFloat;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RefQuantityInBaseUnitAsFloat</b>
     * </p>
     *
     * @param refQuantityInBaseUnitAsFloat
     *            Referenced quantity in base unit of measure (float)
     */
    public void setRefQuantityInBaseUnitAsFloat( @Nullable final Double refQuantityInBaseUnitAsFloat )
    {
        rememberChangedField("RefQuantityInBaseUnitAsFloat", this.refQuantityInBaseUnitAsFloat);
        this.refQuantityInBaseUnitAsFloat = refQuantityInBaseUnitAsFloat;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @param baseUnit
     *            Base Unit of Measure
     */
    public void setBaseUnit( @Nullable final String baseUnit )
    {
        rememberChangedField("BaseUnit", this.baseUnit);
        this.baseUnit = baseUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantityUnit</b>
     * </p>
     *
     * @param orderQuantityUnit
     *            Sales Unit
     */
    public void setOrderQuantityUnit( @Nullable final String orderQuantityUnit )
    {
        rememberChangedField("OrderQuantityUnit", this.orderQuantityUnit);
        this.orderQuantityUnit = orderQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SDFulfillmentCalculationRule</b>
     * </p>
     *
     * @param sDFulfillmentCalculationRule
     *            Quantity is calculated positively, negatively or not at all
     */
    public void setSDFulfillmentCalculationRule( @Nullable final String sDFulfillmentCalculationRule )
    {
        rememberChangedField("SDFulfillmentCalculationRule", this.sDFulfillmentCalculationRule);
        this.sDFulfillmentCalculationRule = sDFulfillmentCalculationRule;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetAmount</b>
     * </p>
     *
     * @param netAmount
     *            Reference Value
     */
    public void setNetAmount( @Nullable final BigDecimal netAmount )
    {
        rememberChangedField("NetAmount", this.netAmount);
        this.netAmount = netAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>StatisticsCurrency</b>
     * </p>
     *
     * @param statisticsCurrency
     *            Statistics currency
     */
    public void setStatisticsCurrency( @Nullable final String statisticsCurrency )
    {
        rememberChangedField("StatisticsCurrency", this.statisticsCurrency);
        this.statisticsCurrency = statisticsCurrency;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>TransferOrderInWrhsMgmtIsConfd</b>
     * </p>
     *
     * @param transferOrderInWrhsMgmtIsConfd
     *            ID: MM-WM Transfer Order Confirmed
     */
    public void setTransferOrderInWrhsMgmtIsConfd( @Nullable final Boolean transferOrderInWrhsMgmtIsConfd )
    {
        rememberChangedField("TransferOrderInWrhsMgmtIsConfd", this.transferOrderInWrhsMgmtIsConfd);
        this.transferOrderInWrhsMgmtIsConfd = transferOrderInWrhsMgmtIsConfd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseNumber</b>
     * </p>
     *
     * @param warehouseNumber
     *            Warehouse Number / Warehouse Complex
     */
    public void setWarehouseNumber( @Nullable final String warehouseNumber )
    {
        rememberChangedField("WarehouseNumber", this.warehouseNumber);
        this.warehouseNumber = warehouseNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocumentYear</b>
     * </p>
     *
     * @param materialDocumentYear
     *            Material Document Year
     */
    public void setMaterialDocumentYear( @Nullable final String materialDocumentYear )
    {
        rememberChangedField("MaterialDocumentYear", this.materialDocumentYear);
        this.materialDocumentYear = materialDocumentYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlan</b>
     * </p>
     *
     * @param billingPlan
     *            Billing Plan Number / Invoicing Plan Number
     */
    public void setBillingPlan( @Nullable final String billingPlan )
    {
        rememberChangedField("BillingPlan", this.billingPlan);
        this.billingPlan = billingPlan;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanItem</b>
     * </p>
     *
     * @param billingPlanItem
     *            Item for billing plan/invoice plan/payment cards
     */
    public void setBillingPlanItem( @Nullable final String billingPlanItem )
    {
        rememberChangedField("BillingPlanItem", this.billingPlanItem);
        this.billingPlanItem = billingPlanItem;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SubsqntBillgDocForSelfBillg";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BillingDocument", getBillingDocument());
        result.put("BillingDocumentItem", getBillingDocumentItem());
        result.put("SubsequentDocument", getSubsequentDocument());
        result.put("SubsequentDocumentItem", getSubsequentDocumentItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BillingDocument", getBillingDocument());
        values.put("BillingDocumentItem", getBillingDocumentItem());
        values.put("SubsequentDocument", getSubsequentDocument());
        values.put("SubsequentDocumentItem", getSubsequentDocumentItem());
        values.put("SubsequentDocumentCategory", getSubsequentDocumentCategory());
        values.put("SDDocumentCategory", getSDDocumentCategory());
        values.put("ProcessFlowLevel", getProcessFlowLevel());
        values.put("CreationDate", getCreationDate());
        values.put("CreationTime", getCreationTime());
        values.put("LastChangeDate", getLastChangeDate());
        values.put("QuantityInBaseUnit", getQuantityInBaseUnit());
        values.put("RefQuantityInOrdQtyUnitAsFloat", getRefQuantityInOrdQtyUnitAsFloat());
        values.put("RefQuantityInBaseUnitAsFloat", getRefQuantityInBaseUnitAsFloat());
        values.put("BaseUnit", getBaseUnit());
        values.put("OrderQuantityUnit", getOrderQuantityUnit());
        values.put("SDFulfillmentCalculationRule", getSDFulfillmentCalculationRule());
        values.put("NetAmount", getNetAmount());
        values.put("StatisticsCurrency", getStatisticsCurrency());
        values.put("TransferOrderInWrhsMgmtIsConfd", getTransferOrderInWrhsMgmtIsConfd());
        values.put("WarehouseNumber", getWarehouseNumber());
        values.put("MaterialDocumentYear", getMaterialDocumentYear());
        values.put("BillingPlan", getBillingPlan());
        values.put("BillingPlanItem", getBillingPlanItem());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BillingDocument") ) {
                final Object value = values.remove("BillingDocument");
                if( (value == null) || (!value.equals(getBillingDocument())) ) {
                    setBillingDocument(((String) value));
                }
            }
            if( values.containsKey("BillingDocumentItem") ) {
                final Object value = values.remove("BillingDocumentItem");
                if( (value == null) || (!value.equals(getBillingDocumentItem())) ) {
                    setBillingDocumentItem(((String) value));
                }
            }
            if( values.containsKey("SubsequentDocument") ) {
                final Object value = values.remove("SubsequentDocument");
                if( (value == null) || (!value.equals(getSubsequentDocument())) ) {
                    setSubsequentDocument(((String) value));
                }
            }
            if( values.containsKey("SubsequentDocumentItem") ) {
                final Object value = values.remove("SubsequentDocumentItem");
                if( (value == null) || (!value.equals(getSubsequentDocumentItem())) ) {
                    setSubsequentDocumentItem(((String) value));
                }
            }
            if( values.containsKey("SubsequentDocumentCategory") ) {
                final Object value = values.remove("SubsequentDocumentCategory");
                if( (value == null) || (!value.equals(getSubsequentDocumentCategory())) ) {
                    setSubsequentDocumentCategory(((String) value));
                }
            }
            if( values.containsKey("SDDocumentCategory") ) {
                final Object value = values.remove("SDDocumentCategory");
                if( (value == null) || (!value.equals(getSDDocumentCategory())) ) {
                    setSDDocumentCategory(((String) value));
                }
            }
            if( values.containsKey("ProcessFlowLevel") ) {
                final Object value = values.remove("ProcessFlowLevel");
                if( (value == null) || (!value.equals(getProcessFlowLevel())) ) {
                    setProcessFlowLevel(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreationTime") ) {
                final Object value = values.remove("CreationTime");
                if( (value == null) || (!value.equals(getCreationTime())) ) {
                    setCreationTime(((LocalTime) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("QuantityInBaseUnit") ) {
                final Object value = values.remove("QuantityInBaseUnit");
                if( (value == null) || (!value.equals(getQuantityInBaseUnit())) ) {
                    setQuantityInBaseUnit(((BigDecimal) value));
                }
            }
            if( values.containsKey("RefQuantityInOrdQtyUnitAsFloat") ) {
                final Object value = values.remove("RefQuantityInOrdQtyUnitAsFloat");
                if( (value == null) || (!value.equals(getRefQuantityInOrdQtyUnitAsFloat())) ) {
                    setRefQuantityInOrdQtyUnitAsFloat(((Double) value));
                }
            }
            if( values.containsKey("RefQuantityInBaseUnitAsFloat") ) {
                final Object value = values.remove("RefQuantityInBaseUnitAsFloat");
                if( (value == null) || (!value.equals(getRefQuantityInBaseUnitAsFloat())) ) {
                    setRefQuantityInBaseUnitAsFloat(((Double) value));
                }
            }
            if( values.containsKey("BaseUnit") ) {
                final Object value = values.remove("BaseUnit");
                if( (value == null) || (!value.equals(getBaseUnit())) ) {
                    setBaseUnit(((String) value));
                }
            }
            if( values.containsKey("OrderQuantityUnit") ) {
                final Object value = values.remove("OrderQuantityUnit");
                if( (value == null) || (!value.equals(getOrderQuantityUnit())) ) {
                    setOrderQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("SDFulfillmentCalculationRule") ) {
                final Object value = values.remove("SDFulfillmentCalculationRule");
                if( (value == null) || (!value.equals(getSDFulfillmentCalculationRule())) ) {
                    setSDFulfillmentCalculationRule(((String) value));
                }
            }
            if( values.containsKey("NetAmount") ) {
                final Object value = values.remove("NetAmount");
                if( (value == null) || (!value.equals(getNetAmount())) ) {
                    setNetAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("StatisticsCurrency") ) {
                final Object value = values.remove("StatisticsCurrency");
                if( (value == null) || (!value.equals(getStatisticsCurrency())) ) {
                    setStatisticsCurrency(((String) value));
                }
            }
            if( values.containsKey("TransferOrderInWrhsMgmtIsConfd") ) {
                final Object value = values.remove("TransferOrderInWrhsMgmtIsConfd");
                if( (value == null) || (!value.equals(getTransferOrderInWrhsMgmtIsConfd())) ) {
                    setTransferOrderInWrhsMgmtIsConfd(((Boolean) value));
                }
            }
            if( values.containsKey("WarehouseNumber") ) {
                final Object value = values.remove("WarehouseNumber");
                if( (value == null) || (!value.equals(getWarehouseNumber())) ) {
                    setWarehouseNumber(((String) value));
                }
            }
            if( values.containsKey("MaterialDocumentYear") ) {
                final Object value = values.remove("MaterialDocumentYear");
                if( (value == null) || (!value.equals(getMaterialDocumentYear())) ) {
                    setMaterialDocumentYear(((String) value));
                }
            }
            if( values.containsKey("BillingPlan") ) {
                final Object value = values.remove("BillingPlan");
                if( (value == null) || (!value.equals(getBillingPlan())) ) {
                    setBillingPlan(((String) value));
                }
            }
            if( values.containsKey("BillingPlanItem") ) {
                final Object value = values.remove("BillingPlanItem");
                if( (value == null) || (!value.equals(getBillingPlanItem())) ) {
                    setBillingPlanItem(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> SubsqntBillgDocForSelfBillgField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new SubsqntBillgDocForSelfBillgField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SubsqntBillgDocForSelfBillgField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SubsqntBillgDocForSelfBillgField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SubsequentBillingDocumentService.DEFAULT_SERVICE_PATH);
    }

}
