/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.subsequentbillingdocument;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.subsequentbillingdocument.selectable.SubsqntBillgDocForSelfBillgSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.subsequentbillingdocument.SubsqntBillgDocForSelfBillg
 * SubsqntBillgDocForSelfBillg} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class SubsqntBillgDocForSelfBillgByKeyFluentHelper
    extends
    FluentHelperByKey<SubsqntBillgDocForSelfBillgByKeyFluentHelper, SubsqntBillgDocForSelfBillg, SubsqntBillgDocForSelfBillgSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.subsequentbillingdocument.SubsqntBillgDocForSelfBillg
     * SubsqntBillgDocForSelfBillg} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SubsqntBillgDocForSelfBillg}
     * @param subsequentDocumentItem
     *            Subsequent Item of an SD Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param billingDocumentItem
     *            Preceding Item of an SD Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code SubsqntBillgDocForSelfBillg}
     * @param billingDocument
     *            Billing Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param subsequentDocument
     *            Subsequent Sales and Distribution Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     */
    public SubsqntBillgDocForSelfBillgByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String billingDocument,
        final String billingDocumentItem,
        final String subsequentDocument,
        final String subsequentDocumentItem )
    {
        super(servicePath, entityCollection);
        this.key.put("BillingDocument", billingDocument);
        this.key.put("BillingDocumentItem", billingDocumentItem);
        this.key.put("SubsequentDocument", subsequentDocument);
        this.key.put("SubsequentDocumentItem", subsequentDocumentItem);
    }

    @Override
    @Nonnull
    protected Class<SubsqntBillgDocForSelfBillg> getEntityClass()
    {
        return SubsqntBillgDocForSelfBillg.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
