/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.subsequentbillingdocument.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link SubsequentBillingDocumentServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.SubsequentBillingDocumentService
 * SubsequentBillingDocumentService}, allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultSubsequentBillingDocumentServiceBatch
    extends
    BatchFluentHelperBasic<SubsequentBillingDocumentServiceBatch, SubsequentBillingDocumentServiceBatchChangeSet>
    implements
    SubsequentBillingDocumentServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SubsequentBillingDocumentService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultSubsequentBillingDocumentServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultSubsequentBillingDocumentServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SubsequentBillingDocumentService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.SubsequentBillingDocumentService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultSubsequentBillingDocumentServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultSubsequentBillingDocumentServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SubsequentBillingDocumentService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultSubsequentBillingDocumentServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public SubsequentBillingDocumentServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultSubsequentBillingDocumentServiceBatchChangeSet(this, service);
    }

}
