/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.subsequentbillingdocument.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link SubsequentBillingDocumentServiceBatchChangeSet} interface, enabling you to combine
 * multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.SubsequentBillingDocumentService
 * SubsequentBillingDocumentService}.
 *
 */
public class DefaultSubsequentBillingDocumentServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<SubsequentBillingDocumentServiceBatch, SubsequentBillingDocumentServiceBatchChangeSet>
    implements
    SubsequentBillingDocumentServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SubsequentBillingDocumentService service;

    @SuppressWarnings( "deprecation" )
    DefaultSubsequentBillingDocumentServiceBatchChangeSet(
        @Nonnull final DefaultSubsequentBillingDocumentServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SubsequentBillingDocumentService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultSubsequentBillingDocumentServiceBatchChangeSet getThis()
    {
        return this;
    }

}
