/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.subsequentbillingdocument.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.subsequentbillingdocument.SubsqntBillgDocForSelfBillg;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.subsequentbillingdocument.SubsqntBillgDocForSelfBillg
 * SubsqntBillgDocForSelfBillg}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.subsequentbillingdocument.field.SubsqntBillgDocForSelfBillgField
 * SubsqntBillgDocForSelfBillgField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.subsequentbillingdocument.link.SubsqntBillgDocForSelfBillgLink
 * SubsqntBillgDocForSelfBillgLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.subsequentbillingdocument.SubsqntBillgDocForSelfBillg#BILLING_DOCUMENT
 * BILLING_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.subsequentbillingdocument.SubsqntBillgDocForSelfBillg#BILLING_DOCUMENT_ITEM
 * BILLING_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.subsequentbillingdocument.SubsqntBillgDocForSelfBillg#SUBSEQUENT_DOCUMENT
 * SUBSEQUENT_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.subsequentbillingdocument.SubsqntBillgDocForSelfBillg#SUBSEQUENT_DOCUMENT_ITEM
 * SUBSEQUENT_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.subsequentbillingdocument.SubsqntBillgDocForSelfBillg#SUBSEQUENT_DOCUMENT_CATEGORY
 * SUBSEQUENT_DOCUMENT_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.subsequentbillingdocument.SubsqntBillgDocForSelfBillg#SD_DOCUMENT_CATEGORY
 * SD_DOCUMENT_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.subsequentbillingdocument.SubsqntBillgDocForSelfBillg#PROCESS_FLOW_LEVEL
 * PROCESS_FLOW_LEVEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.subsequentbillingdocument.SubsqntBillgDocForSelfBillg#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.subsequentbillingdocument.SubsqntBillgDocForSelfBillg#CREATION_TIME
 * CREATION_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.subsequentbillingdocument.SubsqntBillgDocForSelfBillg#LAST_CHANGE_DATE
 * LAST_CHANGE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.subsequentbillingdocument.SubsqntBillgDocForSelfBillg#QUANTITY_IN_BASE_UNIT
 * QUANTITY_IN_BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.subsequentbillingdocument.SubsqntBillgDocForSelfBillg#REF_QUANTITY_IN_ORD_QTY_UNIT_AS_FLOAT
 * REF_QUANTITY_IN_ORD_QTY_UNIT_AS_FLOAT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.subsequentbillingdocument.SubsqntBillgDocForSelfBillg#REF_QUANTITY_IN_BASE_UNIT_AS_FLOAT
 * REF_QUANTITY_IN_BASE_UNIT_AS_FLOAT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.subsequentbillingdocument.SubsqntBillgDocForSelfBillg#BASE_UNIT
 * BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.subsequentbillingdocument.SubsqntBillgDocForSelfBillg#ORDER_QUANTITY_UNIT
 * ORDER_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.subsequentbillingdocument.SubsqntBillgDocForSelfBillg#SD_FULFILLMENT_CALCULATION_RULE
 * SD_FULFILLMENT_CALCULATION_RULE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.subsequentbillingdocument.SubsqntBillgDocForSelfBillg#NET_AMOUNT
 * NET_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.subsequentbillingdocument.SubsqntBillgDocForSelfBillg#STATISTICS_CURRENCY
 * STATISTICS_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.subsequentbillingdocument.SubsqntBillgDocForSelfBillg#TRANSFER_ORDER_IN_WRHS_MGMT_IS_CONFD
 * TRANSFER_ORDER_IN_WRHS_MGMT_IS_CONFD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.subsequentbillingdocument.SubsqntBillgDocForSelfBillg#WAREHOUSE_NUMBER
 * WAREHOUSE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.subsequentbillingdocument.SubsqntBillgDocForSelfBillg#MATERIAL_DOCUMENT_YEAR
 * MATERIAL_DOCUMENT_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.subsequentbillingdocument.SubsqntBillgDocForSelfBillg#BILLING_PLAN
 * BILLING_PLAN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.subsequentbillingdocument.SubsqntBillgDocForSelfBillg#BILLING_PLAN_ITEM
 * BILLING_PLAN_ITEM}</li>
 * </ul>
 *
 */
public interface SubsqntBillgDocForSelfBillgSelectable extends EntitySelectable<SubsqntBillgDocForSelfBillg>
{

}
