/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.field.SuplrActyDescriptionField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.selectable.SuplrActyDescriptionSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Description
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SuplrActyDescriptionType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SuplrActyDescription extends VdmEntity<SuplrActyDescription>
{

    /**
     * Selector for all available fields of SuplrActyDescription.
     *
     */
    public final static SuplrActyDescriptionSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SuplrActyUUID</b>
     * </p>
     *
     * @return Activity UUID
     */
    @Key
    @SerializedName( "SuplrActyUUID" )
    @JsonProperty( "SuplrActyUUID" )
    @Nullable
    @ODataField( odataName = "SuplrActyUUID" )
    private UUID suplrActyUUID;
    /**
     * Use with available fluent helpers to apply the <b>SuplrActyUUID</b> field to query operations.
     *
     */
    public final static SuplrActyDescriptionField<UUID> SUPLR_ACTY_UUID =
        new SuplrActyDescriptionField<UUID>("SuplrActyUUID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static SuplrActyDescriptionField<String> LANGUAGE = new SuplrActyDescriptionField<String>("Language");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrActyDescription</b>
     * </p>
     *
     * @return Text Content
     */
    @SerializedName( "SuplrActyDescription" )
    @JsonProperty( "SuplrActyDescription" )
    @Nullable
    @ODataField( odataName = "SuplrActyDescription" )
    private String suplrActyDescription;
    /**
     * Use with available fluent helpers to apply the <b>SuplrActyDescription</b> field to query operations.
     *
     */
    public final static SuplrActyDescriptionField<String> SUPLR_ACTY_DESCRIPTION =
        new SuplrActyDescriptionField<String>("SuplrActyDescription");

    @Nonnull
    @Override
    public Class<SuplrActyDescription> getType()
    {
        return SuplrActyDescription.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SuplrActyUUID</b>
     * </p>
     *
     * @param suplrActyUUID
     *            Activity UUID
     */
    public void setSuplrActyUUID( @Nullable final UUID suplrActyUUID )
    {
        rememberChangedField("SuplrActyUUID", this.suplrActyUUID);
        this.suplrActyUUID = suplrActyUUID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrActyDescription</b>
     * </p>
     *
     * @param suplrActyDescription
     *            Text Content
     */
    public void setSuplrActyDescription( @Nullable final String suplrActyDescription )
    {
        rememberChangedField("SuplrActyDescription", this.suplrActyDescription);
        this.suplrActyDescription = suplrActyDescription;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SuplrActyDescription";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SuplrActyUUID", getSuplrActyUUID());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SuplrActyUUID", getSuplrActyUUID());
        values.put("Language", getLanguage());
        values.put("SuplrActyDescription", getSuplrActyDescription());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SuplrActyUUID") ) {
                final Object value = values.remove("SuplrActyUUID");
                if( (value == null) || (!value.equals(getSuplrActyUUID())) ) {
                    setSuplrActyUUID(((UUID) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("SuplrActyDescription") ) {
                final Object value = values.remove("SuplrActyDescription");
                if( (value == null) || (!value.equals(getSuplrActyDescription())) ) {
                    setSuplrActyDescription(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SuplrActyDescriptionField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SuplrActyDescriptionField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SuplrActyDescriptionField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SuplrActyDescriptionField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierActivityService.DEFAULT_SERVICE_PATH);
    }

}
