/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.field.SuplrActyParticipantField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.selectable.SuplrActyParticipantSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Participant
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SuplrActyParticipantType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SuplrActyParticipant extends VdmEntity<SuplrActyParticipant>
{

    /**
     * Selector for all available fields of SuplrActyParticipant.
     *
     */
    public final static SuplrActyParticipantSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SuplrActyPartyUUID</b>
     * </p>
     *
     * @return Activity Party UUID
     */
    @Key
    @SerializedName( "SuplrActyPartyUUID" )
    @JsonProperty( "SuplrActyPartyUUID" )
    @Nullable
    @ODataField( odataName = "SuplrActyPartyUUID" )
    private UUID suplrActyPartyUUID;
    /**
     * Use with available fluent helpers to apply the <b>SuplrActyPartyUUID</b> field to query operations.
     *
     */
    public final static SuplrActyParticipantField<UUID> SUPLR_ACTY_PARTY_UUID =
        new SuplrActyParticipantField<UUID>("SuplrActyPartyUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrActyUUID</b>
     * </p>
     *
     * @return Activity UUID
     */
    @SerializedName( "SuplrActyUUID" )
    @JsonProperty( "SuplrActyUUID" )
    @Nullable
    @ODataField( odataName = "SuplrActyUUID" )
    private UUID suplrActyUUID;
    /**
     * Use with available fluent helpers to apply the <b>SuplrActyUUID</b> field to query operations.
     *
     */
    public final static SuplrActyParticipantField<UUID> SUPLR_ACTY_UUID =
        new SuplrActyParticipantField<UUID>("SuplrActyUUID");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>UserID</b>
     * </p>
     *
     * @return User ID
     */
    @SerializedName( "UserID" )
    @JsonProperty( "UserID" )
    @Nullable
    @ODataField( odataName = "UserID" )
    private String userID;
    /**
     * Use with available fluent helpers to apply the <b>UserID</b> field to query operations.
     *
     */
    public final static SuplrActyParticipantField<String> USER_ID = new SuplrActyParticipantField<String>("UserID");

    @Nonnull
    @Override
    public Class<SuplrActyParticipant> getType()
    {
        return SuplrActyParticipant.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SuplrActyPartyUUID</b>
     * </p>
     *
     * @param suplrActyPartyUUID
     *            Activity Party UUID
     */
    public void setSuplrActyPartyUUID( @Nullable final UUID suplrActyPartyUUID )
    {
        rememberChangedField("SuplrActyPartyUUID", this.suplrActyPartyUUID);
        this.suplrActyPartyUUID = suplrActyPartyUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrActyUUID</b>
     * </p>
     *
     * @param suplrActyUUID
     *            Activity UUID
     */
    public void setSuplrActyUUID( @Nullable final UUID suplrActyUUID )
    {
        rememberChangedField("SuplrActyUUID", this.suplrActyUUID);
        this.suplrActyUUID = suplrActyUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>UserID</b>
     * </p>
     *
     * @param userID
     *            User ID
     */
    public void setUserID( @Nullable final String userID )
    {
        rememberChangedField("UserID", this.userID);
        this.userID = userID;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SuplrActyParticipant";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SuplrActyPartyUUID", getSuplrActyPartyUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SuplrActyPartyUUID", getSuplrActyPartyUUID());
        values.put("SuplrActyUUID", getSuplrActyUUID());
        values.put("UserID", getUserID());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SuplrActyPartyUUID") ) {
                final Object value = values.remove("SuplrActyPartyUUID");
                if( (value == null) || (!value.equals(getSuplrActyPartyUUID())) ) {
                    setSuplrActyPartyUUID(((UUID) value));
                }
            }
            if( values.containsKey("SuplrActyUUID") ) {
                final Object value = values.remove("SuplrActyUUID");
                if( (value == null) || (!value.equals(getSuplrActyUUID())) ) {
                    setSuplrActyUUID(((UUID) value));
                }
            }
            if( values.containsKey("UserID") ) {
                final Object value = values.remove("UserID");
                if( (value == null) || (!value.equals(getUserID())) ) {
                    setUserID(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SuplrActyParticipantField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SuplrActyParticipantField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SuplrActyParticipantField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SuplrActyParticipantField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierActivityService.DEFAULT_SERVICE_PATH);
    }

}
