/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity;

import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.field.SupplierActivityField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.link.SupplierActivityLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.link.SupplierActivityOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.selectable.SupplierActivitySelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Procurement-Related Activity
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SupplierActivityType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SupplierActivity extends VdmEntity<SupplierActivity>
{

    /**
     * Selector for all available fields of SupplierActivity.
     *
     */
    public final static SupplierActivitySelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SuplrActyUUID</b>
     * </p>
     *
     * @return Activity UUID
     */
    @Key
    @SerializedName( "SuplrActyUUID" )
    @JsonProperty( "SuplrActyUUID" )
    @Nullable
    @ODataField( odataName = "SuplrActyUUID" )
    private UUID suplrActyUUID;
    /**
     * Use with available fluent helpers to apply the <b>SuplrActyUUID</b> field to query operations.
     *
     */
    public final static SupplierActivityField<UUID> SUPLR_ACTY_UUID = new SupplierActivityField<UUID>("SuplrActyUUID");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SupplierActivity</b>
     * </p>
     *
     * @return Activity
     */
    @SerializedName( "SupplierActivity" )
    @JsonProperty( "SupplierActivity" )
    @Nullable
    @ODataField( odataName = "SupplierActivity" )
    private String supplierActivity;
    /**
     * Use with available fluent helpers to apply the <b>SupplierActivity</b> field to query operations.
     *
     */
    public final static SupplierActivityField<String> SUPPLIER_ACTIVITY =
        new SupplierActivityField<String>("SupplierActivity");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PurgCatUUID</b>
     * </p>
     *
     * @return Purchasing Category UUID
     */
    @SerializedName( "PurgCatUUID" )
    @JsonProperty( "PurgCatUUID" )
    @Nullable
    @ODataField( odataName = "PurgCatUUID" )
    private UUID purgCatUUID;
    /**
     * Use with available fluent helpers to apply the <b>PurgCatUUID</b> field to query operations.
     *
     */
    public final static SupplierActivityField<UUID> PURG_CAT_UUID = new SupplierActivityField<UUID>("PurgCatUUID");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SuplrActyName</b>
     * </p>
     *
     * @return Name of Activity
     */
    @SerializedName( "SuplrActyName" )
    @JsonProperty( "SuplrActyName" )
    @Nullable
    @ODataField( odataName = "SuplrActyName" )
    private String suplrActyName;
    /**
     * Use with available fluent helpers to apply the <b>SuplrActyName</b> field to query operations.
     *
     */
    public final static SupplierActivityField<String> SUPLR_ACTY_NAME =
        new SupplierActivityField<String>("SuplrActyName");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>StartDate</b>
     * </p>
     *
     * @return Start Date
     */
    @SerializedName( "StartDate" )
    @JsonProperty( "StartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "StartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime startDate;
    /**
     * Use with available fluent helpers to apply the <b>StartDate</b> field to query operations.
     *
     */
    public final static SupplierActivityField<LocalDateTime> START_DATE =
        new SupplierActivityField<LocalDateTime>("StartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>EndDate</b>
     * </p>
     *
     * @return End Date
     */
    @SerializedName( "EndDate" )
    @JsonProperty( "EndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "EndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime endDate;
    /**
     * Use with available fluent helpers to apply the <b>EndDate</b> field to query operations.
     *
     */
    public final static SupplierActivityField<LocalDateTime> END_DATE =
        new SupplierActivityField<LocalDateTime>("EndDate");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SuplrActyPriority</b>
     * </p>
     *
     * @return Priority of an activity
     */
    @SerializedName( "SuplrActyPriority" )
    @JsonProperty( "SuplrActyPriority" )
    @Nullable
    @ODataField( odataName = "SuplrActyPriority" )
    private String suplrActyPriority;
    /**
     * Use with available fluent helpers to apply the <b>SuplrActyPriority</b> field to query operations.
     *
     */
    public final static SupplierActivityField<String> SUPLR_ACTY_PRIORITY =
        new SupplierActivityField<String>("SuplrActyPriority");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SuplrActyType</b>
     * </p>
     *
     * @return Activity type
     */
    @SerializedName( "SuplrActyType" )
    @JsonProperty( "SuplrActyType" )
    @Nullable
    @ODataField( odataName = "SuplrActyType" )
    private String suplrActyType;
    /**
     * Use with available fluent helpers to apply the <b>SuplrActyType</b> field to query operations.
     *
     */
    public final static SupplierActivityField<String> SUPLR_ACTY_TYPE =
        new SupplierActivityField<String>("SuplrActyType");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Created-By Name
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static SupplierActivityField<String> CREATED_BY_USER =
        new SupplierActivityField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @return Created On
     */
    @SerializedName( "CreationDateTime" )
    @JsonProperty( "CreationDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime creationDateTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationDateTime</b> field to query operations.
     *
     */
    public final static SupplierActivityField<ZonedDateTime> CREATION_DATE_TIME =
        new SupplierActivityField<ZonedDateTime>("CreationDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Changed-By Name
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static SupplierActivityField<String> LAST_CHANGED_BY_USER =
        new SupplierActivityField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return Last Changed On
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static SupplierActivityField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new SupplierActivityField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SuplrActyLifecycleStatus</b>
     * </p>
     *
     * @return Lifecycle Status Code for Activities
     */
    @SerializedName( "SuplrActyLifecycleStatus" )
    @JsonProperty( "SuplrActyLifecycleStatus" )
    @Nullable
    @ODataField( odataName = "SuplrActyLifecycleStatus" )
    private String suplrActyLifecycleStatus;
    /**
     * Use with available fluent helpers to apply the <b>SuplrActyLifecycleStatus</b> field to query operations.
     *
     */
    public final static SupplierActivityField<String> SUPLR_ACTY_LIFECYCLE_STATUS =
        new SupplierActivityField<String>("SuplrActyLifecycleStatus");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language
     */
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static SupplierActivityField<String> LANGUAGE = new SupplierActivityField<String>("Language");
    /**
     * Navigation property <b>to_SuplrActyDescription</b> for <b>SupplierActivity</b> to multiple
     * <b>SuplrActyDescription</b>.
     *
     */
    @SerializedName( "to_SuplrActyDescription" )
    @JsonProperty( "to_SuplrActyDescription" )
    @ODataField( odataName = "to_SuplrActyDescription" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SuplrActyDescription> toSuplrActyDescription;
    /**
     * Navigation property <b>to_SuplrActyParticipant</b> for <b>SupplierActivity</b> to single
     * <b>SuplrActyParticipant</b>.
     *
     */
    @SerializedName( "to_SuplrActyParticipant" )
    @JsonProperty( "to_SuplrActyParticipant" )
    @ODataField( odataName = "to_SuplrActyParticipant" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SuplrActyParticipant toSuplrActyParticipant;
    /**
     * Navigation property <b>to_SuplrActyPurchaserResp</b> for <b>SupplierActivity</b> to single
     * <b>SuplrActyPurchaserResp</b>.
     *
     */
    @SerializedName( "to_SuplrActyPurchaserResp" )
    @JsonProperty( "to_SuplrActyPurchaserResp" )
    @ODataField( odataName = "to_SuplrActyPurchaserResp" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SuplrActyPurchaserResp toSuplrActyPurchaserResp;
    /**
     * Navigation property <b>to_SuplrActySupplier</b> for <b>SupplierActivity</b> to multiple <b>SuplrActySupplier</b>.
     *
     */
    @SerializedName( "to_SuplrActySupplier" )
    @JsonProperty( "to_SuplrActySupplier" )
    @ODataField( odataName = "to_SuplrActySupplier" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SuplrActySupplier> toSuplrActySupplier;
    /**
     * Use with available fluent helpers to apply the <b>to_SuplrActyDescription</b> navigation property to query
     * operations.
     *
     */
    public final static SupplierActivityLink<SuplrActyDescription> TO_SUPLR_ACTY_DESCRIPTION =
        new SupplierActivityLink<SuplrActyDescription>("to_SuplrActyDescription");
    /**
     * Use with available fluent helpers to apply the <b>to_SuplrActyParticipant</b> navigation property to query
     * operations.
     *
     */
    public final static SupplierActivityOneToOneLink<SuplrActyParticipant> TO_SUPLR_ACTY_PARTICIPANT =
        new SupplierActivityOneToOneLink<SuplrActyParticipant>("to_SuplrActyParticipant");
    /**
     * Use with available fluent helpers to apply the <b>to_SuplrActyPurchaserResp</b> navigation property to query
     * operations.
     *
     */
    public final static SupplierActivityOneToOneLink<SuplrActyPurchaserResp> TO_SUPLR_ACTY_PURCHASER_RESP =
        new SupplierActivityOneToOneLink<SuplrActyPurchaserResp>("to_SuplrActyPurchaserResp");
    /**
     * Use with available fluent helpers to apply the <b>to_SuplrActySupplier</b> navigation property to query
     * operations.
     *
     */
    public final static SupplierActivityLink<SuplrActySupplier> TO_SUPLR_ACTY_SUPPLIER =
        new SupplierActivityLink<SuplrActySupplier>("to_SuplrActySupplier");

    @Nonnull
    @Override
    public Class<SupplierActivity> getType()
    {
        return SupplierActivity.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SuplrActyUUID</b>
     * </p>
     *
     * @param suplrActyUUID
     *            Activity UUID
     */
    public void setSuplrActyUUID( @Nullable final UUID suplrActyUUID )
    {
        rememberChangedField("SuplrActyUUID", this.suplrActyUUID);
        this.suplrActyUUID = suplrActyUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SupplierActivity</b>
     * </p>
     *
     * @param supplierActivity
     *            Activity
     */
    public void setSupplierActivity( @Nullable final String supplierActivity )
    {
        rememberChangedField("SupplierActivity", this.supplierActivity);
        this.supplierActivity = supplierActivity;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PurgCatUUID</b>
     * </p>
     *
     * @param purgCatUUID
     *            Purchasing Category UUID
     */
    public void setPurgCatUUID( @Nullable final UUID purgCatUUID )
    {
        rememberChangedField("PurgCatUUID", this.purgCatUUID);
        this.purgCatUUID = purgCatUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SuplrActyName</b>
     * </p>
     *
     * @param suplrActyName
     *            Name of Activity
     */
    public void setSuplrActyName( @Nullable final String suplrActyName )
    {
        rememberChangedField("SuplrActyName", this.suplrActyName);
        this.suplrActyName = suplrActyName;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>StartDate</b>
     * </p>
     *
     * @param startDate
     *            Start Date
     */
    public void setStartDate( @Nullable final LocalDateTime startDate )
    {
        rememberChangedField("StartDate", this.startDate);
        this.startDate = startDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>EndDate</b>
     * </p>
     *
     * @param endDate
     *            End Date
     */
    public void setEndDate( @Nullable final LocalDateTime endDate )
    {
        rememberChangedField("EndDate", this.endDate);
        this.endDate = endDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SuplrActyPriority</b>
     * </p>
     *
     * @param suplrActyPriority
     *            Priority of an activity
     */
    public void setSuplrActyPriority( @Nullable final String suplrActyPriority )
    {
        rememberChangedField("SuplrActyPriority", this.suplrActyPriority);
        this.suplrActyPriority = suplrActyPriority;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SuplrActyType</b>
     * </p>
     *
     * @param suplrActyType
     *            Activity type
     */
    public void setSuplrActyType( @Nullable final String suplrActyType )
    {
        rememberChangedField("SuplrActyType", this.suplrActyType);
        this.suplrActyType = suplrActyType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Created-By Name
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @param creationDateTime
     *            Created On
     */
    public void setCreationDateTime( @Nullable final ZonedDateTime creationDateTime )
    {
        rememberChangedField("CreationDateTime", this.creationDateTime);
        this.creationDateTime = creationDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Changed-By Name
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            Last Changed On
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SuplrActyLifecycleStatus</b>
     * </p>
     *
     * @param suplrActyLifecycleStatus
     *            Lifecycle Status Code for Activities
     */
    public void setSuplrActyLifecycleStatus( @Nullable final String suplrActyLifecycleStatus )
    {
        rememberChangedField("SuplrActyLifecycleStatus", this.suplrActyLifecycleStatus);
        this.suplrActyLifecycleStatus = suplrActyLifecycleStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SupplierActivity";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SuplrActyUUID", getSuplrActyUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SuplrActyUUID", getSuplrActyUUID());
        values.put("SupplierActivity", getSupplierActivity());
        values.put("PurgCatUUID", getPurgCatUUID());
        values.put("SuplrActyName", getSuplrActyName());
        values.put("StartDate", getStartDate());
        values.put("EndDate", getEndDate());
        values.put("SuplrActyPriority", getSuplrActyPriority());
        values.put("SuplrActyType", getSuplrActyType());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDateTime", getCreationDateTime());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("SuplrActyLifecycleStatus", getSuplrActyLifecycleStatus());
        values.put("Language", getLanguage());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SuplrActyUUID") ) {
                final Object value = values.remove("SuplrActyUUID");
                if( (value == null) || (!value.equals(getSuplrActyUUID())) ) {
                    setSuplrActyUUID(((UUID) value));
                }
            }
            if( values.containsKey("SupplierActivity") ) {
                final Object value = values.remove("SupplierActivity");
                if( (value == null) || (!value.equals(getSupplierActivity())) ) {
                    setSupplierActivity(((String) value));
                }
            }
            if( values.containsKey("PurgCatUUID") ) {
                final Object value = values.remove("PurgCatUUID");
                if( (value == null) || (!value.equals(getPurgCatUUID())) ) {
                    setPurgCatUUID(((UUID) value));
                }
            }
            if( values.containsKey("SuplrActyName") ) {
                final Object value = values.remove("SuplrActyName");
                if( (value == null) || (!value.equals(getSuplrActyName())) ) {
                    setSuplrActyName(((String) value));
                }
            }
            if( values.containsKey("StartDate") ) {
                final Object value = values.remove("StartDate");
                if( (value == null) || (!value.equals(getStartDate())) ) {
                    setStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("EndDate") ) {
                final Object value = values.remove("EndDate");
                if( (value == null) || (!value.equals(getEndDate())) ) {
                    setEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("SuplrActyPriority") ) {
                final Object value = values.remove("SuplrActyPriority");
                if( (value == null) || (!value.equals(getSuplrActyPriority())) ) {
                    setSuplrActyPriority(((String) value));
                }
            }
            if( values.containsKey("SuplrActyType") ) {
                final Object value = values.remove("SuplrActyType");
                if( (value == null) || (!value.equals(getSuplrActyType())) ) {
                    setSuplrActyType(((String) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("CreationDateTime") ) {
                final Object value = values.remove("CreationDateTime");
                if( (value == null) || (!value.equals(getCreationDateTime())) ) {
                    setCreationDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("SuplrActyLifecycleStatus") ) {
                final Object value = values.remove("SuplrActyLifecycleStatus");
                if( (value == null) || (!value.equals(getSuplrActyLifecycleStatus())) ) {
                    setSuplrActyLifecycleStatus(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_SuplrActyDescription") ) {
                final Object value = (values).remove("to_SuplrActyDescription");
                if( value instanceof Iterable ) {
                    if( toSuplrActyDescription == null ) {
                        toSuplrActyDescription = Lists.newArrayList();
                    } else {
                        toSuplrActyDescription = Lists.newArrayList(toSuplrActyDescription);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SuplrActyDescription entity;
                        if( toSuplrActyDescription.size() > i ) {
                            entity = toSuplrActyDescription.get(i);
                        } else {
                            entity = new SuplrActyDescription();
                            toSuplrActyDescription.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_SuplrActyParticipant") ) {
                final Object value = (values).remove("to_SuplrActyParticipant");
                if( value instanceof Map ) {
                    if( toSuplrActyParticipant == null ) {
                        toSuplrActyParticipant = new SuplrActyParticipant();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSuplrActyParticipant.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_SuplrActyPurchaserResp") ) {
                final Object value = (values).remove("to_SuplrActyPurchaserResp");
                if( value instanceof Map ) {
                    if( toSuplrActyPurchaserResp == null ) {
                        toSuplrActyPurchaserResp = new SuplrActyPurchaserResp();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSuplrActyPurchaserResp.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_SuplrActySupplier") ) {
                final Object value = (values).remove("to_SuplrActySupplier");
                if( value instanceof Iterable ) {
                    if( toSuplrActySupplier == null ) {
                        toSuplrActySupplier = Lists.newArrayList();
                    } else {
                        toSuplrActySupplier = Lists.newArrayList(toSuplrActySupplier);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SuplrActySupplier entity;
                        if( toSuplrActySupplier.size() > i ) {
                            entity = toSuplrActySupplier.get(i);
                        } else {
                            entity = new SuplrActySupplier();
                            toSuplrActySupplier.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SupplierActivityField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SupplierActivityField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SupplierActivityField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SupplierActivityField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierActivityService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toSuplrActyDescription != null ) {
            (values).put("to_SuplrActyDescription", toSuplrActyDescription);
        }
        if( toSuplrActyParticipant != null ) {
            (values).put("to_SuplrActyParticipant", toSuplrActyParticipant);
        }
        if( toSuplrActyPurchaserResp != null ) {
            (values).put("to_SuplrActyPurchaserResp", toSuplrActyPurchaserResp);
        }
        if( toSuplrActySupplier != null ) {
            (values).put("to_SuplrActySupplier", toSuplrActySupplier);
        }
        return values;
    }

    /**
     * Fetches the <b>SuplrActyDescription</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_SuplrActyDescription</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SuplrActyDescription</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SuplrActyDescription> fetchSuplrActyDescription()
    {
        return fetchFieldAsList("to_SuplrActyDescription", SuplrActyDescription.class);
    }

    /**
     * Retrieval of associated <b>SuplrActyDescription</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SuplrActyDescription</b>.
     * <p>
     * If the navigation property <b>to_SuplrActyDescription</b> of a queried <b>SupplierActivity</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SuplrActyDescription</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SuplrActyDescription> getSuplrActyDescriptionOrFetch()
    {
        if( toSuplrActyDescription == null ) {
            toSuplrActyDescription = fetchSuplrActyDescription();
        }
        return toSuplrActyDescription;
    }

    /**
     * Retrieval of associated <b>SuplrActyDescription</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SuplrActyDescription</b>.
     * <p>
     * If the navigation property for an entity <b>SupplierActivity</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SuplrActyDescription</b> is already loaded, the result
     *         will contain the <b>SuplrActyDescription</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SuplrActyDescription>> getSuplrActyDescriptionIfPresent()
    {
        return Option.of(toSuplrActyDescription);
    }

    /**
     * Overwrites the list of associated <b>SuplrActyDescription</b> entities for the loaded navigation property
     * <b>to_SuplrActyDescription</b>.
     * <p>
     * If the navigation property <b>to_SuplrActyDescription</b> of a queried <b>SupplierActivity</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SuplrActyDescription</b> entities.
     */
    public void setSuplrActyDescription( @Nonnull final List<SuplrActyDescription> value )
    {
        if( toSuplrActyDescription == null ) {
            toSuplrActyDescription = Lists.newArrayList();
        }
        toSuplrActyDescription.clear();
        toSuplrActyDescription.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SuplrActyDescription</b> entities. This corresponds to the OData
     * navigation property <b>to_SuplrActyDescription</b>.
     * <p>
     * If the navigation property <b>to_SuplrActyDescription</b> of a queried <b>SupplierActivity</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SuplrActyDescription</b> entities.
     */
    public void addSuplrActyDescription( SuplrActyDescription... entity )
    {
        if( toSuplrActyDescription == null ) {
            toSuplrActyDescription = Lists.newArrayList();
        }
        toSuplrActyDescription.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SuplrActyParticipant</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_SuplrActyParticipant</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SuplrActyParticipant</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SuplrActyParticipant fetchSuplrActyParticipant()
    {
        return fetchFieldAsSingle("to_SuplrActyParticipant", SuplrActyParticipant.class);
    }

    /**
     * Retrieval of associated <b>SuplrActyParticipant</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_SuplrActyParticipant</b>.
     * <p>
     * If the navigation property <b>to_SuplrActyParticipant</b> of a queried <b>SupplierActivity</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SuplrActyParticipant</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SuplrActyParticipant getSuplrActyParticipantOrFetch()
    {
        if( toSuplrActyParticipant == null ) {
            toSuplrActyParticipant = fetchSuplrActyParticipant();
        }
        return toSuplrActyParticipant;
    }

    /**
     * Retrieval of associated <b>SuplrActyParticipant</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_SuplrActyParticipant</b>.
     * <p>
     * If the navigation property for an entity <b>SupplierActivity</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SuplrActyParticipant</b> is already loaded, the result
     *         will contain the <b>SuplrActyParticipant</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SuplrActyParticipant> getSuplrActyParticipantIfPresent()
    {
        return Option.of(toSuplrActyParticipant);
    }

    /**
     * Overwrites the associated <b>SuplrActyParticipant</b> entity for the loaded navigation property
     * <b>to_SuplrActyParticipant</b>.
     *
     * @param value
     *            New <b>SuplrActyParticipant</b> entity.
     */
    public void setSuplrActyParticipant( final SuplrActyParticipant value )
    {
        toSuplrActyParticipant = value;
    }

    /**
     * Fetches the <b>SuplrActyPurchaserResp</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_SuplrActyPurchaserResp</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SuplrActyPurchaserResp</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SuplrActyPurchaserResp fetchSuplrActyPurchaserResp()
    {
        return fetchFieldAsSingle("to_SuplrActyPurchaserResp", SuplrActyPurchaserResp.class);
    }

    /**
     * Retrieval of associated <b>SuplrActyPurchaserResp</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_SuplrActyPurchaserResp</b>.
     * <p>
     * If the navigation property <b>to_SuplrActyPurchaserResp</b> of a queried <b>SupplierActivity</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SuplrActyPurchaserResp</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SuplrActyPurchaserResp getSuplrActyPurchaserRespOrFetch()
    {
        if( toSuplrActyPurchaserResp == null ) {
            toSuplrActyPurchaserResp = fetchSuplrActyPurchaserResp();
        }
        return toSuplrActyPurchaserResp;
    }

    /**
     * Retrieval of associated <b>SuplrActyPurchaserResp</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_SuplrActyPurchaserResp</b>.
     * <p>
     * If the navigation property for an entity <b>SupplierActivity</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SuplrActyPurchaserResp</b> is already loaded, the result
     *         will contain the <b>SuplrActyPurchaserResp</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SuplrActyPurchaserResp> getSuplrActyPurchaserRespIfPresent()
    {
        return Option.of(toSuplrActyPurchaserResp);
    }

    /**
     * Overwrites the associated <b>SuplrActyPurchaserResp</b> entity for the loaded navigation property
     * <b>to_SuplrActyPurchaserResp</b>.
     *
     * @param value
     *            New <b>SuplrActyPurchaserResp</b> entity.
     */
    public void setSuplrActyPurchaserResp( final SuplrActyPurchaserResp value )
    {
        toSuplrActyPurchaserResp = value;
    }

    /**
     * Fetches the <b>SuplrActySupplier</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_SuplrActySupplier</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SuplrActySupplier</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SuplrActySupplier> fetchSuplrActySupplier()
    {
        return fetchFieldAsList("to_SuplrActySupplier", SuplrActySupplier.class);
    }

    /**
     * Retrieval of associated <b>SuplrActySupplier</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_SuplrActySupplier</b>.
     * <p>
     * If the navigation property <b>to_SuplrActySupplier</b> of a queried <b>SupplierActivity</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SuplrActySupplier</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SuplrActySupplier> getSuplrActySupplierOrFetch()
    {
        if( toSuplrActySupplier == null ) {
            toSuplrActySupplier = fetchSuplrActySupplier();
        }
        return toSuplrActySupplier;
    }

    /**
     * Retrieval of associated <b>SuplrActySupplier</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_SuplrActySupplier</b>.
     * <p>
     * If the navigation property for an entity <b>SupplierActivity</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SuplrActySupplier</b> is already loaded, the result will
     *         contain the <b>SuplrActySupplier</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SuplrActySupplier>> getSuplrActySupplierIfPresent()
    {
        return Option.of(toSuplrActySupplier);
    }

    /**
     * Overwrites the list of associated <b>SuplrActySupplier</b> entities for the loaded navigation property
     * <b>to_SuplrActySupplier</b>.
     * <p>
     * If the navigation property <b>to_SuplrActySupplier</b> of a queried <b>SupplierActivity</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SuplrActySupplier</b> entities.
     */
    public void setSuplrActySupplier( @Nonnull final List<SuplrActySupplier> value )
    {
        if( toSuplrActySupplier == null ) {
            toSuplrActySupplier = Lists.newArrayList();
        }
        toSuplrActySupplier.clear();
        toSuplrActySupplier.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SuplrActySupplier</b> entities. This corresponds to the OData
     * navigation property <b>to_SuplrActySupplier</b>.
     * <p>
     * If the navigation property <b>to_SuplrActySupplier</b> of a queried <b>SupplierActivity</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SuplrActySupplier</b> entities.
     */
    public void addSuplrActySupplier( SuplrActySupplier... entity )
    {
        if( toSuplrActySupplier == null ) {
            toSuplrActySupplier = Lists.newArrayList();
        }
        toSuplrActySupplier.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of SupplierActivity instances.
     *
     */
    public final static class SupplierActivityBuilder
    {

        private List<SuplrActyDescription> toSuplrActyDescription = Lists.newArrayList();
        private SuplrActyParticipant toSuplrActyParticipant;
        private SuplrActyPurchaserResp toSuplrActyPurchaserResp;
        private List<SuplrActySupplier> toSuplrActySupplier = Lists.newArrayList();

        private SupplierActivity.SupplierActivityBuilder toSuplrActyDescription(
            final List<SuplrActyDescription> value )
        {
            toSuplrActyDescription.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SuplrActyDescription</b> for <b>SupplierActivity</b> to multiple
         * <b>SuplrActyDescription</b>.
         *
         * @param value
         *            The SuplrActyDescriptions to build this SupplierActivity with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SupplierActivity.SupplierActivityBuilder suplrActyDescription( SuplrActyDescription... value )
        {
            return toSuplrActyDescription(Lists.newArrayList(value));
        }

        private SupplierActivity.SupplierActivityBuilder toSuplrActyParticipant( final SuplrActyParticipant value )
        {
            toSuplrActyParticipant = value;
            return this;
        }

        /**
         * Navigation property <b>to_SuplrActyParticipant</b> for <b>SupplierActivity</b> to single
         * <b>SuplrActyParticipant</b>.
         *
         * @param value
         *            The SuplrActyParticipant to build this SupplierActivity with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SupplierActivity.SupplierActivityBuilder suplrActyParticipant( final SuplrActyParticipant value )
        {
            return toSuplrActyParticipant(value);
        }

        private SupplierActivity.SupplierActivityBuilder toSuplrActyPurchaserResp( final SuplrActyPurchaserResp value )
        {
            toSuplrActyPurchaserResp = value;
            return this;
        }

        /**
         * Navigation property <b>to_SuplrActyPurchaserResp</b> for <b>SupplierActivity</b> to single
         * <b>SuplrActyPurchaserResp</b>.
         *
         * @param value
         *            The SuplrActyPurchaserResp to build this SupplierActivity with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SupplierActivity.SupplierActivityBuilder suplrActyPurchaserResp( final SuplrActyPurchaserResp value )
        {
            return toSuplrActyPurchaserResp(value);
        }

        private SupplierActivity.SupplierActivityBuilder toSuplrActySupplier( final List<SuplrActySupplier> value )
        {
            toSuplrActySupplier.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SuplrActySupplier</b> for <b>SupplierActivity</b> to multiple
         * <b>SuplrActySupplier</b>.
         *
         * @param value
         *            The SuplrActySuppliers to build this SupplierActivity with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SupplierActivity.SupplierActivityBuilder suplrActySupplier( SuplrActySupplier... value )
        {
            return toSuplrActySupplier(Lists.newArrayList(value));
        }

    }

}
