/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link SupplierActivityServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierActivityService SupplierActivityService}, allowing
 * you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultSupplierActivityServiceBatch
    extends
    BatchFluentHelperBasic<SupplierActivityServiceBatch, SupplierActivityServiceBatchChangeSet>
    implements
    SupplierActivityServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierActivityService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultSupplierActivityServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultSupplierActivityServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierActivityService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierActivityService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultSupplierActivityServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultSupplierActivityServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierActivityService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultSupplierActivityServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public SupplierActivityServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultSupplierActivityServiceBatchChangeSet(this, service);
    }

}
