/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyDescription;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyParticipant;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyPurchaserResp;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActySupplier;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SupplierActivity;

/**
 * Implementation of the {@link SupplierActivityServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierActivityService SupplierActivityService}.
 *
 */
public class DefaultSupplierActivityServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<SupplierActivityServiceBatch, SupplierActivityServiceBatchChangeSet>
    implements
    SupplierActivityServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierActivityService service;

    @SuppressWarnings( "deprecation" )
    DefaultSupplierActivityServiceBatchChangeSet(
        @Nonnull final DefaultSupplierActivityServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierActivityService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultSupplierActivityServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public SupplierActivityServiceBatchChangeSet createSuplrActyDescription(
        @Nonnull final SuplrActyDescription suplrActyDescription )
    {
        return addRequestCreate(service::createSuplrActyDescription, suplrActyDescription);
    }

    @Nonnull
    @Override
    public SupplierActivityServiceBatchChangeSet updateSuplrActyDescription(
        @Nonnull final SuplrActyDescription suplrActyDescription )
    {
        return addRequestUpdate(service::updateSuplrActyDescription, suplrActyDescription);
    }

    @Nonnull
    @Override
    public SupplierActivityServiceBatchChangeSet deleteSuplrActyDescription(
        @Nonnull final SuplrActyDescription suplrActyDescription )
    {
        return addRequestDelete(service::deleteSuplrActyDescription, suplrActyDescription);
    }

    @Nonnull
    @Override
    public SupplierActivityServiceBatchChangeSet createSuplrActyParticipant(
        @Nonnull final SuplrActyParticipant suplrActyParticipant )
    {
        return addRequestCreate(service::createSuplrActyParticipant, suplrActyParticipant);
    }

    @Nonnull
    @Override
    public SupplierActivityServiceBatchChangeSet updateSuplrActyParticipant(
        @Nonnull final SuplrActyParticipant suplrActyParticipant )
    {
        return addRequestUpdate(service::updateSuplrActyParticipant, suplrActyParticipant);
    }

    @Nonnull
    @Override
    public SupplierActivityServiceBatchChangeSet deleteSuplrActyParticipant(
        @Nonnull final SuplrActyParticipant suplrActyParticipant )
    {
        return addRequestDelete(service::deleteSuplrActyParticipant, suplrActyParticipant);
    }

    @Nonnull
    @Override
    public SupplierActivityServiceBatchChangeSet updateSuplrActyPurchaserResp(
        @Nonnull final SuplrActyPurchaserResp suplrActyPurchaserResp )
    {
        return addRequestUpdate(service::updateSuplrActyPurchaserResp, suplrActyPurchaserResp);
    }

    @Nonnull
    @Override
    public SupplierActivityServiceBatchChangeSet createSuplrActySupplier(
        @Nonnull final SuplrActySupplier suplrActySupplier )
    {
        return addRequestCreate(service::createSuplrActySupplier, suplrActySupplier);
    }

    @Nonnull
    @Override
    public SupplierActivityServiceBatchChangeSet updateSuplrActySupplier(
        @Nonnull final SuplrActySupplier suplrActySupplier )
    {
        return addRequestUpdate(service::updateSuplrActySupplier, suplrActySupplier);
    }

    @Nonnull
    @Override
    public SupplierActivityServiceBatchChangeSet deleteSuplrActySupplier(
        @Nonnull final SuplrActySupplier suplrActySupplier )
    {
        return addRequestDelete(service::deleteSuplrActySupplier, suplrActySupplier);
    }

    @Nonnull
    @Override
    public SupplierActivityServiceBatchChangeSet createSupplierActivity(
        @Nonnull final SupplierActivity supplierActivity )
    {
        return addRequestCreate(service::createSupplierActivity, supplierActivity);
    }

    @Nonnull
    @Override
    public SupplierActivityServiceBatchChangeSet updateSupplierActivity(
        @Nonnull final SupplierActivity supplierActivity )
    {
        return addRequestUpdate(service::updateSupplierActivity, supplierActivity);
    }

    @Nonnull
    @Override
    public SupplierActivityServiceBatchChangeSet deleteSupplierActivity(
        @Nonnull final SupplierActivity supplierActivity )
    {
        return addRequestDelete(service::deleteSupplierActivity, supplierActivity);
    }

}
