/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyDescription;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyParticipant;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyPurchaserResp;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActySupplier;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SupplierActivity;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierActivityService SupplierActivityService}.
 *
 */
public interface SupplierActivityServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<SupplierActivityServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<SupplierActivityServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyDescription
     * SuplrActyDescription} entity and save it to the S/4HANA system.
     *
     * @param suplrActyDescription
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyDescription
     *            SuplrActyDescription} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SupplierActivityServiceBatchChangeSet
        createSuplrActyDescription( @Nonnull final SuplrActyDescription suplrActyDescription );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyDescription
     * SuplrActyDescription} entity and save it to the S/4HANA system.
     *
     * @param suplrActyDescription
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyDescription
     *            SuplrActyDescription} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SupplierActivityServiceBatchChangeSet
        updateSuplrActyDescription( @Nonnull final SuplrActyDescription suplrActyDescription );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyDescription
     * SuplrActyDescription} entity in the S/4HANA system.
     *
     * @param suplrActyDescription
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyDescription
     *            SuplrActyDescription} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SupplierActivityServiceBatchChangeSet
        deleteSuplrActyDescription( @Nonnull final SuplrActyDescription suplrActyDescription );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyParticipant
     * SuplrActyParticipant} entity and save it to the S/4HANA system.
     *
     * @param suplrActyParticipant
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyParticipant
     *            SuplrActyParticipant} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SupplierActivityServiceBatchChangeSet
        createSuplrActyParticipant( @Nonnull final SuplrActyParticipant suplrActyParticipant );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyParticipant
     * SuplrActyParticipant} entity and save it to the S/4HANA system.
     *
     * @param suplrActyParticipant
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyParticipant
     *            SuplrActyParticipant} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SupplierActivityServiceBatchChangeSet
        updateSuplrActyParticipant( @Nonnull final SuplrActyParticipant suplrActyParticipant );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyParticipant
     * SuplrActyParticipant} entity in the S/4HANA system.
     *
     * @param suplrActyParticipant
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyParticipant
     *            SuplrActyParticipant} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SupplierActivityServiceBatchChangeSet
        deleteSuplrActyParticipant( @Nonnull final SuplrActyParticipant suplrActyParticipant );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyPurchaserResp
     * SuplrActyPurchaserResp} entity and save it to the S/4HANA system.
     *
     * @param suplrActyPurchaserResp
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyPurchaserResp
     *            SuplrActyPurchaserResp} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SupplierActivityServiceBatchChangeSet
        updateSuplrActyPurchaserResp( @Nonnull final SuplrActyPurchaserResp suplrActyPurchaserResp );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActySupplier
     * SuplrActySupplier} entity and save it to the S/4HANA system.
     *
     * @param suplrActySupplier
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActySupplier
     *            SuplrActySupplier} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SupplierActivityServiceBatchChangeSet createSuplrActySupplier( @Nonnull final SuplrActySupplier suplrActySupplier );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActySupplier
     * SuplrActySupplier} entity and save it to the S/4HANA system.
     *
     * @param suplrActySupplier
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActySupplier
     *            SuplrActySupplier} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SupplierActivityServiceBatchChangeSet updateSuplrActySupplier( @Nonnull final SuplrActySupplier suplrActySupplier );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActySupplier
     * SuplrActySupplier} entity in the S/4HANA system.
     *
     * @param suplrActySupplier
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActySupplier
     *            SuplrActySupplier} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SupplierActivityServiceBatchChangeSet deleteSuplrActySupplier( @Nonnull final SuplrActySupplier suplrActySupplier );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SupplierActivity
     * SupplierActivity} entity and save it to the S/4HANA system.
     *
     * @param supplierActivity
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SupplierActivity
     *            SupplierActivity} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SupplierActivityServiceBatchChangeSet createSupplierActivity( @Nonnull final SupplierActivity supplierActivity );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SupplierActivity
     * SupplierActivity} entity and save it to the S/4HANA system.
     *
     * @param supplierActivity
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SupplierActivity
     *            SupplierActivity} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SupplierActivityServiceBatchChangeSet updateSupplierActivity( @Nonnull final SupplierActivity supplierActivity );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SupplierActivity
     * SupplierActivity} entity in the S/4HANA system.
     *
     * @param supplierActivity
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SupplierActivity
     *            SupplierActivity} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SupplierActivityServiceBatchChangeSet deleteSupplierActivity( @Nonnull final SupplierActivity supplierActivity );

}
