/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyDescription;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyDescription
 * SuplrActyDescription}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.field.SuplrActyDescriptionField
 * SuplrActyDescriptionField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.link.SuplrActyDescriptionLink
 * SuplrActyDescriptionLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyDescription#SUPLR_ACTY_UUID
 * SUPLR_ACTY_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyDescription#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyDescription#SUPLR_ACTY_DESCRIPTION
 * SUPLR_ACTY_DESCRIPTION}</li>
 * </ul>
 *
 */
public interface SuplrActyDescriptionSelectable extends EntitySelectable<SuplrActyDescription>
{

}
