/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyParticipant;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyParticipant
 * SuplrActyParticipant}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.field.SuplrActyParticipantField
 * SuplrActyParticipantField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.link.SuplrActyParticipantLink
 * SuplrActyParticipantLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyParticipant#SUPLR_ACTY_PARTY_UUID
 * SUPLR_ACTY_PARTY_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyParticipant#SUPLR_ACTY_UUID
 * SUPLR_ACTY_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyParticipant#USER_ID
 * USER_ID}</li>
 * </ul>
 *
 */
public interface SuplrActyParticipantSelectable extends EntitySelectable<SuplrActyParticipant>
{

}
