/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyPurchaserResp;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyPurchaserResp
 * SuplrActyPurchaserResp}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.field.SuplrActyPurchaserRespField
 * SuplrActyPurchaserRespField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.link.SuplrActyPurchaserRespLink
 * SuplrActyPurchaserRespLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyPurchaserResp#SUPLR_ACTY_PARTY_UUID
 * SUPLR_ACTY_PARTY_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyPurchaserResp#SUPLR_ACTY_UUID
 * SUPLR_ACTY_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyPurchaserResp#USER_ID
 * USER_ID}</li>
 * </ul>
 *
 */
public interface SuplrActyPurchaserRespSelectable extends EntitySelectable<SuplrActyPurchaserResp>
{

}
