/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActySupplier;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActySupplier SuplrActySupplier}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.field.SuplrActySupplierField
 * SuplrActySupplierField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.link.SuplrActySupplierLink
 * SuplrActySupplierLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActySupplier#SUPLR_ACTY_PARTY_UUID
 * SUPLR_ACTY_PARTY_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActySupplier#SUPLR_ACTY_UUID
 * SUPLR_ACTY_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActySupplier#BUSINESS_PARTNER
 * BUSINESS_PARTNER}</li>
 * </ul>
 *
 */
public interface SuplrActySupplierSelectable extends EntitySelectable<SuplrActySupplier>
{

}
