/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmComplex;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * <p>
 * Original complex type name from the Odata EDM: <b>CompleteSuplrActyTskExportParameters</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CompleteSuplrActyTskExportParameters extends VdmComplex<CompleteSuplrActyTskExportParameters>
{

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>Complete</b>
     * </p>
     *
     * @param complete
     *
     * @return Lifecycle Status
     */
    @SerializedName( "Complete" )
    @JsonProperty( "Complete" )
    @Nullable
    @ODataField( odataName = "Complete" )
    private String complete;

    @Nonnull
    @Override
    public Class<CompleteSuplrActyTskExportParameters> getType()
    {
        return CompleteSuplrActyTskExportParameters.class;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Complete", getComplete());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Complete") ) {
                final Object value = values.remove("Complete");
                if( (value == null) || (!value.equals(getComplete())) ) {
                    setComplete(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        return result;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>Complete</b>
     * </p>
     *
     * @param complete
     *            Lifecycle Status
     */
    public void setComplete( @Nullable final String complete )
    {
        rememberChangedField("Complete", this.complete);
        this.complete = complete;
    }

}
