/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmComplex;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * <p>
 * Original complex type name from the Odata EDM: <b>ReqClrfctnSuplrActyTskExportParameters</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ReqClrfctnSuplrActyTskExportParameters extends VdmComplex<ReqClrfctnSuplrActyTskExportParameters>
{

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>InClarification</b>
     * </p>
     *
     * @param inClarification
     *
     * @return Lifecycle Status
     */
    @SerializedName( "InClarification" )
    @JsonProperty( "InClarification" )
    @Nullable
    @ODataField( odataName = "InClarification" )
    private String inClarification;

    @Nonnull
    @Override
    public Class<ReqClrfctnSuplrActyTskExportParameters> getType()
    {
        return ReqClrfctnSuplrActyTskExportParameters.class;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("InClarification", getInClarification());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("InClarification") ) {
                final Object value = values.remove("InClarification");
                if( (value == null) || (!value.equals(getInClarification())) ) {
                    setInClarification(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        return result;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>InClarification</b>
     * </p>
     *
     * @param inClarification
     *            Lifecycle Status
     */
    public void setInClarification( @Nullable final String inClarification )
    {
        rememberChangedField("InClarification", this.inClarification);
        this.inClarification = inClarification;
    }

}
