/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmComplex;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * <p>
 * Original complex type name from the Odata EDM: <b>SendSuplrActyTskExportParameters</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SendSuplrActyTskExportParameters extends VdmComplex<SendSuplrActyTskExportParameters>
{

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>Send</b>
     * </p>
     *
     * @param send
     *
     * @return Lifecycle Status
     */
    @SerializedName( "Send" )
    @JsonProperty( "Send" )
    @Nullable
    @ODataField( odataName = "Send" )
    private String send;

    @Nonnull
    @Override
    public Class<SendSuplrActyTskExportParameters> getType()
    {
        return SendSuplrActyTskExportParameters.class;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Send", getSend());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Send") ) {
                final Object value = values.remove("Send");
                if( (value == null) || (!value.equals(getSend())) ) {
                    setSend(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        return result;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>Send</b>
     * </p>
     *
     * @param send
     *            Lifecycle Status
     */
    public void setSend( @Nullable final String send )
    {
        rememberChangedField("Send", this.send);
        this.send = send;
    }

}
