/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.field.SuplrActyTskActyReferenceField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.selectable.SuplrActyTskActyReferenceSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Activity Reference
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SuplrActyTskActyReferenceType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SuplrActyTskActyReference extends VdmEntity<SuplrActyTskActyReference>
{

    /**
     * Selector for all available fields of SuplrActyTskActyReference.
     *
     */
    public final static SuplrActyTskActyReferenceSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SuplrActyTaskReferenceUUID</b>
     * </p>
     *
     * @return Task ReferenceUUID
     */
    @Key
    @SerializedName( "SuplrActyTaskReferenceUUID" )
    @JsonProperty( "SuplrActyTaskReferenceUUID" )
    @Nullable
    @ODataField( odataName = "SuplrActyTaskReferenceUUID" )
    private UUID suplrActyTaskReferenceUUID;
    /**
     * Use with available fluent helpers to apply the <b>SuplrActyTaskReferenceUUID</b> field to query operations.
     *
     */
    public final static SuplrActyTskActyReferenceField<UUID> SUPLR_ACTY_TASK_REFERENCE_UUID =
        new SuplrActyTskActyReferenceField<UUID>("SuplrActyTaskReferenceUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrActyTaskUUID</b>
     * </p>
     *
     * @return Task UUID
     */
    @SerializedName( "SuplrActyTaskUUID" )
    @JsonProperty( "SuplrActyTaskUUID" )
    @Nullable
    @ODataField( odataName = "SuplrActyTaskUUID" )
    private UUID suplrActyTaskUUID;
    /**
     * Use with available fluent helpers to apply the <b>SuplrActyTaskUUID</b> field to query operations.
     *
     */
    public final static SuplrActyTskActyReferenceField<UUID> SUPLR_ACTY_TASK_UUID =
        new SuplrActyTskActyReferenceField<UUID>("SuplrActyTaskUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrActyUUID</b>
     * </p>
     *
     * @return Activity UUID
     */
    @SerializedName( "SuplrActyUUID" )
    @JsonProperty( "SuplrActyUUID" )
    @Nullable
    @ODataField( odataName = "SuplrActyUUID" )
    private UUID suplrActyUUID;
    /**
     * Use with available fluent helpers to apply the <b>SuplrActyUUID</b> field to query operations.
     *
     */
    public final static SuplrActyTskActyReferenceField<UUID> SUPLR_ACTY_UUID =
        new SuplrActyTskActyReferenceField<UUID>("SuplrActyUUID");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SupplierActivity</b>
     * </p>
     *
     * @return Activity
     */
    @SerializedName( "SupplierActivity" )
    @JsonProperty( "SupplierActivity" )
    @Nullable
    @ODataField( odataName = "SupplierActivity" )
    private String supplierActivity;
    /**
     * Use with available fluent helpers to apply the <b>SupplierActivity</b> field to query operations.
     *
     */
    public final static SuplrActyTskActyReferenceField<String> SUPPLIER_ACTIVITY =
        new SuplrActyTskActyReferenceField<String>("SupplierActivity");

    @Nonnull
    @Override
    public Class<SuplrActyTskActyReference> getType()
    {
        return SuplrActyTskActyReference.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SuplrActyTaskReferenceUUID</b>
     * </p>
     *
     * @param suplrActyTaskReferenceUUID
     *            Task ReferenceUUID
     */
    public void setSuplrActyTaskReferenceUUID( @Nullable final UUID suplrActyTaskReferenceUUID )
    {
        rememberChangedField("SuplrActyTaskReferenceUUID", this.suplrActyTaskReferenceUUID);
        this.suplrActyTaskReferenceUUID = suplrActyTaskReferenceUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrActyTaskUUID</b>
     * </p>
     *
     * @param suplrActyTaskUUID
     *            Task UUID
     */
    public void setSuplrActyTaskUUID( @Nullable final UUID suplrActyTaskUUID )
    {
        rememberChangedField("SuplrActyTaskUUID", this.suplrActyTaskUUID);
        this.suplrActyTaskUUID = suplrActyTaskUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrActyUUID</b>
     * </p>
     *
     * @param suplrActyUUID
     *            Activity UUID
     */
    public void setSuplrActyUUID( @Nullable final UUID suplrActyUUID )
    {
        rememberChangedField("SuplrActyUUID", this.suplrActyUUID);
        this.suplrActyUUID = suplrActyUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SupplierActivity</b>
     * </p>
     *
     * @param supplierActivity
     *            Activity
     */
    public void setSupplierActivity( @Nullable final String supplierActivity )
    {
        rememberChangedField("SupplierActivity", this.supplierActivity);
        this.supplierActivity = supplierActivity;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SuplrActyTskActyReference";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SuplrActyTaskReferenceUUID", getSuplrActyTaskReferenceUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SuplrActyTaskReferenceUUID", getSuplrActyTaskReferenceUUID());
        values.put("SuplrActyTaskUUID", getSuplrActyTaskUUID());
        values.put("SuplrActyUUID", getSuplrActyUUID());
        values.put("SupplierActivity", getSupplierActivity());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SuplrActyTaskReferenceUUID") ) {
                final Object value = values.remove("SuplrActyTaskReferenceUUID");
                if( (value == null) || (!value.equals(getSuplrActyTaskReferenceUUID())) ) {
                    setSuplrActyTaskReferenceUUID(((UUID) value));
                }
            }
            if( values.containsKey("SuplrActyTaskUUID") ) {
                final Object value = values.remove("SuplrActyTaskUUID");
                if( (value == null) || (!value.equals(getSuplrActyTaskUUID())) ) {
                    setSuplrActyTaskUUID(((UUID) value));
                }
            }
            if( values.containsKey("SuplrActyUUID") ) {
                final Object value = values.remove("SuplrActyUUID");
                if( (value == null) || (!value.equals(getSuplrActyUUID())) ) {
                    setSuplrActyUUID(((UUID) value));
                }
            }
            if( values.containsKey("SupplierActivity") ) {
                final Object value = values.remove("SupplierActivity");
                if( (value == null) || (!value.equals(getSupplierActivity())) ) {
                    setSupplierActivity(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SuplrActyTskActyReferenceField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SuplrActyTskActyReferenceField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SuplrActyTskActyReferenceField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SuplrActyTskActyReferenceField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierActivityTaskService.DEFAULT_SERVICE_PATH);
    }

}
