/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.field.SuplrActyTskDescriptionField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.selectable.SuplrActyTskDescriptionSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Detailed Description
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SuplrActyTskDescriptionType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SuplrActyTskDescription extends VdmEntity<SuplrActyTskDescription>
{

    /**
     * Selector for all available fields of SuplrActyTskDescription.
     *
     */
    public final static SuplrActyTskDescriptionSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SuplrActyTaskUUID</b>
     * </p>
     *
     * @return Task UUID
     */
    @Key
    @SerializedName( "SuplrActyTaskUUID" )
    @JsonProperty( "SuplrActyTaskUUID" )
    @Nullable
    @ODataField( odataName = "SuplrActyTaskUUID" )
    private UUID suplrActyTaskUUID;
    /**
     * Use with available fluent helpers to apply the <b>SuplrActyTaskUUID</b> field to query operations.
     *
     */
    public final static SuplrActyTskDescriptionField<UUID> SUPLR_ACTY_TASK_UUID =
        new SuplrActyTskDescriptionField<UUID>("SuplrActyTaskUUID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static SuplrActyTskDescriptionField<String> LANGUAGE =
        new SuplrActyTskDescriptionField<String>("Language");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrActyTskDescription</b>
     * </p>
     *
     * @return Text Content
     */
    @SerializedName( "SuplrActyTskDescription" )
    @JsonProperty( "SuplrActyTskDescription" )
    @Nullable
    @ODataField( odataName = "SuplrActyTskDescription" )
    private String suplrActyTskDescription;
    /**
     * Use with available fluent helpers to apply the <b>SuplrActyTskDescription</b> field to query operations.
     *
     */
    public final static SuplrActyTskDescriptionField<String> SUPLR_ACTY_TSK_DESCRIPTION =
        new SuplrActyTskDescriptionField<String>("SuplrActyTskDescription");

    @Nonnull
    @Override
    public Class<SuplrActyTskDescription> getType()
    {
        return SuplrActyTskDescription.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SuplrActyTaskUUID</b>
     * </p>
     *
     * @param suplrActyTaskUUID
     *            Task UUID
     */
    public void setSuplrActyTaskUUID( @Nullable final UUID suplrActyTaskUUID )
    {
        rememberChangedField("SuplrActyTaskUUID", this.suplrActyTaskUUID);
        this.suplrActyTaskUUID = suplrActyTaskUUID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrActyTskDescription</b>
     * </p>
     *
     * @param suplrActyTskDescription
     *            Text Content
     */
    public void setSuplrActyTskDescription( @Nullable final String suplrActyTskDescription )
    {
        rememberChangedField("SuplrActyTskDescription", this.suplrActyTskDescription);
        this.suplrActyTskDescription = suplrActyTskDescription;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SuplrActyTskDescription";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SuplrActyTaskUUID", getSuplrActyTaskUUID());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SuplrActyTaskUUID", getSuplrActyTaskUUID());
        values.put("Language", getLanguage());
        values.put("SuplrActyTskDescription", getSuplrActyTskDescription());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SuplrActyTaskUUID") ) {
                final Object value = values.remove("SuplrActyTaskUUID");
                if( (value == null) || (!value.equals(getSuplrActyTaskUUID())) ) {
                    setSuplrActyTaskUUID(((UUID) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("SuplrActyTskDescription") ) {
                final Object value = values.remove("SuplrActyTskDescription");
                if( (value == null) || (!value.equals(getSuplrActyTskDescription())) ) {
                    setSuplrActyTskDescription(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SuplrActyTskDescriptionField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SuplrActyTskDescriptionField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SuplrActyTskDescriptionField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SuplrActyTskDescriptionField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierActivityTaskService.DEFAULT_SERVICE_PATH);
    }

}
