/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperRead;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.selectable.SuplrActyTskDescriptionSelectable;

/**
 * Fluent helper to fetch multiple
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskDescription
 * SuplrActyTskDescription} entities. This fluent helper allows methods which modify the underlying query to be called
 * before executing the query itself.
 *
 */
public class SuplrActyTskDescriptionFluentHelper
    extends
    FluentHelperRead<SuplrActyTskDescriptionFluentHelper, SuplrActyTskDescription, SuplrActyTskDescriptionSelectable>
{

    /**
     * Creates a fluent helper using the specified service path and entity collection to send the read requests.
     *
     * @param entityCollection
     *            The entity collection to direct the requests to.
     * @param servicePath
     *            The service path to direct the read requests to.
     */
    public SuplrActyTskDescriptionFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection )
    {
        super(servicePath, entityCollection);
    }

    @Override
    @Nonnull
    protected Class<SuplrActyTskDescription> getEntityClass()
    {
        return SuplrActyTskDescription.class;
    }

}
