/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.field.SuplrActyTskPurchaserRespField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.selectable.SuplrActyTskPurchaserRespSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Purchaser Responsible
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SuplrActyTskPurchaserRespType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SuplrActyTskPurchaserResp extends VdmEntity<SuplrActyTskPurchaserResp>
{

    /**
     * Selector for all available fields of SuplrActyTskPurchaserResp.
     *
     */
    public final static SuplrActyTskPurchaserRespSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SuplrActyTaskPartyUUID</b>
     * </p>
     *
     * @return Task Party UUID
     */
    @Key
    @SerializedName( "SuplrActyTaskPartyUUID" )
    @JsonProperty( "SuplrActyTaskPartyUUID" )
    @Nullable
    @ODataField( odataName = "SuplrActyTaskPartyUUID" )
    private UUID suplrActyTaskPartyUUID;
    /**
     * Use with available fluent helpers to apply the <b>SuplrActyTaskPartyUUID</b> field to query operations.
     *
     */
    public final static SuplrActyTskPurchaserRespField<UUID> SUPLR_ACTY_TASK_PARTY_UUID =
        new SuplrActyTskPurchaserRespField<UUID>("SuplrActyTaskPartyUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrActyTaskUUID</b>
     * </p>
     *
     * @return Task UUID
     */
    @SerializedName( "SuplrActyTaskUUID" )
    @JsonProperty( "SuplrActyTaskUUID" )
    @Nullable
    @ODataField( odataName = "SuplrActyTaskUUID" )
    private UUID suplrActyTaskUUID;
    /**
     * Use with available fluent helpers to apply the <b>SuplrActyTaskUUID</b> field to query operations.
     *
     */
    public final static SuplrActyTskPurchaserRespField<UUID> SUPLR_ACTY_TASK_UUID =
        new SuplrActyTskPurchaserRespField<UUID>("SuplrActyTaskUUID");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>UserID</b>
     * </p>
     *
     * @return User ID
     */
    @SerializedName( "UserID" )
    @JsonProperty( "UserID" )
    @Nullable
    @ODataField( odataName = "UserID" )
    private String userID;
    /**
     * Use with available fluent helpers to apply the <b>UserID</b> field to query operations.
     *
     */
    public final static SuplrActyTskPurchaserRespField<String> USER_ID =
        new SuplrActyTskPurchaserRespField<String>("UserID");
    /**
     * Constraints: Not nullable, Maximum length: 241
     * <p>
     * Original property name from the Odata EDM: <b>EmailAddress</b>
     * </p>
     *
     * @return Email Address
     */
    @SerializedName( "EmailAddress" )
    @JsonProperty( "EmailAddress" )
    @Nullable
    @ODataField( odataName = "EmailAddress" )
    private String emailAddress;
    /**
     * Use with available fluent helpers to apply the <b>EmailAddress</b> field to query operations.
     *
     */
    public final static SuplrActyTskPurchaserRespField<String> EMAIL_ADDRESS =
        new SuplrActyTskPurchaserRespField<String>("EmailAddress");

    @Nonnull
    @Override
    public Class<SuplrActyTskPurchaserResp> getType()
    {
        return SuplrActyTskPurchaserResp.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SuplrActyTaskPartyUUID</b>
     * </p>
     *
     * @param suplrActyTaskPartyUUID
     *            Task Party UUID
     */
    public void setSuplrActyTaskPartyUUID( @Nullable final UUID suplrActyTaskPartyUUID )
    {
        rememberChangedField("SuplrActyTaskPartyUUID", this.suplrActyTaskPartyUUID);
        this.suplrActyTaskPartyUUID = suplrActyTaskPartyUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrActyTaskUUID</b>
     * </p>
     *
     * @param suplrActyTaskUUID
     *            Task UUID
     */
    public void setSuplrActyTaskUUID( @Nullable final UUID suplrActyTaskUUID )
    {
        rememberChangedField("SuplrActyTaskUUID", this.suplrActyTaskUUID);
        this.suplrActyTaskUUID = suplrActyTaskUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>UserID</b>
     * </p>
     *
     * @param userID
     *            User ID
     */
    public void setUserID( @Nullable final String userID )
    {
        rememberChangedField("UserID", this.userID);
        this.userID = userID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 241
     * <p>
     * Original property name from the Odata EDM: <b>EmailAddress</b>
     * </p>
     *
     * @param emailAddress
     *            Email Address
     */
    public void setEmailAddress( @Nullable final String emailAddress )
    {
        rememberChangedField("EmailAddress", this.emailAddress);
        this.emailAddress = emailAddress;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SuplrActyTskPurchaserResp";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SuplrActyTaskPartyUUID", getSuplrActyTaskPartyUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SuplrActyTaskPartyUUID", getSuplrActyTaskPartyUUID());
        values.put("SuplrActyTaskUUID", getSuplrActyTaskUUID());
        values.put("UserID", getUserID());
        values.put("EmailAddress", getEmailAddress());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SuplrActyTaskPartyUUID") ) {
                final Object value = values.remove("SuplrActyTaskPartyUUID");
                if( (value == null) || (!value.equals(getSuplrActyTaskPartyUUID())) ) {
                    setSuplrActyTaskPartyUUID(((UUID) value));
                }
            }
            if( values.containsKey("SuplrActyTaskUUID") ) {
                final Object value = values.remove("SuplrActyTaskUUID");
                if( (value == null) || (!value.equals(getSuplrActyTaskUUID())) ) {
                    setSuplrActyTaskUUID(((UUID) value));
                }
            }
            if( values.containsKey("UserID") ) {
                final Object value = values.remove("UserID");
                if( (value == null) || (!value.equals(getUserID())) ) {
                    setUserID(((String) value));
                }
            }
            if( values.containsKey("EmailAddress") ) {
                final Object value = values.remove("EmailAddress");
                if( (value == null) || (!value.equals(getEmailAddress())) ) {
                    setEmailAddress(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SuplrActyTskPurchaserRespField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SuplrActyTskPurchaserRespField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SuplrActyTskPurchaserRespField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SuplrActyTskPurchaserRespField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierActivityTaskService.DEFAULT_SERVICE_PATH);
    }

}
