/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.selectable.SuplrActyTskPurchaserRespSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskPurchaserResp
 * SuplrActyTskPurchaserResp} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class SuplrActyTskPurchaserRespByKeyFluentHelper
    extends
    FluentHelperByKey<SuplrActyTskPurchaserRespByKeyFluentHelper, SuplrActyTskPurchaserResp, SuplrActyTskPurchaserRespSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskPurchaserResp
     * SuplrActyTskPurchaserResp} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SuplrActyTskPurchaserResp}
     * @param servicePath
     *            Service path to be used to fetch a single {@code SuplrActyTskPurchaserResp}
     * @param suplrActyTaskPartyUUID
     *            Task Party UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     */
    public SuplrActyTskPurchaserRespByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final UUID suplrActyTaskPartyUUID )
    {
        super(servicePath, entityCollection);
        this.key.put("SuplrActyTaskPartyUUID", suplrActyTaskPartyUUID);
    }

    @Override
    @Nonnull
    protected Class<SuplrActyTskPurchaserResp> getEntityClass()
    {
        return SuplrActyTskPurchaserResp.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
