/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.selectable.SuplrActyTskSupplierSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskSupplier
 * SuplrActyTskSupplier} entity using key fields. This fluent helper allows methods which modify the underlying query to
 * be called before executing the query itself.
 *
 */
public class SuplrActyTskSupplierByKeyFluentHelper
    extends
    FluentHelperByKey<SuplrActyTskSupplierByKeyFluentHelper, SuplrActyTskSupplier, SuplrActyTskSupplierSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskSupplier
     * SuplrActyTskSupplier} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SuplrActyTskSupplier}
     * @param servicePath
     *            Service path to be used to fetch a single {@code SuplrActyTskSupplier}
     * @param suplrActyTaskPartyUUID
     *            Task Party UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     */
    public SuplrActyTskSupplierByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final UUID suplrActyTaskPartyUUID )
    {
        super(servicePath, entityCollection);
        this.key.put("SuplrActyTaskPartyUUID", suplrActyTaskPartyUUID);
    }

    @Override
    @Nonnull
    protected Class<SuplrActyTskSupplier> getEntityClass()
    {
        return SuplrActyTskSupplier.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
