/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask;

import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.field.SupplierActivityTaskField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.link.SupplierActivityTaskLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.link.SupplierActivityTaskOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.selectable.SupplierActivityTaskSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Procurement-Related Task
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SupplierActivityTaskType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SupplierActivityTask extends VdmEntity<SupplierActivityTask>
{

    /**
     * Selector for all available fields of SupplierActivityTask.
     *
     */
    public final static SupplierActivityTaskSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SuplrActyTaskUUID</b>
     * </p>
     *
     * @return Task UUID
     */
    @Key
    @SerializedName( "SuplrActyTaskUUID" )
    @JsonProperty( "SuplrActyTaskUUID" )
    @Nullable
    @ODataField( odataName = "SuplrActyTaskUUID" )
    private UUID suplrActyTaskUUID;
    /**
     * Use with available fluent helpers to apply the <b>SuplrActyTaskUUID</b> field to query operations.
     *
     */
    public final static SupplierActivityTaskField<UUID> SUPLR_ACTY_TASK_UUID =
        new SupplierActivityTaskField<UUID>("SuplrActyTaskUUID");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SupplierActivityTask</b>
     * </p>
     *
     * @return Task ID
     */
    @SerializedName( "SupplierActivityTask" )
    @JsonProperty( "SupplierActivityTask" )
    @Nullable
    @ODataField( odataName = "SupplierActivityTask" )
    private String supplierActivityTask;
    /**
     * Use with available fluent helpers to apply the <b>SupplierActivityTask</b> field to query operations.
     *
     */
    public final static SupplierActivityTaskField<String> SUPPLIER_ACTIVITY_TASK =
        new SupplierActivityTaskField<String>("SupplierActivityTask");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SuplrActyTaskName</b>
     * </p>
     *
     * @return Task Name
     */
    @SerializedName( "SuplrActyTaskName" )
    @JsonProperty( "SuplrActyTaskName" )
    @Nullable
    @ODataField( odataName = "SuplrActyTaskName" )
    private String suplrActyTaskName;
    /**
     * Use with available fluent helpers to apply the <b>SuplrActyTaskName</b> field to query operations.
     *
     */
    public final static SupplierActivityTaskField<String> SUPLR_ACTY_TASK_NAME =
        new SupplierActivityTaskField<String>("SuplrActyTaskName");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @return Created On
     */
    @SerializedName( "CreationDateTime" )
    @JsonProperty( "CreationDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime creationDateTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationDateTime</b> field to query operations.
     *
     */
    public final static SupplierActivityTaskField<ZonedDateTime> CREATION_DATE_TIME =
        new SupplierActivityTaskField<ZonedDateTime>("CreationDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Created-By Name
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static SupplierActivityTaskField<String> CREATED_BY_USER =
        new SupplierActivityTaskField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Changed-By Name
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static SupplierActivityTaskField<String> LAST_CHANGED_BY_USER =
        new SupplierActivityTaskField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>EndDate</b>
     * </p>
     *
     * @return Due Date
     */
    @SerializedName( "EndDate" )
    @JsonProperty( "EndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "EndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime endDate;
    /**
     * Use with available fluent helpers to apply the <b>EndDate</b> field to query operations.
     *
     */
    public final static SupplierActivityTaskField<LocalDateTime> END_DATE =
        new SupplierActivityTaskField<LocalDateTime>("EndDate");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language
     */
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static SupplierActivityTaskField<String> LANGUAGE = new SupplierActivityTaskField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SuplrActyTaskPriority</b>
     * </p>
     *
     * @return Priority of a Task
     */
    @SerializedName( "SuplrActyTaskPriority" )
    @JsonProperty( "SuplrActyTaskPriority" )
    @Nullable
    @ODataField( odataName = "SuplrActyTaskPriority" )
    private String suplrActyTaskPriority;
    /**
     * Use with available fluent helpers to apply the <b>SuplrActyTaskPriority</b> field to query operations.
     *
     */
    public final static SupplierActivityTaskField<String> SUPLR_ACTY_TASK_PRIORITY =
        new SupplierActivityTaskField<String>("SuplrActyTaskPriority");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SuplrActyTaskLifecycleStatus</b>
     * </p>
     *
     * @return Lifecycle Status Code for Tasks
     */
    @SerializedName( "SuplrActyTaskLifecycleStatus" )
    @JsonProperty( "SuplrActyTaskLifecycleStatus" )
    @Nullable
    @ODataField( odataName = "SuplrActyTaskLifecycleStatus" )
    private String suplrActyTaskLifecycleStatus;
    /**
     * Use with available fluent helpers to apply the <b>SuplrActyTaskLifecycleStatus</b> field to query operations.
     *
     */
    public final static SupplierActivityTaskField<String> SUPLR_ACTY_TASK_LIFECYCLE_STATUS =
        new SupplierActivityTaskField<String>("SuplrActyTaskLifecycleStatus");
    /**
     * Navigation property <b>to_SuplrActyTskActyReference</b> for <b>SupplierActivityTask</b> to single
     * <b>SuplrActyTskActyReference</b>.
     *
     */
    @SerializedName( "to_SuplrActyTskActyReference" )
    @JsonProperty( "to_SuplrActyTskActyReference" )
    @ODataField( odataName = "to_SuplrActyTskActyReference" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SuplrActyTskActyReference toSuplrActyTskActyReference;
    /**
     * Navigation property <b>to_SuplrActyTskCommText</b> for <b>SupplierActivityTask</b> to single
     * <b>SuplrActyTskCommText</b>.
     *
     */
    @SerializedName( "to_SuplrActyTskCommText" )
    @JsonProperty( "to_SuplrActyTskCommText" )
    @ODataField( odataName = "to_SuplrActyTskCommText" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SuplrActyTskCommText toSuplrActyTskCommText;
    /**
     * Navigation property <b>to_SuplrActyTskDescription</b> for <b>SupplierActivityTask</b> to single
     * <b>SuplrActyTskDescription</b>.
     *
     */
    @SerializedName( "to_SuplrActyTskDescription" )
    @JsonProperty( "to_SuplrActyTskDescription" )
    @ODataField( odataName = "to_SuplrActyTskDescription" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SuplrActyTskDescription toSuplrActyTskDescription;
    /**
     * Navigation property <b>to_SuplrActyTskMessageText</b> for <b>SupplierActivityTask</b> to single
     * <b>SuplrActyTskMessageText</b>.
     *
     */
    @SerializedName( "to_SuplrActyTskMessageText" )
    @JsonProperty( "to_SuplrActyTskMessageText" )
    @ODataField( odataName = "to_SuplrActyTskMessageText" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SuplrActyTskMessageText toSuplrActyTskMessageText;
    /**
     * Navigation property <b>to_SuplrActyTskProcessor</b> for <b>SupplierActivityTask</b> to single
     * <b>SuplrActyTskProcessor</b>.
     *
     */
    @SerializedName( "to_SuplrActyTskProcessor" )
    @JsonProperty( "to_SuplrActyTskProcessor" )
    @ODataField( odataName = "to_SuplrActyTskProcessor" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SuplrActyTskProcessor toSuplrActyTskProcessor;
    /**
     * Navigation property <b>to_SuplrActyTskPurchaserResp</b> for <b>SupplierActivityTask</b> to single
     * <b>SuplrActyTskPurchaserResp</b>.
     *
     */
    @SerializedName( "to_SuplrActyTskPurchaserResp" )
    @JsonProperty( "to_SuplrActyTskPurchaserResp" )
    @ODataField( odataName = "to_SuplrActyTskPurchaserResp" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SuplrActyTskPurchaserResp toSuplrActyTskPurchaserResp;
    /**
     * Navigation property <b>to_SuplrActyTskSupplier</b> for <b>SupplierActivityTask</b> to multiple
     * <b>SuplrActyTskSupplier</b>.
     *
     */
    @SerializedName( "to_SuplrActyTskSupplier" )
    @JsonProperty( "to_SuplrActyTskSupplier" )
    @ODataField( odataName = "to_SuplrActyTskSupplier" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SuplrActyTskSupplier> toSuplrActyTskSupplier;
    /**
     * Use with available fluent helpers to apply the <b>to_SuplrActyTskActyReference</b> navigation property to query
     * operations.
     *
     */
    public final static SupplierActivityTaskOneToOneLink<SuplrActyTskActyReference> TO_SUPLR_ACTY_TSK_ACTY_REFERENCE =
        new SupplierActivityTaskOneToOneLink<SuplrActyTskActyReference>("to_SuplrActyTskActyReference");
    /**
     * Use with available fluent helpers to apply the <b>to_SuplrActyTskCommText</b> navigation property to query
     * operations.
     *
     */
    public final static SupplierActivityTaskOneToOneLink<SuplrActyTskCommText> TO_SUPLR_ACTY_TSK_COMM_TEXT =
        new SupplierActivityTaskOneToOneLink<SuplrActyTskCommText>("to_SuplrActyTskCommText");
    /**
     * Use with available fluent helpers to apply the <b>to_SuplrActyTskDescription</b> navigation property to query
     * operations.
     *
     */
    public final static SupplierActivityTaskOneToOneLink<SuplrActyTskDescription> TO_SUPLR_ACTY_TSK_DESCRIPTION =
        new SupplierActivityTaskOneToOneLink<SuplrActyTskDescription>("to_SuplrActyTskDescription");
    /**
     * Use with available fluent helpers to apply the <b>to_SuplrActyTskMessageText</b> navigation property to query
     * operations.
     *
     */
    public final static SupplierActivityTaskOneToOneLink<SuplrActyTskMessageText> TO_SUPLR_ACTY_TSK_MESSAGE_TEXT =
        new SupplierActivityTaskOneToOneLink<SuplrActyTskMessageText>("to_SuplrActyTskMessageText");
    /**
     * Use with available fluent helpers to apply the <b>to_SuplrActyTskProcessor</b> navigation property to query
     * operations.
     *
     */
    public final static SupplierActivityTaskOneToOneLink<SuplrActyTskProcessor> TO_SUPLR_ACTY_TSK_PROCESSOR =
        new SupplierActivityTaskOneToOneLink<SuplrActyTskProcessor>("to_SuplrActyTskProcessor");
    /**
     * Use with available fluent helpers to apply the <b>to_SuplrActyTskPurchaserResp</b> navigation property to query
     * operations.
     *
     */
    public final static SupplierActivityTaskOneToOneLink<SuplrActyTskPurchaserResp> TO_SUPLR_ACTY_TSK_PURCHASER_RESP =
        new SupplierActivityTaskOneToOneLink<SuplrActyTskPurchaserResp>("to_SuplrActyTskPurchaserResp");
    /**
     * Use with available fluent helpers to apply the <b>to_SuplrActyTskSupplier</b> navigation property to query
     * operations.
     *
     */
    public final static SupplierActivityTaskLink<SuplrActyTskSupplier> TO_SUPLR_ACTY_TSK_SUPPLIER =
        new SupplierActivityTaskLink<SuplrActyTskSupplier>("to_SuplrActyTskSupplier");

    @Nonnull
    @Override
    public Class<SupplierActivityTask> getType()
    {
        return SupplierActivityTask.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SuplrActyTaskUUID</b>
     * </p>
     *
     * @param suplrActyTaskUUID
     *            Task UUID
     */
    public void setSuplrActyTaskUUID( @Nullable final UUID suplrActyTaskUUID )
    {
        rememberChangedField("SuplrActyTaskUUID", this.suplrActyTaskUUID);
        this.suplrActyTaskUUID = suplrActyTaskUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SupplierActivityTask</b>
     * </p>
     *
     * @param supplierActivityTask
     *            Task ID
     */
    public void setSupplierActivityTask( @Nullable final String supplierActivityTask )
    {
        rememberChangedField("SupplierActivityTask", this.supplierActivityTask);
        this.supplierActivityTask = supplierActivityTask;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SuplrActyTaskName</b>
     * </p>
     *
     * @param suplrActyTaskName
     *            Task Name
     */
    public void setSuplrActyTaskName( @Nullable final String suplrActyTaskName )
    {
        rememberChangedField("SuplrActyTaskName", this.suplrActyTaskName);
        this.suplrActyTaskName = suplrActyTaskName;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @param creationDateTime
     *            Created On
     */
    public void setCreationDateTime( @Nullable final ZonedDateTime creationDateTime )
    {
        rememberChangedField("CreationDateTime", this.creationDateTime);
        this.creationDateTime = creationDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Created-By Name
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Changed-By Name
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>EndDate</b>
     * </p>
     *
     * @param endDate
     *            Due Date
     */
    public void setEndDate( @Nullable final LocalDateTime endDate )
    {
        rememberChangedField("EndDate", this.endDate);
        this.endDate = endDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SuplrActyTaskPriority</b>
     * </p>
     *
     * @param suplrActyTaskPriority
     *            Priority of a Task
     */
    public void setSuplrActyTaskPriority( @Nullable final String suplrActyTaskPriority )
    {
        rememberChangedField("SuplrActyTaskPriority", this.suplrActyTaskPriority);
        this.suplrActyTaskPriority = suplrActyTaskPriority;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SuplrActyTaskLifecycleStatus</b>
     * </p>
     *
     * @param suplrActyTaskLifecycleStatus
     *            Lifecycle Status Code for Tasks
     */
    public void setSuplrActyTaskLifecycleStatus( @Nullable final String suplrActyTaskLifecycleStatus )
    {
        rememberChangedField("SuplrActyTaskLifecycleStatus", this.suplrActyTaskLifecycleStatus);
        this.suplrActyTaskLifecycleStatus = suplrActyTaskLifecycleStatus;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SupplierActivityTask";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SuplrActyTaskUUID", getSuplrActyTaskUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SuplrActyTaskUUID", getSuplrActyTaskUUID());
        values.put("SupplierActivityTask", getSupplierActivityTask());
        values.put("SuplrActyTaskName", getSuplrActyTaskName());
        values.put("CreationDateTime", getCreationDateTime());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("EndDate", getEndDate());
        values.put("Language", getLanguage());
        values.put("SuplrActyTaskPriority", getSuplrActyTaskPriority());
        values.put("SuplrActyTaskLifecycleStatus", getSuplrActyTaskLifecycleStatus());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SuplrActyTaskUUID") ) {
                final Object value = values.remove("SuplrActyTaskUUID");
                if( (value == null) || (!value.equals(getSuplrActyTaskUUID())) ) {
                    setSuplrActyTaskUUID(((UUID) value));
                }
            }
            if( values.containsKey("SupplierActivityTask") ) {
                final Object value = values.remove("SupplierActivityTask");
                if( (value == null) || (!value.equals(getSupplierActivityTask())) ) {
                    setSupplierActivityTask(((String) value));
                }
            }
            if( values.containsKey("SuplrActyTaskName") ) {
                final Object value = values.remove("SuplrActyTaskName");
                if( (value == null) || (!value.equals(getSuplrActyTaskName())) ) {
                    setSuplrActyTaskName(((String) value));
                }
            }
            if( values.containsKey("CreationDateTime") ) {
                final Object value = values.remove("CreationDateTime");
                if( (value == null) || (!value.equals(getCreationDateTime())) ) {
                    setCreationDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("EndDate") ) {
                final Object value = values.remove("EndDate");
                if( (value == null) || (!value.equals(getEndDate())) ) {
                    setEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("SuplrActyTaskPriority") ) {
                final Object value = values.remove("SuplrActyTaskPriority");
                if( (value == null) || (!value.equals(getSuplrActyTaskPriority())) ) {
                    setSuplrActyTaskPriority(((String) value));
                }
            }
            if( values.containsKey("SuplrActyTaskLifecycleStatus") ) {
                final Object value = values.remove("SuplrActyTaskLifecycleStatus");
                if( (value == null) || (!value.equals(getSuplrActyTaskLifecycleStatus())) ) {
                    setSuplrActyTaskLifecycleStatus(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_SuplrActyTskActyReference") ) {
                final Object value = (values).remove("to_SuplrActyTskActyReference");
                if( value instanceof Map ) {
                    if( toSuplrActyTskActyReference == null ) {
                        toSuplrActyTskActyReference = new SuplrActyTskActyReference();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSuplrActyTskActyReference.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_SuplrActyTskCommText") ) {
                final Object value = (values).remove("to_SuplrActyTskCommText");
                if( value instanceof Map ) {
                    if( toSuplrActyTskCommText == null ) {
                        toSuplrActyTskCommText = new SuplrActyTskCommText();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSuplrActyTskCommText.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_SuplrActyTskDescription") ) {
                final Object value = (values).remove("to_SuplrActyTskDescription");
                if( value instanceof Map ) {
                    if( toSuplrActyTskDescription == null ) {
                        toSuplrActyTskDescription = new SuplrActyTskDescription();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSuplrActyTskDescription.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_SuplrActyTskMessageText") ) {
                final Object value = (values).remove("to_SuplrActyTskMessageText");
                if( value instanceof Map ) {
                    if( toSuplrActyTskMessageText == null ) {
                        toSuplrActyTskMessageText = new SuplrActyTskMessageText();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSuplrActyTskMessageText.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_SuplrActyTskProcessor") ) {
                final Object value = (values).remove("to_SuplrActyTskProcessor");
                if( value instanceof Map ) {
                    if( toSuplrActyTskProcessor == null ) {
                        toSuplrActyTskProcessor = new SuplrActyTskProcessor();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSuplrActyTskProcessor.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_SuplrActyTskPurchaserResp") ) {
                final Object value = (values).remove("to_SuplrActyTskPurchaserResp");
                if( value instanceof Map ) {
                    if( toSuplrActyTskPurchaserResp == null ) {
                        toSuplrActyTskPurchaserResp = new SuplrActyTskPurchaserResp();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSuplrActyTskPurchaserResp.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_SuplrActyTskSupplier") ) {
                final Object value = (values).remove("to_SuplrActyTskSupplier");
                if( value instanceof Iterable ) {
                    if( toSuplrActyTskSupplier == null ) {
                        toSuplrActyTskSupplier = Lists.newArrayList();
                    } else {
                        toSuplrActyTskSupplier = Lists.newArrayList(toSuplrActyTskSupplier);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SuplrActyTskSupplier entity;
                        if( toSuplrActyTskSupplier.size() > i ) {
                            entity = toSuplrActyTskSupplier.get(i);
                        } else {
                            entity = new SuplrActyTskSupplier();
                            toSuplrActyTskSupplier.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SupplierActivityTaskField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SupplierActivityTaskField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SupplierActivityTaskField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SupplierActivityTaskField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierActivityTaskService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toSuplrActyTskActyReference != null ) {
            (values).put("to_SuplrActyTskActyReference", toSuplrActyTskActyReference);
        }
        if( toSuplrActyTskCommText != null ) {
            (values).put("to_SuplrActyTskCommText", toSuplrActyTskCommText);
        }
        if( toSuplrActyTskDescription != null ) {
            (values).put("to_SuplrActyTskDescription", toSuplrActyTskDescription);
        }
        if( toSuplrActyTskMessageText != null ) {
            (values).put("to_SuplrActyTskMessageText", toSuplrActyTskMessageText);
        }
        if( toSuplrActyTskProcessor != null ) {
            (values).put("to_SuplrActyTskProcessor", toSuplrActyTskProcessor);
        }
        if( toSuplrActyTskPurchaserResp != null ) {
            (values).put("to_SuplrActyTskPurchaserResp", toSuplrActyTskPurchaserResp);
        }
        if( toSuplrActyTskSupplier != null ) {
            (values).put("to_SuplrActyTskSupplier", toSuplrActyTskSupplier);
        }
        return values;
    }

    /**
     * Fetches the <b>SuplrActyTskActyReference</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_SuplrActyTskActyReference</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SuplrActyTskActyReference</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SuplrActyTskActyReference fetchSuplrActyTskActyReference()
    {
        return fetchFieldAsSingle("to_SuplrActyTskActyReference", SuplrActyTskActyReference.class);
    }

    /**
     * Retrieval of associated <b>SuplrActyTskActyReference</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_SuplrActyTskActyReference</b>.
     * <p>
     * If the navigation property <b>to_SuplrActyTskActyReference</b> of a queried <b>SupplierActivityTask</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SuplrActyTskActyReference</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SuplrActyTskActyReference getSuplrActyTskActyReferenceOrFetch()
    {
        if( toSuplrActyTskActyReference == null ) {
            toSuplrActyTskActyReference = fetchSuplrActyTskActyReference();
        }
        return toSuplrActyTskActyReference;
    }

    /**
     * Retrieval of associated <b>SuplrActyTskActyReference</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_SuplrActyTskActyReference</b>.
     * <p>
     * If the navigation property for an entity <b>SupplierActivityTask</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SuplrActyTskActyReference</b> is already loaded, the
     *         result will contain the <b>SuplrActyTskActyReference</b> entity. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SuplrActyTskActyReference> getSuplrActyTskActyReferenceIfPresent()
    {
        return Option.of(toSuplrActyTskActyReference);
    }

    /**
     * Overwrites the associated <b>SuplrActyTskActyReference</b> entity for the loaded navigation property
     * <b>to_SuplrActyTskActyReference</b>.
     *
     * @param value
     *            New <b>SuplrActyTskActyReference</b> entity.
     */
    public void setSuplrActyTskActyReference( final SuplrActyTskActyReference value )
    {
        toSuplrActyTskActyReference = value;
    }

    /**
     * Fetches the <b>SuplrActyTskCommText</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_SuplrActyTskCommText</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SuplrActyTskCommText</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SuplrActyTskCommText fetchSuplrActyTskCommText()
    {
        return fetchFieldAsSingle("to_SuplrActyTskCommText", SuplrActyTskCommText.class);
    }

    /**
     * Retrieval of associated <b>SuplrActyTskCommText</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_SuplrActyTskCommText</b>.
     * <p>
     * If the navigation property <b>to_SuplrActyTskCommText</b> of a queried <b>SupplierActivityTask</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SuplrActyTskCommText</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SuplrActyTskCommText getSuplrActyTskCommTextOrFetch()
    {
        if( toSuplrActyTskCommText == null ) {
            toSuplrActyTskCommText = fetchSuplrActyTskCommText();
        }
        return toSuplrActyTskCommText;
    }

    /**
     * Retrieval of associated <b>SuplrActyTskCommText</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_SuplrActyTskCommText</b>.
     * <p>
     * If the navigation property for an entity <b>SupplierActivityTask</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SuplrActyTskCommText</b> is already loaded, the result
     *         will contain the <b>SuplrActyTskCommText</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SuplrActyTskCommText> getSuplrActyTskCommTextIfPresent()
    {
        return Option.of(toSuplrActyTskCommText);
    }

    /**
     * Overwrites the associated <b>SuplrActyTskCommText</b> entity for the loaded navigation property
     * <b>to_SuplrActyTskCommText</b>.
     *
     * @param value
     *            New <b>SuplrActyTskCommText</b> entity.
     */
    public void setSuplrActyTskCommText( final SuplrActyTskCommText value )
    {
        toSuplrActyTskCommText = value;
    }

    /**
     * Fetches the <b>SuplrActyTskDescription</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_SuplrActyTskDescription</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SuplrActyTskDescription</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SuplrActyTskDescription fetchSuplrActyTskDescription()
    {
        return fetchFieldAsSingle("to_SuplrActyTskDescription", SuplrActyTskDescription.class);
    }

    /**
     * Retrieval of associated <b>SuplrActyTskDescription</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_SuplrActyTskDescription</b>.
     * <p>
     * If the navigation property <b>to_SuplrActyTskDescription</b> of a queried <b>SupplierActivityTask</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SuplrActyTskDescription</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SuplrActyTskDescription getSuplrActyTskDescriptionOrFetch()
    {
        if( toSuplrActyTskDescription == null ) {
            toSuplrActyTskDescription = fetchSuplrActyTskDescription();
        }
        return toSuplrActyTskDescription;
    }

    /**
     * Retrieval of associated <b>SuplrActyTskDescription</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_SuplrActyTskDescription</b>.
     * <p>
     * If the navigation property for an entity <b>SupplierActivityTask</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SuplrActyTskDescription</b> is already loaded, the
     *         result will contain the <b>SuplrActyTskDescription</b> entity. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SuplrActyTskDescription> getSuplrActyTskDescriptionIfPresent()
    {
        return Option.of(toSuplrActyTskDescription);
    }

    /**
     * Overwrites the associated <b>SuplrActyTskDescription</b> entity for the loaded navigation property
     * <b>to_SuplrActyTskDescription</b>.
     *
     * @param value
     *            New <b>SuplrActyTskDescription</b> entity.
     */
    public void setSuplrActyTskDescription( final SuplrActyTskDescription value )
    {
        toSuplrActyTskDescription = value;
    }

    /**
     * Fetches the <b>SuplrActyTskMessageText</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_SuplrActyTskMessageText</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SuplrActyTskMessageText</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SuplrActyTskMessageText fetchSuplrActyTskMessageText()
    {
        return fetchFieldAsSingle("to_SuplrActyTskMessageText", SuplrActyTskMessageText.class);
    }

    /**
     * Retrieval of associated <b>SuplrActyTskMessageText</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_SuplrActyTskMessageText</b>.
     * <p>
     * If the navigation property <b>to_SuplrActyTskMessageText</b> of a queried <b>SupplierActivityTask</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SuplrActyTskMessageText</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SuplrActyTskMessageText getSuplrActyTskMessageTextOrFetch()
    {
        if( toSuplrActyTskMessageText == null ) {
            toSuplrActyTskMessageText = fetchSuplrActyTskMessageText();
        }
        return toSuplrActyTskMessageText;
    }

    /**
     * Retrieval of associated <b>SuplrActyTskMessageText</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_SuplrActyTskMessageText</b>.
     * <p>
     * If the navigation property for an entity <b>SupplierActivityTask</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SuplrActyTskMessageText</b> is already loaded, the
     *         result will contain the <b>SuplrActyTskMessageText</b> entity. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SuplrActyTskMessageText> getSuplrActyTskMessageTextIfPresent()
    {
        return Option.of(toSuplrActyTskMessageText);
    }

    /**
     * Overwrites the associated <b>SuplrActyTskMessageText</b> entity for the loaded navigation property
     * <b>to_SuplrActyTskMessageText</b>.
     *
     * @param value
     *            New <b>SuplrActyTskMessageText</b> entity.
     */
    public void setSuplrActyTskMessageText( final SuplrActyTskMessageText value )
    {
        toSuplrActyTskMessageText = value;
    }

    /**
     * Fetches the <b>SuplrActyTskProcessor</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_SuplrActyTskProcessor</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SuplrActyTskProcessor</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SuplrActyTskProcessor fetchSuplrActyTskProcessor()
    {
        return fetchFieldAsSingle("to_SuplrActyTskProcessor", SuplrActyTskProcessor.class);
    }

    /**
     * Retrieval of associated <b>SuplrActyTskProcessor</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_SuplrActyTskProcessor</b>.
     * <p>
     * If the navigation property <b>to_SuplrActyTskProcessor</b> of a queried <b>SupplierActivityTask</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SuplrActyTskProcessor</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SuplrActyTskProcessor getSuplrActyTskProcessorOrFetch()
    {
        if( toSuplrActyTskProcessor == null ) {
            toSuplrActyTskProcessor = fetchSuplrActyTskProcessor();
        }
        return toSuplrActyTskProcessor;
    }

    /**
     * Retrieval of associated <b>SuplrActyTskProcessor</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_SuplrActyTskProcessor</b>.
     * <p>
     * If the navigation property for an entity <b>SupplierActivityTask</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SuplrActyTskProcessor</b> is already loaded, the result
     *         will contain the <b>SuplrActyTskProcessor</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SuplrActyTskProcessor> getSuplrActyTskProcessorIfPresent()
    {
        return Option.of(toSuplrActyTskProcessor);
    }

    /**
     * Overwrites the associated <b>SuplrActyTskProcessor</b> entity for the loaded navigation property
     * <b>to_SuplrActyTskProcessor</b>.
     *
     * @param value
     *            New <b>SuplrActyTskProcessor</b> entity.
     */
    public void setSuplrActyTskProcessor( final SuplrActyTskProcessor value )
    {
        toSuplrActyTskProcessor = value;
    }

    /**
     * Fetches the <b>SuplrActyTskPurchaserResp</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_SuplrActyTskPurchaserResp</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SuplrActyTskPurchaserResp</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SuplrActyTskPurchaserResp fetchSuplrActyTskPurchaserResp()
    {
        return fetchFieldAsSingle("to_SuplrActyTskPurchaserResp", SuplrActyTskPurchaserResp.class);
    }

    /**
     * Retrieval of associated <b>SuplrActyTskPurchaserResp</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_SuplrActyTskPurchaserResp</b>.
     * <p>
     * If the navigation property <b>to_SuplrActyTskPurchaserResp</b> of a queried <b>SupplierActivityTask</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SuplrActyTskPurchaserResp</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SuplrActyTskPurchaserResp getSuplrActyTskPurchaserRespOrFetch()
    {
        if( toSuplrActyTskPurchaserResp == null ) {
            toSuplrActyTskPurchaserResp = fetchSuplrActyTskPurchaserResp();
        }
        return toSuplrActyTskPurchaserResp;
    }

    /**
     * Retrieval of associated <b>SuplrActyTskPurchaserResp</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_SuplrActyTskPurchaserResp</b>.
     * <p>
     * If the navigation property for an entity <b>SupplierActivityTask</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SuplrActyTskPurchaserResp</b> is already loaded, the
     *         result will contain the <b>SuplrActyTskPurchaserResp</b> entity. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SuplrActyTskPurchaserResp> getSuplrActyTskPurchaserRespIfPresent()
    {
        return Option.of(toSuplrActyTskPurchaserResp);
    }

    /**
     * Overwrites the associated <b>SuplrActyTskPurchaserResp</b> entity for the loaded navigation property
     * <b>to_SuplrActyTskPurchaserResp</b>.
     *
     * @param value
     *            New <b>SuplrActyTskPurchaserResp</b> entity.
     */
    public void setSuplrActyTskPurchaserResp( final SuplrActyTskPurchaserResp value )
    {
        toSuplrActyTskPurchaserResp = value;
    }

    /**
     * Fetches the <b>SuplrActyTskSupplier</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_SuplrActyTskSupplier</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SuplrActyTskSupplier</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SuplrActyTskSupplier> fetchSuplrActyTskSupplier()
    {
        return fetchFieldAsList("to_SuplrActyTskSupplier", SuplrActyTskSupplier.class);
    }

    /**
     * Retrieval of associated <b>SuplrActyTskSupplier</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SuplrActyTskSupplier</b>.
     * <p>
     * If the navigation property <b>to_SuplrActyTskSupplier</b> of a queried <b>SupplierActivityTask</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SuplrActyTskSupplier</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SuplrActyTskSupplier> getSuplrActyTskSupplierOrFetch()
    {
        if( toSuplrActyTskSupplier == null ) {
            toSuplrActyTskSupplier = fetchSuplrActyTskSupplier();
        }
        return toSuplrActyTskSupplier;
    }

    /**
     * Retrieval of associated <b>SuplrActyTskSupplier</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SuplrActyTskSupplier</b>.
     * <p>
     * If the navigation property for an entity <b>SupplierActivityTask</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SuplrActyTskSupplier</b> is already loaded, the result
     *         will contain the <b>SuplrActyTskSupplier</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SuplrActyTskSupplier>> getSuplrActyTskSupplierIfPresent()
    {
        return Option.of(toSuplrActyTskSupplier);
    }

    /**
     * Overwrites the list of associated <b>SuplrActyTskSupplier</b> entities for the loaded navigation property
     * <b>to_SuplrActyTskSupplier</b>.
     * <p>
     * If the navigation property <b>to_SuplrActyTskSupplier</b> of a queried <b>SupplierActivityTask</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SuplrActyTskSupplier</b> entities.
     */
    public void setSuplrActyTskSupplier( @Nonnull final List<SuplrActyTskSupplier> value )
    {
        if( toSuplrActyTskSupplier == null ) {
            toSuplrActyTskSupplier = Lists.newArrayList();
        }
        toSuplrActyTskSupplier.clear();
        toSuplrActyTskSupplier.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SuplrActyTskSupplier</b> entities. This corresponds to the OData
     * navigation property <b>to_SuplrActyTskSupplier</b>.
     * <p>
     * If the navigation property <b>to_SuplrActyTskSupplier</b> of a queried <b>SupplierActivityTask</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SuplrActyTskSupplier</b> entities.
     */
    public void addSuplrActyTskSupplier( SuplrActyTskSupplier... entity )
    {
        if( toSuplrActyTskSupplier == null ) {
            toSuplrActyTskSupplier = Lists.newArrayList();
        }
        toSuplrActyTskSupplier.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of SupplierActivityTask instances.
     *
     */
    public final static class SupplierActivityTaskBuilder
    {

        private SuplrActyTskActyReference toSuplrActyTskActyReference;
        private SuplrActyTskCommText toSuplrActyTskCommText;
        private SuplrActyTskDescription toSuplrActyTskDescription;
        private SuplrActyTskMessageText toSuplrActyTskMessageText;
        private SuplrActyTskProcessor toSuplrActyTskProcessor;
        private SuplrActyTskPurchaserResp toSuplrActyTskPurchaserResp;
        private List<SuplrActyTskSupplier> toSuplrActyTskSupplier = Lists.newArrayList();

        private SupplierActivityTask.SupplierActivityTaskBuilder toSuplrActyTskActyReference(
            final SuplrActyTskActyReference value )
        {
            toSuplrActyTskActyReference = value;
            return this;
        }

        /**
         * Navigation property <b>to_SuplrActyTskActyReference</b> for <b>SupplierActivityTask</b> to single
         * <b>SuplrActyTskActyReference</b>.
         *
         * @param value
         *            The SuplrActyTskActyReference to build this SupplierActivityTask with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SupplierActivityTask.SupplierActivityTaskBuilder suplrActyTskActyReference(
            final SuplrActyTskActyReference value )
        {
            return toSuplrActyTskActyReference(value);
        }

        private SupplierActivityTask.SupplierActivityTaskBuilder toSuplrActyTskCommText(
            final SuplrActyTskCommText value )
        {
            toSuplrActyTskCommText = value;
            return this;
        }

        /**
         * Navigation property <b>to_SuplrActyTskCommText</b> for <b>SupplierActivityTask</b> to single
         * <b>SuplrActyTskCommText</b>.
         *
         * @param value
         *            The SuplrActyTskCommText to build this SupplierActivityTask with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SupplierActivityTask.SupplierActivityTaskBuilder suplrActyTskCommText( final SuplrActyTskCommText value )
        {
            return toSuplrActyTskCommText(value);
        }

        private SupplierActivityTask.SupplierActivityTaskBuilder toSuplrActyTskDescription(
            final SuplrActyTskDescription value )
        {
            toSuplrActyTskDescription = value;
            return this;
        }

        /**
         * Navigation property <b>to_SuplrActyTskDescription</b> for <b>SupplierActivityTask</b> to single
         * <b>SuplrActyTskDescription</b>.
         *
         * @param value
         *            The SuplrActyTskDescription to build this SupplierActivityTask with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SupplierActivityTask.SupplierActivityTaskBuilder suplrActyTskDescription(
            final SuplrActyTskDescription value )
        {
            return toSuplrActyTskDescription(value);
        }

        private SupplierActivityTask.SupplierActivityTaskBuilder toSuplrActyTskMessageText(
            final SuplrActyTskMessageText value )
        {
            toSuplrActyTskMessageText = value;
            return this;
        }

        /**
         * Navigation property <b>to_SuplrActyTskMessageText</b> for <b>SupplierActivityTask</b> to single
         * <b>SuplrActyTskMessageText</b>.
         *
         * @param value
         *            The SuplrActyTskMessageText to build this SupplierActivityTask with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SupplierActivityTask.SupplierActivityTaskBuilder suplrActyTskMessageText(
            final SuplrActyTskMessageText value )
        {
            return toSuplrActyTskMessageText(value);
        }

        private SupplierActivityTask.SupplierActivityTaskBuilder toSuplrActyTskProcessor(
            final SuplrActyTskProcessor value )
        {
            toSuplrActyTskProcessor = value;
            return this;
        }

        /**
         * Navigation property <b>to_SuplrActyTskProcessor</b> for <b>SupplierActivityTask</b> to single
         * <b>SuplrActyTskProcessor</b>.
         *
         * @param value
         *            The SuplrActyTskProcessor to build this SupplierActivityTask with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SupplierActivityTask.SupplierActivityTaskBuilder suplrActyTskProcessor(
            final SuplrActyTskProcessor value )
        {
            return toSuplrActyTskProcessor(value);
        }

        private SupplierActivityTask.SupplierActivityTaskBuilder toSuplrActyTskPurchaserResp(
            final SuplrActyTskPurchaserResp value )
        {
            toSuplrActyTskPurchaserResp = value;
            return this;
        }

        /**
         * Navigation property <b>to_SuplrActyTskPurchaserResp</b> for <b>SupplierActivityTask</b> to single
         * <b>SuplrActyTskPurchaserResp</b>.
         *
         * @param value
         *            The SuplrActyTskPurchaserResp to build this SupplierActivityTask with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SupplierActivityTask.SupplierActivityTaskBuilder suplrActyTskPurchaserResp(
            final SuplrActyTskPurchaserResp value )
        {
            return toSuplrActyTskPurchaserResp(value);
        }

        private SupplierActivityTask.SupplierActivityTaskBuilder toSuplrActyTskSupplier(
            final List<SuplrActyTskSupplier> value )
        {
            toSuplrActyTskSupplier.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SuplrActyTskSupplier</b> for <b>SupplierActivityTask</b> to multiple
         * <b>SuplrActyTskSupplier</b>.
         *
         * @param value
         *            The SuplrActyTskSuppliers to build this SupplierActivityTask with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SupplierActivityTask.SupplierActivityTaskBuilder suplrActyTskSupplier( SuplrActyTskSupplier... value )
        {
            return toSuplrActyTskSupplier(Lists.newArrayList(value));
        }

    }

}
