/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperRead;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.selectable.SupplierActivityTaskSelectable;

/**
 * Fluent helper to fetch multiple
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SupplierActivityTask
 * SupplierActivityTask} entities. This fluent helper allows methods which modify the underlying query to be called
 * before executing the query itself.
 *
 */
public class SupplierActivityTaskFluentHelper
    extends
    FluentHelperRead<SupplierActivityTaskFluentHelper, SupplierActivityTask, SupplierActivityTaskSelectable>
{

    /**
     * Creates a fluent helper using the specified service path and entity collection to send the read requests.
     *
     * @param entityCollection
     *            The entity collection to direct the requests to.
     * @param servicePath
     *            The service path to direct the read requests to.
     */
    public SupplierActivityTaskFluentHelper( @Nonnull final String servicePath, @Nonnull final String entityCollection )
    {
        super(servicePath, entityCollection);
    }

    @Override
    @Nonnull
    protected Class<SupplierActivityTask> getEntityClass()
    {
        return SupplierActivityTask.class;
    }

}
