/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link SupplierActivityTaskServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierActivityTaskService SupplierActivityTaskService},
 * allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultSupplierActivityTaskServiceBatch
    extends
    BatchFluentHelperBasic<SupplierActivityTaskServiceBatch, SupplierActivityTaskServiceBatchChangeSet>
    implements
    SupplierActivityTaskServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierActivityTaskService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultSupplierActivityTaskServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultSupplierActivityTaskServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierActivityTaskService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierActivityTaskService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultSupplierActivityTaskServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultSupplierActivityTaskServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierActivityTaskService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultSupplierActivityTaskServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public SupplierActivityTaskServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultSupplierActivityTaskServiceBatchChangeSet(this, service);
    }

}
