/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskActyReference;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskActyReference
 * SuplrActyTskActyReference}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.field.SuplrActyTskActyReferenceField
 * SuplrActyTskActyReferenceField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.link.SuplrActyTskActyReferenceLink
 * SuplrActyTskActyReferenceLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskActyReference#SUPLR_ACTY_TASK_REFERENCE_UUID
 * SUPLR_ACTY_TASK_REFERENCE_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskActyReference#SUPLR_ACTY_TASK_UUID
 * SUPLR_ACTY_TASK_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskActyReference#SUPLR_ACTY_UUID
 * SUPLR_ACTY_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskActyReference#SUPPLIER_ACTIVITY
 * SUPPLIER_ACTIVITY}</li>
 * </ul>
 *
 */
public interface SuplrActyTskActyReferenceSelectable extends EntitySelectable<SuplrActyTskActyReference>
{

}
