/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskDescription;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskDescription
 * SuplrActyTskDescription}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.field.SuplrActyTskDescriptionField
 * SuplrActyTskDescriptionField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.link.SuplrActyTskDescriptionLink
 * SuplrActyTskDescriptionLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskDescription#SUPLR_ACTY_TASK_UUID
 * SUPLR_ACTY_TASK_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskDescription#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskDescription#SUPLR_ACTY_TSK_DESCRIPTION
 * SUPLR_ACTY_TSK_DESCRIPTION}</li>
 * </ul>
 *
 */
public interface SuplrActyTskDescriptionSelectable extends EntitySelectable<SuplrActyTskDescription>
{

}
