/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskMessageText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskMessageText
 * SuplrActyTskMessageText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.field.SuplrActyTskMessageTextField
 * SuplrActyTskMessageTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.link.SuplrActyTskMessageTextLink
 * SuplrActyTskMessageTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskMessageText#SUPLR_ACTY_TASK_UUID
 * SUPLR_ACTY_TASK_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskMessageText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskMessageText#SUPLR_ACTY_TSK_MESSAGE_TEXT
 * SUPLR_ACTY_TSK_MESSAGE_TEXT}</li>
 * </ul>
 *
 */
public interface SuplrActyTskMessageTextSelectable extends EntitySelectable<SuplrActyTskMessageText>
{

}
