/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskPurchaserResp;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskPurchaserResp
 * SuplrActyTskPurchaserResp}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.field.SuplrActyTskPurchaserRespField
 * SuplrActyTskPurchaserRespField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.link.SuplrActyTskPurchaserRespLink
 * SuplrActyTskPurchaserRespLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskPurchaserResp#SUPLR_ACTY_TASK_PARTY_UUID
 * SUPLR_ACTY_TASK_PARTY_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskPurchaserResp#SUPLR_ACTY_TASK_UUID
 * SUPLR_ACTY_TASK_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskPurchaserResp#USER_ID
 * USER_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskPurchaserResp#EMAIL_ADDRESS
 * EMAIL_ADDRESS}</li>
 * </ul>
 *
 */
public interface SuplrActyTskPurchaserRespSelectable extends EntitySelectable<SuplrActyTskPurchaserResp>
{

}
