/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SupplierActivityTask;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SupplierActivityTask
 * SupplierActivityTask}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.field.SupplierActivityTaskField
 * SupplierActivityTaskField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.link.SupplierActivityTaskLink
 * SupplierActivityTaskLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SupplierActivityTask#SUPLR_ACTY_TASK_UUID
 * SUPLR_ACTY_TASK_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SupplierActivityTask#SUPPLIER_ACTIVITY_TASK
 * SUPPLIER_ACTIVITY_TASK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SupplierActivityTask#SUPLR_ACTY_TASK_NAME
 * SUPLR_ACTY_TASK_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SupplierActivityTask#CREATION_DATE_TIME
 * CREATION_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SupplierActivityTask#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SupplierActivityTask#LAST_CHANGED_BY_USER
 * LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SupplierActivityTask#END_DATE
 * END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SupplierActivityTask#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SupplierActivityTask#SUPLR_ACTY_TASK_PRIORITY
 * SUPLR_ACTY_TASK_PRIORITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SupplierActivityTask#SUPLR_ACTY_TASK_LIFECYCLE_STATUS
 * SUPLR_ACTY_TASK_LIFECYCLE_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SupplierActivityTask#TO_SUPLR_ACTY_TSK_ACTY_REFERENCE
 * TO_SUPLR_ACTY_TSK_ACTY_REFERENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SupplierActivityTask#TO_SUPLR_ACTY_TSK_COMM_TEXT
 * TO_SUPLR_ACTY_TSK_COMM_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SupplierActivityTask#TO_SUPLR_ACTY_TSK_DESCRIPTION
 * TO_SUPLR_ACTY_TSK_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SupplierActivityTask#TO_SUPLR_ACTY_TSK_MESSAGE_TEXT
 * TO_SUPLR_ACTY_TSK_MESSAGE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SupplierActivityTask#TO_SUPLR_ACTY_TSK_PROCESSOR
 * TO_SUPLR_ACTY_TSK_PROCESSOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SupplierActivityTask#TO_SUPLR_ACTY_TSK_PURCHASER_RESP
 * TO_SUPLR_ACTY_TSK_PURCHASER_RESP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SupplierActivityTask#TO_SUPLR_ACTY_TSK_SUPPLIER
 * TO_SUPLR_ACTY_TSK_SUPPLIER}</li>
 * </ul>
 *
 */
public interface SupplierActivityTaskSelectable extends EntitySelectable<SupplierActivityTask>
{

}
