/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.field.SuplrEvalRspExternalNameField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.selectable.SuplrEvalRspExternalNameSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * External Name
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SuplrEvalRspExternalNameType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SuplrEvalRspExternalName extends VdmEntity<SuplrEvalRspExternalName>
{

    /**
     * Selector for all available fields of SuplrEvalRspExternalName.
     *
     */
    public final static SuplrEvalRspExternalNameSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalRspUUID</b>
     * </p>
     *
     * @return Evaluation Response UUID
     */
    @Key
    @SerializedName( "SuplrEvalRspUUID" )
    @JsonProperty( "SuplrEvalRspUUID" )
    @Nullable
    @ODataField( odataName = "SuplrEvalRspUUID" )
    private UUID suplrEvalRspUUID;
    /**
     * Use with available fluent helpers to apply the <b>SuplrEvalRspUUID</b> field to query operations.
     *
     */
    public final static SuplrEvalRspExternalNameField<UUID> SUPLR_EVAL_RSP_UUID =
        new SuplrEvalRspExternalNameField<UUID>("SuplrEvalRspUUID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static SuplrEvalRspExternalNameField<String> LANGUAGE =
        new SuplrEvalRspExternalNameField<String>("Language");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalReqExternalNameUUID</b>
     * </p>
     *
     * @return Evaluation Request External Name UUID
     */
    @SerializedName( "SuplrEvalReqExternalNameUUID" )
    @JsonProperty( "SuplrEvalReqExternalNameUUID" )
    @Nullable
    @ODataField( odataName = "SuplrEvalReqExternalNameUUID" )
    private UUID suplrEvalReqExternalNameUUID;
    /**
     * Use with available fluent helpers to apply the <b>SuplrEvalReqExternalNameUUID</b> field to query operations.
     *
     */
    public final static SuplrEvalRspExternalNameField<UUID> SUPLR_EVAL_REQ_EXTERNAL_NAME_UUID =
        new SuplrEvalRspExternalNameField<UUID>("SuplrEvalReqExternalNameUUID");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalReqExternalName</b>
     * </p>
     *
     * @return External Name
     */
    @SerializedName( "SuplrEvalReqExternalName" )
    @JsonProperty( "SuplrEvalReqExternalName" )
    @Nullable
    @ODataField( odataName = "SuplrEvalReqExternalName" )
    private String suplrEvalReqExternalName;
    /**
     * Use with available fluent helpers to apply the <b>SuplrEvalReqExternalName</b> field to query operations.
     *
     */
    public final static SuplrEvalRspExternalNameField<String> SUPLR_EVAL_REQ_EXTERNAL_NAME =
        new SuplrEvalRspExternalNameField<String>("SuplrEvalReqExternalName");

    @Nonnull
    @Override
    public Class<SuplrEvalRspExternalName> getType()
    {
        return SuplrEvalRspExternalName.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalRspUUID</b>
     * </p>
     *
     * @param suplrEvalRspUUID
     *            Evaluation Response UUID
     */
    public void setSuplrEvalRspUUID( @Nullable final UUID suplrEvalRspUUID )
    {
        rememberChangedField("SuplrEvalRspUUID", this.suplrEvalRspUUID);
        this.suplrEvalRspUUID = suplrEvalRspUUID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalReqExternalNameUUID</b>
     * </p>
     *
     * @param suplrEvalReqExternalNameUUID
     *            Evaluation Request External Name UUID
     */
    public void setSuplrEvalReqExternalNameUUID( @Nullable final UUID suplrEvalReqExternalNameUUID )
    {
        rememberChangedField("SuplrEvalReqExternalNameUUID", this.suplrEvalReqExternalNameUUID);
        this.suplrEvalReqExternalNameUUID = suplrEvalReqExternalNameUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalReqExternalName</b>
     * </p>
     *
     * @param suplrEvalReqExternalName
     *            External Name
     */
    public void setSuplrEvalReqExternalName( @Nullable final String suplrEvalReqExternalName )
    {
        rememberChangedField("SuplrEvalReqExternalName", this.suplrEvalReqExternalName);
        this.suplrEvalReqExternalName = suplrEvalReqExternalName;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SuplrEvalRspExternalName";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SuplrEvalRspUUID", getSuplrEvalRspUUID());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SuplrEvalRspUUID", getSuplrEvalRspUUID());
        values.put("Language", getLanguage());
        values.put("SuplrEvalReqExternalNameUUID", getSuplrEvalReqExternalNameUUID());
        values.put("SuplrEvalReqExternalName", getSuplrEvalReqExternalName());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SuplrEvalRspUUID") ) {
                final Object value = values.remove("SuplrEvalRspUUID");
                if( (value == null) || (!value.equals(getSuplrEvalRspUUID())) ) {
                    setSuplrEvalRspUUID(((UUID) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("SuplrEvalReqExternalNameUUID") ) {
                final Object value = values.remove("SuplrEvalReqExternalNameUUID");
                if( (value == null) || (!value.equals(getSuplrEvalReqExternalNameUUID())) ) {
                    setSuplrEvalReqExternalNameUUID(((UUID) value));
                }
            }
            if( values.containsKey("SuplrEvalReqExternalName") ) {
                final Object value = values.remove("SuplrEvalReqExternalName");
                if( (value == null) || (!value.equals(getSuplrEvalReqExternalName())) ) {
                    setSuplrEvalReqExternalName(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SuplrEvalRspExternalNameField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SuplrEvalRspExternalNameField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SuplrEvalRspExternalNameField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SuplrEvalRspExternalNameField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierEvaluationResponseService.DEFAULT_SERVICE_PATH);
    }

}
