/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.selectable.SuplrEvalRspExternalNameSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspExternalName
 * SuplrEvalRspExternalName} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class SuplrEvalRspExternalNameByKeyFluentHelper
    extends
    FluentHelperByKey<SuplrEvalRspExternalNameByKeyFluentHelper, SuplrEvalRspExternalName, SuplrEvalRspExternalNameSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspExternalName
     * SuplrEvalRspExternalName} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SuplrEvalRspExternalName}
     * @param servicePath
     *            Service path to be used to fetch a single {@code SuplrEvalRspExternalName}
     * @param suplrEvalRspUUID
     *            Evaluation Response UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param language
     *            Language
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     */
    public SuplrEvalRspExternalNameByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final UUID suplrEvalRspUUID,
        final String language )
    {
        super(servicePath, entityCollection);
        this.key.put("SuplrEvalRspUUID", suplrEvalRspUUID);
        this.key.put("Language", language);
    }

    @Override
    @Nonnull
    protected Class<SuplrEvalRspExternalName> getEntityClass()
    {
        return SuplrEvalRspExternalName.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
