/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.field.SuplrEvalRspLanguageField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.selectable.SuplrEvalRspLanguageSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Language
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SuplrEvalRspLanguageType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SuplrEvalRspLanguage extends VdmEntity<SuplrEvalRspLanguage>
{

    /**
     * Selector for all available fields of SuplrEvalRspLanguage.
     *
     */
    public final static SuplrEvalRspLanguageSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalRspLanguageUUID</b>
     * </p>
     *
     * @return Evaluation Response Language UUID
     */
    @Key
    @SerializedName( "SuplrEvalRspLanguageUUID" )
    @JsonProperty( "SuplrEvalRspLanguageUUID" )
    @Nullable
    @ODataField( odataName = "SuplrEvalRspLanguageUUID" )
    private UUID suplrEvalRspLanguageUUID;
    /**
     * Use with available fluent helpers to apply the <b>SuplrEvalRspLanguageUUID</b> field to query operations.
     *
     */
    public final static SuplrEvalRspLanguageField<UUID> SUPLR_EVAL_RSP_LANGUAGE_UUID =
        new SuplrEvalRspLanguageField<UUID>("SuplrEvalRspLanguageUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalRspQuestionnaireUUID</b>
     * </p>
     *
     * @return Evaluation Response Questionnaire UUID
     */
    @SerializedName( "SuplrEvalRspQuestionnaireUUID" )
    @JsonProperty( "SuplrEvalRspQuestionnaireUUID" )
    @Nullable
    @ODataField( odataName = "SuplrEvalRspQuestionnaireUUID" )
    private UUID suplrEvalRspQuestionnaireUUID;
    /**
     * Use with available fluent helpers to apply the <b>SuplrEvalRspQuestionnaireUUID</b> field to query operations.
     *
     */
    public final static SuplrEvalRspLanguageField<UUID> SUPLR_EVAL_RSP_QUESTIONNAIRE_UUID =
        new SuplrEvalRspLanguageField<UUID>("SuplrEvalRspQuestionnaireUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalRspUUID</b>
     * </p>
     *
     * @return Evaluation Response UUID
     */
    @SerializedName( "SuplrEvalRspUUID" )
    @JsonProperty( "SuplrEvalRspUUID" )
    @Nullable
    @ODataField( odataName = "SuplrEvalRspUUID" )
    private UUID suplrEvalRspUUID;
    /**
     * Use with available fluent helpers to apply the <b>SuplrEvalRspUUID</b> field to query operations.
     *
     */
    public final static SuplrEvalRspLanguageField<UUID> SUPLR_EVAL_RSP_UUID =
        new SuplrEvalRspLanguageField<UUID>("SuplrEvalRspUUID");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsMasterLanguage</b>
     * </p>
     *
     * @return Master Language
     */
    @SerializedName( "IsMasterLanguage" )
    @JsonProperty( "IsMasterLanguage" )
    @Nullable
    @ODataField( odataName = "IsMasterLanguage" )
    private String isMasterLanguage;
    /**
     * Use with available fluent helpers to apply the <b>IsMasterLanguage</b> field to query operations.
     *
     */
    public final static SuplrEvalRspLanguageField<String> IS_MASTER_LANGUAGE =
        new SuplrEvalRspLanguageField<String>("IsMasterLanguage");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsSelectedLanguage</b>
     * </p>
     *
     * @return Selected Language
     */
    @SerializedName( "IsSelectedLanguage" )
    @JsonProperty( "IsSelectedLanguage" )
    @Nullable
    @ODataField( odataName = "IsSelectedLanguage" )
    private String isSelectedLanguage;
    /**
     * Use with available fluent helpers to apply the <b>IsSelectedLanguage</b> field to query operations.
     *
     */
    public final static SuplrEvalRspLanguageField<String> IS_SELECTED_LANGUAGE =
        new SuplrEvalRspLanguageField<String>("IsSelectedLanguage");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language
     */
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static SuplrEvalRspLanguageField<String> LANGUAGE = new SuplrEvalRspLanguageField<String>("Language");

    @Nonnull
    @Override
    public Class<SuplrEvalRspLanguage> getType()
    {
        return SuplrEvalRspLanguage.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalRspLanguageUUID</b>
     * </p>
     *
     * @param suplrEvalRspLanguageUUID
     *            Evaluation Response Language UUID
     */
    public void setSuplrEvalRspLanguageUUID( @Nullable final UUID suplrEvalRspLanguageUUID )
    {
        rememberChangedField("SuplrEvalRspLanguageUUID", this.suplrEvalRspLanguageUUID);
        this.suplrEvalRspLanguageUUID = suplrEvalRspLanguageUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalRspQuestionnaireUUID</b>
     * </p>
     *
     * @param suplrEvalRspQuestionnaireUUID
     *            Evaluation Response Questionnaire UUID
     */
    public void setSuplrEvalRspQuestionnaireUUID( @Nullable final UUID suplrEvalRspQuestionnaireUUID )
    {
        rememberChangedField("SuplrEvalRspQuestionnaireUUID", this.suplrEvalRspQuestionnaireUUID);
        this.suplrEvalRspQuestionnaireUUID = suplrEvalRspQuestionnaireUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalRspUUID</b>
     * </p>
     *
     * @param suplrEvalRspUUID
     *            Evaluation Response UUID
     */
    public void setSuplrEvalRspUUID( @Nullable final UUID suplrEvalRspUUID )
    {
        rememberChangedField("SuplrEvalRspUUID", this.suplrEvalRspUUID);
        this.suplrEvalRspUUID = suplrEvalRspUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsMasterLanguage</b>
     * </p>
     *
     * @param isMasterLanguage
     *            Master Language
     */
    public void setIsMasterLanguage( @Nullable final String isMasterLanguage )
    {
        rememberChangedField("IsMasterLanguage", this.isMasterLanguage);
        this.isMasterLanguage = isMasterLanguage;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsSelectedLanguage</b>
     * </p>
     *
     * @param isSelectedLanguage
     *            Selected Language
     */
    public void setIsSelectedLanguage( @Nullable final String isSelectedLanguage )
    {
        rememberChangedField("IsSelectedLanguage", this.isSelectedLanguage);
        this.isSelectedLanguage = isSelectedLanguage;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SuplrEvalRspLanguage";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SuplrEvalRspLanguageUUID", getSuplrEvalRspLanguageUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SuplrEvalRspLanguageUUID", getSuplrEvalRspLanguageUUID());
        values.put("SuplrEvalRspQuestionnaireUUID", getSuplrEvalRspQuestionnaireUUID());
        values.put("SuplrEvalRspUUID", getSuplrEvalRspUUID());
        values.put("IsMasterLanguage", getIsMasterLanguage());
        values.put("IsSelectedLanguage", getIsSelectedLanguage());
        values.put("Language", getLanguage());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SuplrEvalRspLanguageUUID") ) {
                final Object value = values.remove("SuplrEvalRspLanguageUUID");
                if( (value == null) || (!value.equals(getSuplrEvalRspLanguageUUID())) ) {
                    setSuplrEvalRspLanguageUUID(((UUID) value));
                }
            }
            if( values.containsKey("SuplrEvalRspQuestionnaireUUID") ) {
                final Object value = values.remove("SuplrEvalRspQuestionnaireUUID");
                if( (value == null) || (!value.equals(getSuplrEvalRspQuestionnaireUUID())) ) {
                    setSuplrEvalRspQuestionnaireUUID(((UUID) value));
                }
            }
            if( values.containsKey("SuplrEvalRspUUID") ) {
                final Object value = values.remove("SuplrEvalRspUUID");
                if( (value == null) || (!value.equals(getSuplrEvalRspUUID())) ) {
                    setSuplrEvalRspUUID(((UUID) value));
                }
            }
            if( values.containsKey("IsMasterLanguage") ) {
                final Object value = values.remove("IsMasterLanguage");
                if( (value == null) || (!value.equals(getIsMasterLanguage())) ) {
                    setIsMasterLanguage(((String) value));
                }
            }
            if( values.containsKey("IsSelectedLanguage") ) {
                final Object value = values.remove("IsSelectedLanguage");
                if( (value == null) || (!value.equals(getIsSelectedLanguage())) ) {
                    setIsSelectedLanguage(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SuplrEvalRspLanguageField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SuplrEvalRspLanguageField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SuplrEvalRspLanguageField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SuplrEvalRspLanguageField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierEvaluationResponseService.DEFAULT_SERVICE_PATH);
    }

}
