/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse;

import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.field.SuplrEvalRspQuestionField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.link.SuplrEvalRspQuestionLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.selectable.SuplrEvalRspQuestionSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Question
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SuplrEvalRspQuestionType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SuplrEvalRspQuestion extends VdmEntity<SuplrEvalRspQuestion>
{

    /**
     * Selector for all available fields of SuplrEvalRspQuestion.
     *
     */
    public final static SuplrEvalRspQuestionSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalRspQuestionUUID</b>
     * </p>
     *
     * @return Evaluation Response Question UUID
     */
    @Key
    @SerializedName( "SuplrEvalRspQuestionUUID" )
    @JsonProperty( "SuplrEvalRspQuestionUUID" )
    @Nullable
    @ODataField( odataName = "SuplrEvalRspQuestionUUID" )
    private UUID suplrEvalRspQuestionUUID;
    /**
     * Use with available fluent helpers to apply the <b>SuplrEvalRspQuestionUUID</b> field to query operations.
     *
     */
    public final static SuplrEvalRspQuestionField<UUID> SUPLR_EVAL_RSP_QUESTION_UUID =
        new SuplrEvalRspQuestionField<UUID>("SuplrEvalRspQuestionUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalRspUUID</b>
     * </p>
     *
     * @return Evaluation Response UUID
     */
    @SerializedName( "SuplrEvalRspUUID" )
    @JsonProperty( "SuplrEvalRspUUID" )
    @Nullable
    @ODataField( odataName = "SuplrEvalRspUUID" )
    private UUID suplrEvalRspUUID;
    /**
     * Use with available fluent helpers to apply the <b>SuplrEvalRspUUID</b> field to query operations.
     *
     */
    public final static SuplrEvalRspQuestionField<UUID> SUPLR_EVAL_RSP_UUID =
        new SuplrEvalRspQuestionField<UUID>("SuplrEvalRspUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalRspBrnchgQuestionUUID</b>
     * </p>
     *
     * @return NodeID
     */
    @SerializedName( "SuplrEvalRspBrnchgQuestionUUID" )
    @JsonProperty( "SuplrEvalRspBrnchgQuestionUUID" )
    @Nullable
    @ODataField( odataName = "SuplrEvalRspBrnchgQuestionUUID" )
    private UUID suplrEvalRspBrnchgQuestionUUID;
    /**
     * Use with available fluent helpers to apply the <b>SuplrEvalRspBrnchgQuestionUUID</b> field to query operations.
     *
     */
    public final static SuplrEvalRspQuestionField<UUID> SUPLR_EVAL_RSP_BRNCHG_QUESTION_UUID =
        new SuplrEvalRspQuestionField<UUID>("SuplrEvalRspBrnchgQuestionUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalRspSectionUUID</b>
     * </p>
     *
     * @return Evaluation Response Section UUID
     */
    @SerializedName( "SuplrEvalRspSectionUUID" )
    @JsonProperty( "SuplrEvalRspSectionUUID" )
    @Nullable
    @ODataField( odataName = "SuplrEvalRspSectionUUID" )
    private UUID suplrEvalRspSectionUUID;
    /**
     * Use with available fluent helpers to apply the <b>SuplrEvalRspSectionUUID</b> field to query operations.
     *
     */
    public final static SuplrEvalRspQuestionField<UUID> SUPLR_EVAL_RSP_SECTION_UUID =
        new SuplrEvalRspQuestionField<UUID>("SuplrEvalRspSectionUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalRspBrnchgQstnValnUUID</b>
     * </p>
     *
     * @return Evaluation Response Valuation UUID
     */
    @SerializedName( "SuplrEvalRspBrnchgQstnValnUUID" )
    @JsonProperty( "SuplrEvalRspBrnchgQstnValnUUID" )
    @Nullable
    @ODataField( odataName = "SuplrEvalRspBrnchgQstnValnUUID" )
    private UUID suplrEvalRspBrnchgQstnValnUUID;
    /**
     * Use with available fluent helpers to apply the <b>SuplrEvalRspBrnchgQstnValnUUID</b> field to query operations.
     *
     */
    public final static SuplrEvalRspQuestionField<UUID> SUPLR_EVAL_RSP_BRNCHG_QSTN_VALN_UUID =
        new SuplrEvalRspQuestionField<UUID>("SuplrEvalRspBrnchgQstnValnUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalReqQuestionUUID</b>
     * </p>
     *
     * @return Evaluation Request Question UUID
     */
    @SerializedName( "SuplrEvalReqQuestionUUID" )
    @JsonProperty( "SuplrEvalReqQuestionUUID" )
    @Nullable
    @ODataField( odataName = "SuplrEvalReqQuestionUUID" )
    private UUID suplrEvalReqQuestionUUID;
    /**
     * Use with available fluent helpers to apply the <b>SuplrEvalReqQuestionUUID</b> field to query operations.
     *
     */
    public final static SuplrEvalRspQuestionField<UUID> SUPLR_EVAL_REQ_QUESTION_UUID =
        new SuplrEvalRspQuestionField<UUID>("SuplrEvalReqQuestionUUID");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SupplierEvalQuestion</b>
     * </p>
     *
     * @return Identifier for a Question
     */
    @SerializedName( "SupplierEvalQuestion" )
    @JsonProperty( "SupplierEvalQuestion" )
    @Nullable
    @ODataField( odataName = "SupplierEvalQuestion" )
    private String supplierEvalQuestion;
    /**
     * Use with available fluent helpers to apply the <b>SupplierEvalQuestion</b> field to query operations.
     *
     */
    public final static SuplrEvalRspQuestionField<String> SUPPLIER_EVAL_QUESTION =
        new SuplrEvalRspQuestionField<String>("SupplierEvalQuestion");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SupplierEvalRequestQuestion</b>
     * </p>
     *
     * @return Identifier for a Question
     */
    @SerializedName( "SupplierEvalRequestQuestion" )
    @JsonProperty( "SupplierEvalRequestQuestion" )
    @Nullable
    @ODataField( odataName = "SupplierEvalRequestQuestion" )
    private String supplierEvalRequestQuestion;
    /**
     * Use with available fluent helpers to apply the <b>SupplierEvalRequestQuestion</b> field to query operations.
     *
     */
    public final static SuplrEvalRspQuestionField<String> SUPPLIER_EVAL_REQUEST_QUESTION =
        new SuplrEvalRspQuestionField<String>("SupplierEvalRequestQuestion");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>QuestionName</b>
     * </p>
     *
     * @return Medium-Size Name
     */
    @SerializedName( "QuestionName" )
    @JsonProperty( "QuestionName" )
    @Nullable
    @ODataField( odataName = "QuestionName" )
    private String questionName;
    /**
     * Use with available fluent helpers to apply the <b>QuestionName</b> field to query operations.
     *
     */
    public final static SuplrEvalRspQuestionField<String> QUESTION_NAME =
        new SuplrEvalRspQuestionField<String>("QuestionName");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsDisqualifyingQuestion</b>
     * </p>
     *
     * @return Disqualifying
     */
    @SerializedName( "IsDisqualifyingQuestion" )
    @JsonProperty( "IsDisqualifyingQuestion" )
    @Nullable
    @ODataField( odataName = "IsDisqualifyingQuestion" )
    private String isDisqualifyingQuestion;
    /**
     * Use with available fluent helpers to apply the <b>IsDisqualifyingQuestion</b> field to query operations.
     *
     */
    public final static SuplrEvalRspQuestionField<String> IS_DISQUALIFYING_QUESTION =
        new SuplrEvalRspQuestionField<String>("IsDisqualifyingQuestion");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsMandatoryQuestion</b>
     * </p>
     *
     * @return Mandatory
     */
    @SerializedName( "IsMandatoryQuestion" )
    @JsonProperty( "IsMandatoryQuestion" )
    @Nullable
    @ODataField( odataName = "IsMandatoryQuestion" )
    private String isMandatoryQuestion;
    /**
     * Use with available fluent helpers to apply the <b>IsMandatoryQuestion</b> field to query operations.
     *
     */
    public final static SuplrEvalRspQuestionField<String> IS_MANDATORY_QUESTION =
        new SuplrEvalRspQuestionField<String>("IsMandatoryQuestion");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsQuestionCommentEnabled</b>
     * </p>
     *
     * @return Question Comments
     */
    @SerializedName( "IsQuestionCommentEnabled" )
    @JsonProperty( "IsQuestionCommentEnabled" )
    @Nullable
    @ODataField( odataName = "IsQuestionCommentEnabled" )
    private String isQuestionCommentEnabled;
    /**
     * Use with available fluent helpers to apply the <b>IsQuestionCommentEnabled</b> field to query operations.
     *
     */
    public final static SuplrEvalRspQuestionField<String> IS_QUESTION_COMMENT_ENABLED =
        new SuplrEvalRspQuestionField<String>("IsQuestionCommentEnabled");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>NumberOfResponses</b>
     * </p>
     *
     * @return Number of Responses
     */
    @SerializedName( "NumberOfResponses" )
    @JsonProperty( "NumberOfResponses" )
    @Nullable
    @ODataField( odataName = "NumberOfResponses" )
    private Integer numberOfResponses;
    /**
     * Use with available fluent helpers to apply the <b>NumberOfResponses</b> field to query operations.
     *
     */
    public final static SuplrEvalRspQuestionField<Integer> NUMBER_OF_RESPONSES =
        new SuplrEvalRspQuestionField<Integer>("NumberOfResponses");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SLCPreferredAnswer</b>
     * </p>
     *
     * @return Preferred Answer to a Yes/No Question
     */
    @SerializedName( "SLCPreferredAnswer" )
    @JsonProperty( "SLCPreferredAnswer" )
    @Nullable
    @ODataField( odataName = "SLCPreferredAnswer" )
    private String sLCPreferredAnswer;
    /**
     * Use with available fluent helpers to apply the <b>SLCPreferredAnswer</b> field to query operations.
     *
     */
    public final static SuplrEvalRspQuestionField<String> SLC_PREFERRED_ANSWER =
        new SuplrEvalRspQuestionField<String>("SLCPreferredAnswer");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SLCQuestionAttachmentOption</b>
     * </p>
     *
     * @return Question Attachments
     */
    @SerializedName( "SLCQuestionAttachmentOption" )
    @JsonProperty( "SLCQuestionAttachmentOption" )
    @Nullable
    @ODataField( odataName = "SLCQuestionAttachmentOption" )
    private String sLCQuestionAttachmentOption;
    /**
     * Use with available fluent helpers to apply the <b>SLCQuestionAttachmentOption</b> field to query operations.
     *
     */
    public final static SuplrEvalRspQuestionField<String> SLC_QUESTION_ATTACHMENT_OPTION =
        new SuplrEvalRspQuestionField<String>("SLCQuestionAttachmentOption");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalOrdinalNumber</b>
     * </p>
     *
     * @return Ordinal Number Value
     */
    @SerializedName( "SuplrEvalOrdinalNumber" )
    @JsonProperty( "SuplrEvalOrdinalNumber" )
    @Nullable
    @ODataField( odataName = "SuplrEvalOrdinalNumber" )
    private Integer suplrEvalOrdinalNumber;
    /**
     * Use with available fluent helpers to apply the <b>SuplrEvalOrdinalNumber</b> field to query operations.
     *
     */
    public final static SuplrEvalRspQuestionField<Integer> SUPLR_EVAL_ORDINAL_NUMBER =
        new SuplrEvalRspQuestionField<Integer>("SuplrEvalOrdinalNumber");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalRspBrnchgQuestion</b>
     * </p>
     *
     * @return SLC Object ID
     */
    @SerializedName( "SuplrEvalRspBrnchgQuestion" )
    @JsonProperty( "SuplrEvalRspBrnchgQuestion" )
    @Nullable
    @ODataField( odataName = "SuplrEvalRspBrnchgQuestion" )
    private String suplrEvalRspBrnchgQuestion;
    /**
     * Use with available fluent helpers to apply the <b>SuplrEvalRspBrnchgQuestion</b> field to query operations.
     *
     */
    public final static SuplrEvalRspQuestionField<String> SUPLR_EVAL_RSP_BRNCHG_QUESTION =
        new SuplrEvalRspQuestionField<String>("SuplrEvalRspBrnchgQuestion");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalRspBrnchgQuestionValn</b>
     * </p>
     *
     * @return Identifier for a Question Value
     */
    @SerializedName( "SuplrEvalRspBrnchgQuestionValn" )
    @JsonProperty( "SuplrEvalRspBrnchgQuestionValn" )
    @Nullable
    @ODataField( odataName = "SuplrEvalRspBrnchgQuestionValn" )
    private String suplrEvalRspBrnchgQuestionValn;
    /**
     * Use with available fluent helpers to apply the <b>SuplrEvalRspBrnchgQuestionValn</b> field to query operations.
     *
     */
    public final static SuplrEvalRspQuestionField<String> SUPLR_EVAL_RSP_BRNCHG_QUESTION_VALN =
        new SuplrEvalRspQuestionField<String>("SuplrEvalRspBrnchgQuestionValn");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SLCQuestionType</b>
     * </p>
     *
     * @return Question Type Code
     */
    @SerializedName( "SLCQuestionType" )
    @JsonProperty( "SLCQuestionType" )
    @Nullable
    @ODataField( odataName = "SLCQuestionType" )
    private String sLCQuestionType;
    /**
     * Use with available fluent helpers to apply the <b>SLCQuestionType</b> field to query operations.
     *
     */
    public final static SuplrEvalRspQuestionField<String> SLC_QUESTION_TYPE =
        new SuplrEvalRspQuestionField<String>("SLCQuestionType");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>WeightingFactor</b>
     * </p>
     *
     * @return Value of Weighting Factor
     */
    @SerializedName( "WeightingFactor" )
    @JsonProperty( "WeightingFactor" )
    @Nullable
    @ODataField( odataName = "WeightingFactor" )
    private Short weightingFactor;
    /**
     * Use with available fluent helpers to apply the <b>WeightingFactor</b> field to query operations.
     *
     */
    public final static SuplrEvalRspQuestionField<Short> WEIGHTING_FACTOR =
        new SuplrEvalRspQuestionField<Short>("WeightingFactor");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MinimalScore</b>
     * </p>
     *
     * @return Minimum Score Accepted
     */
    @SerializedName( "MinimalScore" )
    @JsonProperty( "MinimalScore" )
    @Nullable
    @ODataField( odataName = "MinimalScore" )
    private Short minimalScore;
    /**
     * Use with available fluent helpers to apply the <b>MinimalScore</b> field to query operations.
     *
     */
    public final static SuplrEvalRspQuestionField<Short> MINIMAL_SCORE =
        new SuplrEvalRspQuestionField<Short>("MinimalScore");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>TargetScore</b>
     * </p>
     *
     * @return Target Score
     */
    @SerializedName( "TargetScore" )
    @JsonProperty( "TargetScore" )
    @Nullable
    @ODataField( odataName = "TargetScore" )
    private Short targetScore;
    /**
     * Use with available fluent helpers to apply the <b>TargetScore</b> field to query operations.
     *
     */
    public final static SuplrEvalRspQuestionField<Short> TARGET_SCORE =
        new SuplrEvalRspQuestionField<Short>("TargetScore");
    /**
     * Navigation property <b>to_SuplrEvalRspExplText</b> for <b>SuplrEvalRspQuestion</b> to multiple
     * <b>SuplrEvalRspExplText</b>.
     *
     */
    @SerializedName( "to_SuplrEvalRspExplText" )
    @JsonProperty( "to_SuplrEvalRspExplText" )
    @ODataField( odataName = "to_SuplrEvalRspExplText" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SuplrEvalRspExplText> toSuplrEvalRspExplText;
    /**
     * Navigation property <b>to_SuplrEvalRspQuestionText</b> for <b>SuplrEvalRspQuestion</b> to multiple
     * <b>SuplrEvalRspQuestionText</b>.
     *
     */
    @SerializedName( "to_SuplrEvalRspQuestionText" )
    @JsonProperty( "to_SuplrEvalRspQuestionText" )
    @ODataField( odataName = "to_SuplrEvalRspQuestionText" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SuplrEvalRspQuestionText> toSuplrEvalRspQuestionText;
    /**
     * Use with available fluent helpers to apply the <b>to_SuplrEvalRspExplText</b> navigation property to query
     * operations.
     *
     */
    public final static SuplrEvalRspQuestionLink<SuplrEvalRspExplText> TO_SUPLR_EVAL_RSP_EXPL_TEXT =
        new SuplrEvalRspQuestionLink<SuplrEvalRspExplText>("to_SuplrEvalRspExplText");
    /**
     * Use with available fluent helpers to apply the <b>to_SuplrEvalRspQuestionText</b> navigation property to query
     * operations.
     *
     */
    public final static SuplrEvalRspQuestionLink<SuplrEvalRspQuestionText> TO_SUPLR_EVAL_RSP_QUESTION_TEXT =
        new SuplrEvalRspQuestionLink<SuplrEvalRspQuestionText>("to_SuplrEvalRspQuestionText");

    @Nonnull
    @Override
    public Class<SuplrEvalRspQuestion> getType()
    {
        return SuplrEvalRspQuestion.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalRspQuestionUUID</b>
     * </p>
     *
     * @param suplrEvalRspQuestionUUID
     *            Evaluation Response Question UUID
     */
    public void setSuplrEvalRspQuestionUUID( @Nullable final UUID suplrEvalRspQuestionUUID )
    {
        rememberChangedField("SuplrEvalRspQuestionUUID", this.suplrEvalRspQuestionUUID);
        this.suplrEvalRspQuestionUUID = suplrEvalRspQuestionUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalRspUUID</b>
     * </p>
     *
     * @param suplrEvalRspUUID
     *            Evaluation Response UUID
     */
    public void setSuplrEvalRspUUID( @Nullable final UUID suplrEvalRspUUID )
    {
        rememberChangedField("SuplrEvalRspUUID", this.suplrEvalRspUUID);
        this.suplrEvalRspUUID = suplrEvalRspUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalRspBrnchgQuestionUUID</b>
     * </p>
     *
     * @param suplrEvalRspBrnchgQuestionUUID
     *            NodeID
     */
    public void setSuplrEvalRspBrnchgQuestionUUID( @Nullable final UUID suplrEvalRspBrnchgQuestionUUID )
    {
        rememberChangedField("SuplrEvalRspBrnchgQuestionUUID", this.suplrEvalRspBrnchgQuestionUUID);
        this.suplrEvalRspBrnchgQuestionUUID = suplrEvalRspBrnchgQuestionUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalRspSectionUUID</b>
     * </p>
     *
     * @param suplrEvalRspSectionUUID
     *            Evaluation Response Section UUID
     */
    public void setSuplrEvalRspSectionUUID( @Nullable final UUID suplrEvalRspSectionUUID )
    {
        rememberChangedField("SuplrEvalRspSectionUUID", this.suplrEvalRspSectionUUID);
        this.suplrEvalRspSectionUUID = suplrEvalRspSectionUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalRspBrnchgQstnValnUUID</b>
     * </p>
     *
     * @param suplrEvalRspBrnchgQstnValnUUID
     *            Evaluation Response Valuation UUID
     */
    public void setSuplrEvalRspBrnchgQstnValnUUID( @Nullable final UUID suplrEvalRspBrnchgQstnValnUUID )
    {
        rememberChangedField("SuplrEvalRspBrnchgQstnValnUUID", this.suplrEvalRspBrnchgQstnValnUUID);
        this.suplrEvalRspBrnchgQstnValnUUID = suplrEvalRspBrnchgQstnValnUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalReqQuestionUUID</b>
     * </p>
     *
     * @param suplrEvalReqQuestionUUID
     *            Evaluation Request Question UUID
     */
    public void setSuplrEvalReqQuestionUUID( @Nullable final UUID suplrEvalReqQuestionUUID )
    {
        rememberChangedField("SuplrEvalReqQuestionUUID", this.suplrEvalReqQuestionUUID);
        this.suplrEvalReqQuestionUUID = suplrEvalReqQuestionUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SupplierEvalQuestion</b>
     * </p>
     *
     * @param supplierEvalQuestion
     *            Identifier for a Question
     */
    public void setSupplierEvalQuestion( @Nullable final String supplierEvalQuestion )
    {
        rememberChangedField("SupplierEvalQuestion", this.supplierEvalQuestion);
        this.supplierEvalQuestion = supplierEvalQuestion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SupplierEvalRequestQuestion</b>
     * </p>
     *
     * @param supplierEvalRequestQuestion
     *            Identifier for a Question
     */
    public void setSupplierEvalRequestQuestion( @Nullable final String supplierEvalRequestQuestion )
    {
        rememberChangedField("SupplierEvalRequestQuestion", this.supplierEvalRequestQuestion);
        this.supplierEvalRequestQuestion = supplierEvalRequestQuestion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>QuestionName</b>
     * </p>
     *
     * @param questionName
     *            Medium-Size Name
     */
    public void setQuestionName( @Nullable final String questionName )
    {
        rememberChangedField("QuestionName", this.questionName);
        this.questionName = questionName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsDisqualifyingQuestion</b>
     * </p>
     *
     * @param isDisqualifyingQuestion
     *            Disqualifying
     */
    public void setIsDisqualifyingQuestion( @Nullable final String isDisqualifyingQuestion )
    {
        rememberChangedField("IsDisqualifyingQuestion", this.isDisqualifyingQuestion);
        this.isDisqualifyingQuestion = isDisqualifyingQuestion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsMandatoryQuestion</b>
     * </p>
     *
     * @param isMandatoryQuestion
     *            Mandatory
     */
    public void setIsMandatoryQuestion( @Nullable final String isMandatoryQuestion )
    {
        rememberChangedField("IsMandatoryQuestion", this.isMandatoryQuestion);
        this.isMandatoryQuestion = isMandatoryQuestion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsQuestionCommentEnabled</b>
     * </p>
     *
     * @param isQuestionCommentEnabled
     *            Question Comments
     */
    public void setIsQuestionCommentEnabled( @Nullable final String isQuestionCommentEnabled )
    {
        rememberChangedField("IsQuestionCommentEnabled", this.isQuestionCommentEnabled);
        this.isQuestionCommentEnabled = isQuestionCommentEnabled;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>NumberOfResponses</b>
     * </p>
     *
     * @param numberOfResponses
     *            Number of Responses
     */
    public void setNumberOfResponses( @Nullable final Integer numberOfResponses )
    {
        rememberChangedField("NumberOfResponses", this.numberOfResponses);
        this.numberOfResponses = numberOfResponses;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SLCPreferredAnswer</b>
     * </p>
     *
     * @param sLCPreferredAnswer
     *            Preferred Answer to a Yes/No Question
     */
    public void setSLCPreferredAnswer( @Nullable final String sLCPreferredAnswer )
    {
        rememberChangedField("SLCPreferredAnswer", this.sLCPreferredAnswer);
        this.sLCPreferredAnswer = sLCPreferredAnswer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SLCQuestionAttachmentOption</b>
     * </p>
     *
     * @param sLCQuestionAttachmentOption
     *            Question Attachments
     */
    public void setSLCQuestionAttachmentOption( @Nullable final String sLCQuestionAttachmentOption )
    {
        rememberChangedField("SLCQuestionAttachmentOption", this.sLCQuestionAttachmentOption);
        this.sLCQuestionAttachmentOption = sLCQuestionAttachmentOption;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalOrdinalNumber</b>
     * </p>
     *
     * @param suplrEvalOrdinalNumber
     *            Ordinal Number Value
     */
    public void setSuplrEvalOrdinalNumber( @Nullable final Integer suplrEvalOrdinalNumber )
    {
        rememberChangedField("SuplrEvalOrdinalNumber", this.suplrEvalOrdinalNumber);
        this.suplrEvalOrdinalNumber = suplrEvalOrdinalNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalRspBrnchgQuestion</b>
     * </p>
     *
     * @param suplrEvalRspBrnchgQuestion
     *            SLC Object ID
     */
    public void setSuplrEvalRspBrnchgQuestion( @Nullable final String suplrEvalRspBrnchgQuestion )
    {
        rememberChangedField("SuplrEvalRspBrnchgQuestion", this.suplrEvalRspBrnchgQuestion);
        this.suplrEvalRspBrnchgQuestion = suplrEvalRspBrnchgQuestion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalRspBrnchgQuestionValn</b>
     * </p>
     *
     * @param suplrEvalRspBrnchgQuestionValn
     *            Identifier for a Question Value
     */
    public void setSuplrEvalRspBrnchgQuestionValn( @Nullable final String suplrEvalRspBrnchgQuestionValn )
    {
        rememberChangedField("SuplrEvalRspBrnchgQuestionValn", this.suplrEvalRspBrnchgQuestionValn);
        this.suplrEvalRspBrnchgQuestionValn = suplrEvalRspBrnchgQuestionValn;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SLCQuestionType</b>
     * </p>
     *
     * @param sLCQuestionType
     *            Question Type Code
     */
    public void setSLCQuestionType( @Nullable final String sLCQuestionType )
    {
        rememberChangedField("SLCQuestionType", this.sLCQuestionType);
        this.sLCQuestionType = sLCQuestionType;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>WeightingFactor</b>
     * </p>
     *
     * @param weightingFactor
     *            Value of Weighting Factor
     */
    public void setWeightingFactor( @Nullable final Short weightingFactor )
    {
        rememberChangedField("WeightingFactor", this.weightingFactor);
        this.weightingFactor = weightingFactor;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MinimalScore</b>
     * </p>
     *
     * @param minimalScore
     *            Minimum Score Accepted
     */
    public void setMinimalScore( @Nullable final Short minimalScore )
    {
        rememberChangedField("MinimalScore", this.minimalScore);
        this.minimalScore = minimalScore;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>TargetScore</b>
     * </p>
     *
     * @param targetScore
     *            Target Score
     */
    public void setTargetScore( @Nullable final Short targetScore )
    {
        rememberChangedField("TargetScore", this.targetScore);
        this.targetScore = targetScore;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SuplrEvalRspQuestion";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SuplrEvalRspQuestionUUID", getSuplrEvalRspQuestionUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SuplrEvalRspQuestionUUID", getSuplrEvalRspQuestionUUID());
        values.put("SuplrEvalRspUUID", getSuplrEvalRspUUID());
        values.put("SuplrEvalRspBrnchgQuestionUUID", getSuplrEvalRspBrnchgQuestionUUID());
        values.put("SuplrEvalRspSectionUUID", getSuplrEvalRspSectionUUID());
        values.put("SuplrEvalRspBrnchgQstnValnUUID", getSuplrEvalRspBrnchgQstnValnUUID());
        values.put("SuplrEvalReqQuestionUUID", getSuplrEvalReqQuestionUUID());
        values.put("SupplierEvalQuestion", getSupplierEvalQuestion());
        values.put("SupplierEvalRequestQuestion", getSupplierEvalRequestQuestion());
        values.put("QuestionName", getQuestionName());
        values.put("IsDisqualifyingQuestion", getIsDisqualifyingQuestion());
        values.put("IsMandatoryQuestion", getIsMandatoryQuestion());
        values.put("IsQuestionCommentEnabled", getIsQuestionCommentEnabled());
        values.put("NumberOfResponses", getNumberOfResponses());
        values.put("SLCPreferredAnswer", getSLCPreferredAnswer());
        values.put("SLCQuestionAttachmentOption", getSLCQuestionAttachmentOption());
        values.put("SuplrEvalOrdinalNumber", getSuplrEvalOrdinalNumber());
        values.put("SuplrEvalRspBrnchgQuestion", getSuplrEvalRspBrnchgQuestion());
        values.put("SuplrEvalRspBrnchgQuestionValn", getSuplrEvalRspBrnchgQuestionValn());
        values.put("SLCQuestionType", getSLCQuestionType());
        values.put("WeightingFactor", getWeightingFactor());
        values.put("MinimalScore", getMinimalScore());
        values.put("TargetScore", getTargetScore());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SuplrEvalRspQuestionUUID") ) {
                final Object value = values.remove("SuplrEvalRspQuestionUUID");
                if( (value == null) || (!value.equals(getSuplrEvalRspQuestionUUID())) ) {
                    setSuplrEvalRspQuestionUUID(((UUID) value));
                }
            }
            if( values.containsKey("SuplrEvalRspUUID") ) {
                final Object value = values.remove("SuplrEvalRspUUID");
                if( (value == null) || (!value.equals(getSuplrEvalRspUUID())) ) {
                    setSuplrEvalRspUUID(((UUID) value));
                }
            }
            if( values.containsKey("SuplrEvalRspBrnchgQuestionUUID") ) {
                final Object value = values.remove("SuplrEvalRspBrnchgQuestionUUID");
                if( (value == null) || (!value.equals(getSuplrEvalRspBrnchgQuestionUUID())) ) {
                    setSuplrEvalRspBrnchgQuestionUUID(((UUID) value));
                }
            }
            if( values.containsKey("SuplrEvalRspSectionUUID") ) {
                final Object value = values.remove("SuplrEvalRspSectionUUID");
                if( (value == null) || (!value.equals(getSuplrEvalRspSectionUUID())) ) {
                    setSuplrEvalRspSectionUUID(((UUID) value));
                }
            }
            if( values.containsKey("SuplrEvalRspBrnchgQstnValnUUID") ) {
                final Object value = values.remove("SuplrEvalRspBrnchgQstnValnUUID");
                if( (value == null) || (!value.equals(getSuplrEvalRspBrnchgQstnValnUUID())) ) {
                    setSuplrEvalRspBrnchgQstnValnUUID(((UUID) value));
                }
            }
            if( values.containsKey("SuplrEvalReqQuestionUUID") ) {
                final Object value = values.remove("SuplrEvalReqQuestionUUID");
                if( (value == null) || (!value.equals(getSuplrEvalReqQuestionUUID())) ) {
                    setSuplrEvalReqQuestionUUID(((UUID) value));
                }
            }
            if( values.containsKey("SupplierEvalQuestion") ) {
                final Object value = values.remove("SupplierEvalQuestion");
                if( (value == null) || (!value.equals(getSupplierEvalQuestion())) ) {
                    setSupplierEvalQuestion(((String) value));
                }
            }
            if( values.containsKey("SupplierEvalRequestQuestion") ) {
                final Object value = values.remove("SupplierEvalRequestQuestion");
                if( (value == null) || (!value.equals(getSupplierEvalRequestQuestion())) ) {
                    setSupplierEvalRequestQuestion(((String) value));
                }
            }
            if( values.containsKey("QuestionName") ) {
                final Object value = values.remove("QuestionName");
                if( (value == null) || (!value.equals(getQuestionName())) ) {
                    setQuestionName(((String) value));
                }
            }
            if( values.containsKey("IsDisqualifyingQuestion") ) {
                final Object value = values.remove("IsDisqualifyingQuestion");
                if( (value == null) || (!value.equals(getIsDisqualifyingQuestion())) ) {
                    setIsDisqualifyingQuestion(((String) value));
                }
            }
            if( values.containsKey("IsMandatoryQuestion") ) {
                final Object value = values.remove("IsMandatoryQuestion");
                if( (value == null) || (!value.equals(getIsMandatoryQuestion())) ) {
                    setIsMandatoryQuestion(((String) value));
                }
            }
            if( values.containsKey("IsQuestionCommentEnabled") ) {
                final Object value = values.remove("IsQuestionCommentEnabled");
                if( (value == null) || (!value.equals(getIsQuestionCommentEnabled())) ) {
                    setIsQuestionCommentEnabled(((String) value));
                }
            }
            if( values.containsKey("NumberOfResponses") ) {
                final Object value = values.remove("NumberOfResponses");
                if( (value == null) || (!value.equals(getNumberOfResponses())) ) {
                    setNumberOfResponses(((Integer) value));
                }
            }
            if( values.containsKey("SLCPreferredAnswer") ) {
                final Object value = values.remove("SLCPreferredAnswer");
                if( (value == null) || (!value.equals(getSLCPreferredAnswer())) ) {
                    setSLCPreferredAnswer(((String) value));
                }
            }
            if( values.containsKey("SLCQuestionAttachmentOption") ) {
                final Object value = values.remove("SLCQuestionAttachmentOption");
                if( (value == null) || (!value.equals(getSLCQuestionAttachmentOption())) ) {
                    setSLCQuestionAttachmentOption(((String) value));
                }
            }
            if( values.containsKey("SuplrEvalOrdinalNumber") ) {
                final Object value = values.remove("SuplrEvalOrdinalNumber");
                if( (value == null) || (!value.equals(getSuplrEvalOrdinalNumber())) ) {
                    setSuplrEvalOrdinalNumber(((Integer) value));
                }
            }
            if( values.containsKey("SuplrEvalRspBrnchgQuestion") ) {
                final Object value = values.remove("SuplrEvalRspBrnchgQuestion");
                if( (value == null) || (!value.equals(getSuplrEvalRspBrnchgQuestion())) ) {
                    setSuplrEvalRspBrnchgQuestion(((String) value));
                }
            }
            if( values.containsKey("SuplrEvalRspBrnchgQuestionValn") ) {
                final Object value = values.remove("SuplrEvalRspBrnchgQuestionValn");
                if( (value == null) || (!value.equals(getSuplrEvalRspBrnchgQuestionValn())) ) {
                    setSuplrEvalRspBrnchgQuestionValn(((String) value));
                }
            }
            if( values.containsKey("SLCQuestionType") ) {
                final Object value = values.remove("SLCQuestionType");
                if( (value == null) || (!value.equals(getSLCQuestionType())) ) {
                    setSLCQuestionType(((String) value));
                }
            }
            if( values.containsKey("WeightingFactor") ) {
                final Object value = values.remove("WeightingFactor");
                if( (value == null) || (!value.equals(getWeightingFactor())) ) {
                    setWeightingFactor(((Short) value));
                }
            }
            if( values.containsKey("MinimalScore") ) {
                final Object value = values.remove("MinimalScore");
                if( (value == null) || (!value.equals(getMinimalScore())) ) {
                    setMinimalScore(((Short) value));
                }
            }
            if( values.containsKey("TargetScore") ) {
                final Object value = values.remove("TargetScore");
                if( (value == null) || (!value.equals(getTargetScore())) ) {
                    setTargetScore(((Short) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_SuplrEvalRspExplText") ) {
                final Object value = (values).remove("to_SuplrEvalRspExplText");
                if( value instanceof Iterable ) {
                    if( toSuplrEvalRspExplText == null ) {
                        toSuplrEvalRspExplText = Lists.newArrayList();
                    } else {
                        toSuplrEvalRspExplText = Lists.newArrayList(toSuplrEvalRspExplText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SuplrEvalRspExplText entity;
                        if( toSuplrEvalRspExplText.size() > i ) {
                            entity = toSuplrEvalRspExplText.get(i);
                        } else {
                            entity = new SuplrEvalRspExplText();
                            toSuplrEvalRspExplText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_SuplrEvalRspQuestionText") ) {
                final Object value = (values).remove("to_SuplrEvalRspQuestionText");
                if( value instanceof Iterable ) {
                    if( toSuplrEvalRspQuestionText == null ) {
                        toSuplrEvalRspQuestionText = Lists.newArrayList();
                    } else {
                        toSuplrEvalRspQuestionText = Lists.newArrayList(toSuplrEvalRspQuestionText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SuplrEvalRspQuestionText entity;
                        if( toSuplrEvalRspQuestionText.size() > i ) {
                            entity = toSuplrEvalRspQuestionText.get(i);
                        } else {
                            entity = new SuplrEvalRspQuestionText();
                            toSuplrEvalRspQuestionText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SuplrEvalRspQuestionField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SuplrEvalRspQuestionField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SuplrEvalRspQuestionField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SuplrEvalRspQuestionField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierEvaluationResponseService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toSuplrEvalRspExplText != null ) {
            (values).put("to_SuplrEvalRspExplText", toSuplrEvalRspExplText);
        }
        if( toSuplrEvalRspQuestionText != null ) {
            (values).put("to_SuplrEvalRspQuestionText", toSuplrEvalRspQuestionText);
        }
        return values;
    }

    /**
     * Fetches the <b>SuplrEvalRspExplText</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_SuplrEvalRspExplText</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SuplrEvalRspExplText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SuplrEvalRspExplText> fetchSuplrEvalRspExplText()
    {
        return fetchFieldAsList("to_SuplrEvalRspExplText", SuplrEvalRspExplText.class);
    }

    /**
     * Retrieval of associated <b>SuplrEvalRspExplText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SuplrEvalRspExplText</b>.
     * <p>
     * If the navigation property <b>to_SuplrEvalRspExplText</b> of a queried <b>SuplrEvalRspQuestion</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SuplrEvalRspExplText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SuplrEvalRspExplText> getSuplrEvalRspExplTextOrFetch()
    {
        if( toSuplrEvalRspExplText == null ) {
            toSuplrEvalRspExplText = fetchSuplrEvalRspExplText();
        }
        return toSuplrEvalRspExplText;
    }

    /**
     * Retrieval of associated <b>SuplrEvalRspExplText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SuplrEvalRspExplText</b>.
     * <p>
     * If the navigation property for an entity <b>SuplrEvalRspQuestion</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SuplrEvalRspExplText</b> is already loaded, the result
     *         will contain the <b>SuplrEvalRspExplText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SuplrEvalRspExplText>> getSuplrEvalRspExplTextIfPresent()
    {
        return Option.of(toSuplrEvalRspExplText);
    }

    /**
     * Overwrites the list of associated <b>SuplrEvalRspExplText</b> entities for the loaded navigation property
     * <b>to_SuplrEvalRspExplText</b>.
     * <p>
     * If the navigation property <b>to_SuplrEvalRspExplText</b> of a queried <b>SuplrEvalRspQuestion</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SuplrEvalRspExplText</b> entities.
     */
    public void setSuplrEvalRspExplText( @Nonnull final List<SuplrEvalRspExplText> value )
    {
        if( toSuplrEvalRspExplText == null ) {
            toSuplrEvalRspExplText = Lists.newArrayList();
        }
        toSuplrEvalRspExplText.clear();
        toSuplrEvalRspExplText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SuplrEvalRspExplText</b> entities. This corresponds to the OData
     * navigation property <b>to_SuplrEvalRspExplText</b>.
     * <p>
     * If the navigation property <b>to_SuplrEvalRspExplText</b> of a queried <b>SuplrEvalRspQuestion</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SuplrEvalRspExplText</b> entities.
     */
    public void addSuplrEvalRspExplText( SuplrEvalRspExplText... entity )
    {
        if( toSuplrEvalRspExplText == null ) {
            toSuplrEvalRspExplText = Lists.newArrayList();
        }
        toSuplrEvalRspExplText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SuplrEvalRspQuestionText</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_SuplrEvalRspQuestionText</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SuplrEvalRspQuestionText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SuplrEvalRspQuestionText> fetchSuplrEvalRspQuestionText()
    {
        return fetchFieldAsList("to_SuplrEvalRspQuestionText", SuplrEvalRspQuestionText.class);
    }

    /**
     * Retrieval of associated <b>SuplrEvalRspQuestionText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SuplrEvalRspQuestionText</b>.
     * <p>
     * If the navigation property <b>to_SuplrEvalRspQuestionText</b> of a queried <b>SuplrEvalRspQuestion</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SuplrEvalRspQuestionText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SuplrEvalRspQuestionText> getSuplrEvalRspQuestionTextOrFetch()
    {
        if( toSuplrEvalRspQuestionText == null ) {
            toSuplrEvalRspQuestionText = fetchSuplrEvalRspQuestionText();
        }
        return toSuplrEvalRspQuestionText;
    }

    /**
     * Retrieval of associated <b>SuplrEvalRspQuestionText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SuplrEvalRspQuestionText</b>.
     * <p>
     * If the navigation property for an entity <b>SuplrEvalRspQuestion</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SuplrEvalRspQuestionText</b> is already loaded, the
     *         result will contain the <b>SuplrEvalRspQuestionText</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SuplrEvalRspQuestionText>> getSuplrEvalRspQuestionTextIfPresent()
    {
        return Option.of(toSuplrEvalRspQuestionText);
    }

    /**
     * Overwrites the list of associated <b>SuplrEvalRspQuestionText</b> entities for the loaded navigation property
     * <b>to_SuplrEvalRspQuestionText</b>.
     * <p>
     * If the navigation property <b>to_SuplrEvalRspQuestionText</b> of a queried <b>SuplrEvalRspQuestion</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SuplrEvalRspQuestionText</b> entities.
     */
    public void setSuplrEvalRspQuestionText( @Nonnull final List<SuplrEvalRspQuestionText> value )
    {
        if( toSuplrEvalRspQuestionText == null ) {
            toSuplrEvalRspQuestionText = Lists.newArrayList();
        }
        toSuplrEvalRspQuestionText.clear();
        toSuplrEvalRspQuestionText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SuplrEvalRspQuestionText</b> entities. This corresponds to the OData
     * navigation property <b>to_SuplrEvalRspQuestionText</b>.
     * <p>
     * If the navigation property <b>to_SuplrEvalRspQuestionText</b> of a queried <b>SuplrEvalRspQuestion</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SuplrEvalRspQuestionText</b> entities.
     */
    public void addSuplrEvalRspQuestionText( SuplrEvalRspQuestionText... entity )
    {
        if( toSuplrEvalRspQuestionText == null ) {
            toSuplrEvalRspQuestionText = Lists.newArrayList();
        }
        toSuplrEvalRspQuestionText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of SuplrEvalRspQuestion instances.
     *
     */
    public final static class SuplrEvalRspQuestionBuilder
    {

        private List<SuplrEvalRspExplText> toSuplrEvalRspExplText = Lists.newArrayList();
        private List<SuplrEvalRspQuestionText> toSuplrEvalRspQuestionText = Lists.newArrayList();

        private SuplrEvalRspQuestion.SuplrEvalRspQuestionBuilder toSuplrEvalRspExplText(
            final List<SuplrEvalRspExplText> value )
        {
            toSuplrEvalRspExplText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SuplrEvalRspExplText</b> for <b>SuplrEvalRspQuestion</b> to multiple
         * <b>SuplrEvalRspExplText</b>.
         *
         * @param value
         *            The SuplrEvalRspExplTexts to build this SuplrEvalRspQuestion with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SuplrEvalRspQuestion.SuplrEvalRspQuestionBuilder suplrEvalRspExplText( SuplrEvalRspExplText... value )
        {
            return toSuplrEvalRspExplText(Lists.newArrayList(value));
        }

        private SuplrEvalRspQuestion.SuplrEvalRspQuestionBuilder toSuplrEvalRspQuestionText(
            final List<SuplrEvalRspQuestionText> value )
        {
            toSuplrEvalRspQuestionText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SuplrEvalRspQuestionText</b> for <b>SuplrEvalRspQuestion</b> to multiple
         * <b>SuplrEvalRspQuestionText</b>.
         *
         * @param value
         *            The SuplrEvalRspQuestionTexts to build this SuplrEvalRspQuestion with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SuplrEvalRspQuestion.SuplrEvalRspQuestionBuilder suplrEvalRspQuestionText(
            SuplrEvalRspQuestionText... value )
        {
            return toSuplrEvalRspQuestionText(Lists.newArrayList(value));
        }

    }

}
