/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.field.SuplrEvalRspQuestionTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.selectable.SuplrEvalRspQuestionTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Question Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SuplrEvalRspQuestionTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SuplrEvalRspQuestionText extends VdmEntity<SuplrEvalRspQuestionText>
{

    /**
     * Selector for all available fields of SuplrEvalRspQuestionText.
     *
     */
    public final static SuplrEvalRspQuestionTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalReqUUID</b>
     * </p>
     *
     * @return Evaluation Request UUID
     */
    @Key
    @SerializedName( "SuplrEvalReqUUID" )
    @JsonProperty( "SuplrEvalReqUUID" )
    @Nullable
    @ODataField( odataName = "SuplrEvalReqUUID" )
    private UUID suplrEvalReqUUID;
    /**
     * Use with available fluent helpers to apply the <b>SuplrEvalReqUUID</b> field to query operations.
     *
     */
    public final static SuplrEvalRspQuestionTextField<UUID> SUPLR_EVAL_REQ_UUID =
        new SuplrEvalRspQuestionTextField<UUID>("SuplrEvalReqUUID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static SuplrEvalRspQuestionTextField<String> LANGUAGE =
        new SuplrEvalRspQuestionTextField<String>("Language");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalRspQuestionText</b>
     * </p>
     *
     * @return Text Content
     */
    @SerializedName( "SuplrEvalRspQuestionText" )
    @JsonProperty( "SuplrEvalRspQuestionText" )
    @Nullable
    @ODataField( odataName = "SuplrEvalRspQuestionText" )
    private String suplrEvalRspQuestionText;
    /**
     * Use with available fluent helpers to apply the <b>SuplrEvalRspQuestionText</b> field to query operations.
     *
     */
    public final static SuplrEvalRspQuestionTextField<String> SUPLR_EVAL_RSP_QUESTION_TEXT =
        new SuplrEvalRspQuestionTextField<String>("SuplrEvalRspQuestionText");

    @Nonnull
    @Override
    public Class<SuplrEvalRspQuestionText> getType()
    {
        return SuplrEvalRspQuestionText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalReqUUID</b>
     * </p>
     *
     * @param suplrEvalReqUUID
     *            Evaluation Request UUID
     */
    public void setSuplrEvalReqUUID( @Nullable final UUID suplrEvalReqUUID )
    {
        rememberChangedField("SuplrEvalReqUUID", this.suplrEvalReqUUID);
        this.suplrEvalReqUUID = suplrEvalReqUUID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalRspQuestionText</b>
     * </p>
     *
     * @param suplrEvalRspQuestionText
     *            Text Content
     */
    public void setSuplrEvalRspQuestionText( @Nullable final String suplrEvalRspQuestionText )
    {
        rememberChangedField("SuplrEvalRspQuestionText", this.suplrEvalRspQuestionText);
        this.suplrEvalRspQuestionText = suplrEvalRspQuestionText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SuplrEvalRspQuestionText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SuplrEvalReqUUID", getSuplrEvalReqUUID());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SuplrEvalReqUUID", getSuplrEvalReqUUID());
        values.put("Language", getLanguage());
        values.put("SuplrEvalRspQuestionText", getSuplrEvalRspQuestionText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SuplrEvalReqUUID") ) {
                final Object value = values.remove("SuplrEvalReqUUID");
                if( (value == null) || (!value.equals(getSuplrEvalReqUUID())) ) {
                    setSuplrEvalReqUUID(((UUID) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("SuplrEvalRspQuestionText") ) {
                final Object value = values.remove("SuplrEvalRspQuestionText");
                if( (value == null) || (!value.equals(getSuplrEvalRspQuestionText())) ) {
                    setSuplrEvalRspQuestionText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SuplrEvalRspQuestionTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SuplrEvalRspQuestionTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SuplrEvalRspQuestionTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SuplrEvalRspQuestionTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierEvaluationResponseService.DEFAULT_SERVICE_PATH);
    }

}
