/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse;

import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.field.SuplrEvalRspRootQnaireField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.link.SuplrEvalRspRootQnaireLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.selectable.SuplrEvalRspRootQnaireSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Root Questionnaire
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SuplrEvalRspRootQnaireType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SuplrEvalRspRootQnaire extends VdmEntity<SuplrEvalRspRootQnaire>
{

    /**
     * Selector for all available fields of SuplrEvalRspRootQnaire.
     *
     */
    public final static SuplrEvalRspRootQnaireSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalRspQuestionnaireUUID</b>
     * </p>
     *
     * @return Evaluation Response Questionnaire UUID
     */
    @Key
    @SerializedName( "SuplrEvalRspQuestionnaireUUID" )
    @JsonProperty( "SuplrEvalRspQuestionnaireUUID" )
    @Nullable
    @ODataField( odataName = "SuplrEvalRspQuestionnaireUUID" )
    private UUID suplrEvalRspQuestionnaireUUID;
    /**
     * Use with available fluent helpers to apply the <b>SuplrEvalRspQuestionnaireUUID</b> field to query operations.
     *
     */
    public final static SuplrEvalRspRootQnaireField<UUID> SUPLR_EVAL_RSP_QUESTIONNAIRE_UUID =
        new SuplrEvalRspRootQnaireField<UUID>("SuplrEvalRspQuestionnaireUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalRspUUID</b>
     * </p>
     *
     * @return Evaluation Response UUID
     */
    @SerializedName( "SuplrEvalRspUUID" )
    @JsonProperty( "SuplrEvalRspUUID" )
    @Nullable
    @ODataField( odataName = "SuplrEvalRspUUID" )
    private UUID suplrEvalRspUUID;
    /**
     * Use with available fluent helpers to apply the <b>SuplrEvalRspUUID</b> field to query operations.
     *
     */
    public final static SuplrEvalRspRootQnaireField<UUID> SUPLR_EVAL_RSP_UUID =
        new SuplrEvalRspRootQnaireField<UUID>("SuplrEvalRspUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CalculatedScore</b>
     * </p>
     *
     * @return Calculated Score
     */
    @SerializedName( "CalculatedScore" )
    @JsonProperty( "CalculatedScore" )
    @Nullable
    @ODataField( odataName = "CalculatedScore" )
    private Double calculatedScore;
    /**
     * Use with available fluent helpers to apply the <b>CalculatedScore</b> field to query operations.
     *
     */
    public final static SuplrEvalRspRootQnaireField<Double> CALCULATED_SCORE =
        new SuplrEvalRspRootQnaireField<Double>("CalculatedScore");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsScoringRelevant</b>
     * </p>
     *
     * @return Scoring Indicator
     */
    @SerializedName( "IsScoringRelevant" )
    @JsonProperty( "IsScoringRelevant" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsScoringRelevant" )
    private Boolean isScoringRelevant;
    /**
     * Use with available fluent helpers to apply the <b>IsScoringRelevant</b> field to query operations.
     *
     */
    public final static SuplrEvalRspRootQnaireField<Boolean> IS_SCORING_RELEVANT =
        new SuplrEvalRspRootQnaireField<Boolean>("IsScoringRelevant");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MinimalScore</b>
     * </p>
     *
     * @return Minimum Score Accepted
     */
    @SerializedName( "MinimalScore" )
    @JsonProperty( "MinimalScore" )
    @Nullable
    @ODataField( odataName = "MinimalScore" )
    private Short minimalScore;
    /**
     * Use with available fluent helpers to apply the <b>MinimalScore</b> field to query operations.
     *
     */
    public final static SuplrEvalRspRootQnaireField<Short> MINIMAL_SCORE =
        new SuplrEvalRspRootQnaireField<Short>("MinimalScore");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>NumberOfResponses</b>
     * </p>
     *
     * @return Number of Responses
     */
    @SerializedName( "NumberOfResponses" )
    @JsonProperty( "NumberOfResponses" )
    @Nullable
    @ODataField( odataName = "NumberOfResponses" )
    private Integer numberOfResponses;
    /**
     * Use with available fluent helpers to apply the <b>NumberOfResponses</b> field to query operations.
     *
     */
    public final static SuplrEvalRspRootQnaireField<Integer> NUMBER_OF_RESPONSES =
        new SuplrEvalRspRootQnaireField<Integer>("NumberOfResponses");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalOrdinalNumber</b>
     * </p>
     *
     * @return Ordinal Number Value
     */
    @SerializedName( "SuplrEvalOrdinalNumber" )
    @JsonProperty( "SuplrEvalOrdinalNumber" )
    @Nullable
    @ODataField( odataName = "SuplrEvalOrdinalNumber" )
    private Integer suplrEvalOrdinalNumber;
    /**
     * Use with available fluent helpers to apply the <b>SuplrEvalOrdinalNumber</b> field to query operations.
     *
     */
    public final static SuplrEvalRspRootQnaireField<Integer> SUPLR_EVAL_ORDINAL_NUMBER =
        new SuplrEvalRspRootQnaireField<Integer>("SuplrEvalOrdinalNumber");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>TargetScore</b>
     * </p>
     *
     * @return Target Score
     */
    @SerializedName( "TargetScore" )
    @JsonProperty( "TargetScore" )
    @Nullable
    @ODataField( odataName = "TargetScore" )
    private Short targetScore;
    /**
     * Use with available fluent helpers to apply the <b>TargetScore</b> field to query operations.
     *
     */
    public final static SuplrEvalRspRootQnaireField<Short> TARGET_SCORE =
        new SuplrEvalRspRootQnaireField<Short>("TargetScore");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>WeightingFactor</b>
     * </p>
     *
     * @return Value of Weighting Factor
     */
    @SerializedName( "WeightingFactor" )
    @JsonProperty( "WeightingFactor" )
    @Nullable
    @ODataField( odataName = "WeightingFactor" )
    private Short weightingFactor;
    /**
     * Use with available fluent helpers to apply the <b>WeightingFactor</b> field to query operations.
     *
     */
    public final static SuplrEvalRspRootQnaireField<Short> WEIGHTING_FACTOR =
        new SuplrEvalRspRootQnaireField<Short>("WeightingFactor");
    /**
     * Navigation property <b>to_SuplrEvalRspStrucQnaire</b> for <b>SuplrEvalRspRootQnaire</b> to multiple
     * <b>SuplrEvalRspStrucQnaire</b>.
     *
     */
    @SerializedName( "to_SuplrEvalRspStrucQnaire" )
    @JsonProperty( "to_SuplrEvalRspStrucQnaire" )
    @ODataField( odataName = "to_SuplrEvalRspStrucQnaire" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SuplrEvalRspStrucQnaire> toSuplrEvalRspStrucQnaire;
    /**
     * Use with available fluent helpers to apply the <b>to_SuplrEvalRspStrucQnaire</b> navigation property to query
     * operations.
     *
     */
    public final static SuplrEvalRspRootQnaireLink<SuplrEvalRspStrucQnaire> TO_SUPLR_EVAL_RSP_STRUC_QNAIRE =
        new SuplrEvalRspRootQnaireLink<SuplrEvalRspStrucQnaire>("to_SuplrEvalRspStrucQnaire");

    @Nonnull
    @Override
    public Class<SuplrEvalRspRootQnaire> getType()
    {
        return SuplrEvalRspRootQnaire.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalRspQuestionnaireUUID</b>
     * </p>
     *
     * @param suplrEvalRspQuestionnaireUUID
     *            Evaluation Response Questionnaire UUID
     */
    public void setSuplrEvalRspQuestionnaireUUID( @Nullable final UUID suplrEvalRspQuestionnaireUUID )
    {
        rememberChangedField("SuplrEvalRspQuestionnaireUUID", this.suplrEvalRspQuestionnaireUUID);
        this.suplrEvalRspQuestionnaireUUID = suplrEvalRspQuestionnaireUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalRspUUID</b>
     * </p>
     *
     * @param suplrEvalRspUUID
     *            Evaluation Response UUID
     */
    public void setSuplrEvalRspUUID( @Nullable final UUID suplrEvalRspUUID )
    {
        rememberChangedField("SuplrEvalRspUUID", this.suplrEvalRspUUID);
        this.suplrEvalRspUUID = suplrEvalRspUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CalculatedScore</b>
     * </p>
     *
     * @param calculatedScore
     *            Calculated Score
     */
    public void setCalculatedScore( @Nullable final Double calculatedScore )
    {
        rememberChangedField("CalculatedScore", this.calculatedScore);
        this.calculatedScore = calculatedScore;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsScoringRelevant</b>
     * </p>
     *
     * @param isScoringRelevant
     *            Scoring Indicator
     */
    public void setIsScoringRelevant( @Nullable final Boolean isScoringRelevant )
    {
        rememberChangedField("IsScoringRelevant", this.isScoringRelevant);
        this.isScoringRelevant = isScoringRelevant;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MinimalScore</b>
     * </p>
     *
     * @param minimalScore
     *            Minimum Score Accepted
     */
    public void setMinimalScore( @Nullable final Short minimalScore )
    {
        rememberChangedField("MinimalScore", this.minimalScore);
        this.minimalScore = minimalScore;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>NumberOfResponses</b>
     * </p>
     *
     * @param numberOfResponses
     *            Number of Responses
     */
    public void setNumberOfResponses( @Nullable final Integer numberOfResponses )
    {
        rememberChangedField("NumberOfResponses", this.numberOfResponses);
        this.numberOfResponses = numberOfResponses;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalOrdinalNumber</b>
     * </p>
     *
     * @param suplrEvalOrdinalNumber
     *            Ordinal Number Value
     */
    public void setSuplrEvalOrdinalNumber( @Nullable final Integer suplrEvalOrdinalNumber )
    {
        rememberChangedField("SuplrEvalOrdinalNumber", this.suplrEvalOrdinalNumber);
        this.suplrEvalOrdinalNumber = suplrEvalOrdinalNumber;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>TargetScore</b>
     * </p>
     *
     * @param targetScore
     *            Target Score
     */
    public void setTargetScore( @Nullable final Short targetScore )
    {
        rememberChangedField("TargetScore", this.targetScore);
        this.targetScore = targetScore;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>WeightingFactor</b>
     * </p>
     *
     * @param weightingFactor
     *            Value of Weighting Factor
     */
    public void setWeightingFactor( @Nullable final Short weightingFactor )
    {
        rememberChangedField("WeightingFactor", this.weightingFactor);
        this.weightingFactor = weightingFactor;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SuplrEvalRspRootQnaire";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SuplrEvalRspQuestionnaireUUID", getSuplrEvalRspQuestionnaireUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SuplrEvalRspQuestionnaireUUID", getSuplrEvalRspQuestionnaireUUID());
        values.put("SuplrEvalRspUUID", getSuplrEvalRspUUID());
        values.put("CalculatedScore", getCalculatedScore());
        values.put("IsScoringRelevant", getIsScoringRelevant());
        values.put("MinimalScore", getMinimalScore());
        values.put("NumberOfResponses", getNumberOfResponses());
        values.put("SuplrEvalOrdinalNumber", getSuplrEvalOrdinalNumber());
        values.put("TargetScore", getTargetScore());
        values.put("WeightingFactor", getWeightingFactor());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SuplrEvalRspQuestionnaireUUID") ) {
                final Object value = values.remove("SuplrEvalRspQuestionnaireUUID");
                if( (value == null) || (!value.equals(getSuplrEvalRspQuestionnaireUUID())) ) {
                    setSuplrEvalRspQuestionnaireUUID(((UUID) value));
                }
            }
            if( values.containsKey("SuplrEvalRspUUID") ) {
                final Object value = values.remove("SuplrEvalRspUUID");
                if( (value == null) || (!value.equals(getSuplrEvalRspUUID())) ) {
                    setSuplrEvalRspUUID(((UUID) value));
                }
            }
            if( values.containsKey("CalculatedScore") ) {
                final Object value = values.remove("CalculatedScore");
                if( (value == null) || (!value.equals(getCalculatedScore())) ) {
                    setCalculatedScore(((Double) value));
                }
            }
            if( values.containsKey("IsScoringRelevant") ) {
                final Object value = values.remove("IsScoringRelevant");
                if( (value == null) || (!value.equals(getIsScoringRelevant())) ) {
                    setIsScoringRelevant(((Boolean) value));
                }
            }
            if( values.containsKey("MinimalScore") ) {
                final Object value = values.remove("MinimalScore");
                if( (value == null) || (!value.equals(getMinimalScore())) ) {
                    setMinimalScore(((Short) value));
                }
            }
            if( values.containsKey("NumberOfResponses") ) {
                final Object value = values.remove("NumberOfResponses");
                if( (value == null) || (!value.equals(getNumberOfResponses())) ) {
                    setNumberOfResponses(((Integer) value));
                }
            }
            if( values.containsKey("SuplrEvalOrdinalNumber") ) {
                final Object value = values.remove("SuplrEvalOrdinalNumber");
                if( (value == null) || (!value.equals(getSuplrEvalOrdinalNumber())) ) {
                    setSuplrEvalOrdinalNumber(((Integer) value));
                }
            }
            if( values.containsKey("TargetScore") ) {
                final Object value = values.remove("TargetScore");
                if( (value == null) || (!value.equals(getTargetScore())) ) {
                    setTargetScore(((Short) value));
                }
            }
            if( values.containsKey("WeightingFactor") ) {
                final Object value = values.remove("WeightingFactor");
                if( (value == null) || (!value.equals(getWeightingFactor())) ) {
                    setWeightingFactor(((Short) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_SuplrEvalRspStrucQnaire") ) {
                final Object value = (values).remove("to_SuplrEvalRspStrucQnaire");
                if( value instanceof Iterable ) {
                    if( toSuplrEvalRspStrucQnaire == null ) {
                        toSuplrEvalRspStrucQnaire = Lists.newArrayList();
                    } else {
                        toSuplrEvalRspStrucQnaire = Lists.newArrayList(toSuplrEvalRspStrucQnaire);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SuplrEvalRspStrucQnaire entity;
                        if( toSuplrEvalRspStrucQnaire.size() > i ) {
                            entity = toSuplrEvalRspStrucQnaire.get(i);
                        } else {
                            entity = new SuplrEvalRspStrucQnaire();
                            toSuplrEvalRspStrucQnaire.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SuplrEvalRspRootQnaireField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SuplrEvalRspRootQnaireField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SuplrEvalRspRootQnaireField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SuplrEvalRspRootQnaireField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierEvaluationResponseService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toSuplrEvalRspStrucQnaire != null ) {
            (values).put("to_SuplrEvalRspStrucQnaire", toSuplrEvalRspStrucQnaire);
        }
        return values;
    }

    /**
     * Fetches the <b>SuplrEvalRspStrucQnaire</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_SuplrEvalRspStrucQnaire</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SuplrEvalRspStrucQnaire</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SuplrEvalRspStrucQnaire> fetchSuplrEvalRspStrucQnaire()
    {
        return fetchFieldAsList("to_SuplrEvalRspStrucQnaire", SuplrEvalRspStrucQnaire.class);
    }

    /**
     * Retrieval of associated <b>SuplrEvalRspStrucQnaire</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SuplrEvalRspStrucQnaire</b>.
     * <p>
     * If the navigation property <b>to_SuplrEvalRspStrucQnaire</b> of a queried <b>SuplrEvalRspRootQnaire</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SuplrEvalRspStrucQnaire</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SuplrEvalRspStrucQnaire> getSuplrEvalRspStrucQnaireOrFetch()
    {
        if( toSuplrEvalRspStrucQnaire == null ) {
            toSuplrEvalRspStrucQnaire = fetchSuplrEvalRspStrucQnaire();
        }
        return toSuplrEvalRspStrucQnaire;
    }

    /**
     * Retrieval of associated <b>SuplrEvalRspStrucQnaire</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SuplrEvalRspStrucQnaire</b>.
     * <p>
     * If the navigation property for an entity <b>SuplrEvalRspRootQnaire</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SuplrEvalRspStrucQnaire</b> is already loaded, the
     *         result will contain the <b>SuplrEvalRspStrucQnaire</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SuplrEvalRspStrucQnaire>> getSuplrEvalRspStrucQnaireIfPresent()
    {
        return Option.of(toSuplrEvalRspStrucQnaire);
    }

    /**
     * Overwrites the list of associated <b>SuplrEvalRspStrucQnaire</b> entities for the loaded navigation property
     * <b>to_SuplrEvalRspStrucQnaire</b>.
     * <p>
     * If the navigation property <b>to_SuplrEvalRspStrucQnaire</b> of a queried <b>SuplrEvalRspRootQnaire</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SuplrEvalRspStrucQnaire</b> entities.
     */
    public void setSuplrEvalRspStrucQnaire( @Nonnull final List<SuplrEvalRspStrucQnaire> value )
    {
        if( toSuplrEvalRspStrucQnaire == null ) {
            toSuplrEvalRspStrucQnaire = Lists.newArrayList();
        }
        toSuplrEvalRspStrucQnaire.clear();
        toSuplrEvalRspStrucQnaire.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SuplrEvalRspStrucQnaire</b> entities. This corresponds to the OData
     * navigation property <b>to_SuplrEvalRspStrucQnaire</b>.
     * <p>
     * If the navigation property <b>to_SuplrEvalRspStrucQnaire</b> of a queried <b>SuplrEvalRspRootQnaire</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SuplrEvalRspStrucQnaire</b> entities.
     */
    public void addSuplrEvalRspStrucQnaire( SuplrEvalRspStrucQnaire... entity )
    {
        if( toSuplrEvalRspStrucQnaire == null ) {
            toSuplrEvalRspStrucQnaire = Lists.newArrayList();
        }
        toSuplrEvalRspStrucQnaire.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of SuplrEvalRspRootQnaire instances.
     *
     */
    public final static class SuplrEvalRspRootQnaireBuilder
    {

        private List<SuplrEvalRspStrucQnaire> toSuplrEvalRspStrucQnaire = Lists.newArrayList();

        private SuplrEvalRspRootQnaire.SuplrEvalRspRootQnaireBuilder toSuplrEvalRspStrucQnaire(
            final List<SuplrEvalRspStrucQnaire> value )
        {
            toSuplrEvalRspStrucQnaire.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SuplrEvalRspStrucQnaire</b> for <b>SuplrEvalRspRootQnaire</b> to multiple
         * <b>SuplrEvalRspStrucQnaire</b>.
         *
         * @param value
         *            The SuplrEvalRspStrucQnaires to build this SuplrEvalRspRootQnaire with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SuplrEvalRspRootQnaire.SuplrEvalRspRootQnaireBuilder suplrEvalRspStrucQnaire(
            SuplrEvalRspStrucQnaire... value )
        {
            return toSuplrEvalRspStrucQnaire(Lists.newArrayList(value));
        }

    }

}
