/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse;

import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.field.SuplrEvalRspSectionField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.link.SuplrEvalRspSectionLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.selectable.SuplrEvalRspSectionSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Section
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SuplrEvalRspSectionType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SuplrEvalRspSection extends VdmEntity<SuplrEvalRspSection>
{

    /**
     * Selector for all available fields of SuplrEvalRspSection.
     *
     */
    public final static SuplrEvalRspSectionSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalRspSectionUUID</b>
     * </p>
     *
     * @return Evaluation Response Section UUID
     */
    @Key
    @SerializedName( "SuplrEvalRspSectionUUID" )
    @JsonProperty( "SuplrEvalRspSectionUUID" )
    @Nullable
    @ODataField( odataName = "SuplrEvalRspSectionUUID" )
    private UUID suplrEvalRspSectionUUID;
    /**
     * Use with available fluent helpers to apply the <b>SuplrEvalRspSectionUUID</b> field to query operations.
     *
     */
    public final static SuplrEvalRspSectionField<UUID> SUPLR_EVAL_RSP_SECTION_UUID =
        new SuplrEvalRspSectionField<UUID>("SuplrEvalRspSectionUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalRspUUID</b>
     * </p>
     *
     * @return Evaluation Response UUID
     */
    @SerializedName( "SuplrEvalRspUUID" )
    @JsonProperty( "SuplrEvalRspUUID" )
    @Nullable
    @ODataField( odataName = "SuplrEvalRspUUID" )
    private UUID suplrEvalRspUUID;
    /**
     * Use with available fluent helpers to apply the <b>SuplrEvalRspUUID</b> field to query operations.
     *
     */
    public final static SuplrEvalRspSectionField<UUID> SUPLR_EVAL_RSP_UUID =
        new SuplrEvalRspSectionField<UUID>("SuplrEvalRspUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalRspQuestionnaireUUID</b>
     * </p>
     *
     * @return Evaluation Response Questionnaire UUID
     */
    @SerializedName( "SuplrEvalRspQuestionnaireUUID" )
    @JsonProperty( "SuplrEvalRspQuestionnaireUUID" )
    @Nullable
    @ODataField( odataName = "SuplrEvalRspQuestionnaireUUID" )
    private UUID suplrEvalRspQuestionnaireUUID;
    /**
     * Use with available fluent helpers to apply the <b>SuplrEvalRspQuestionnaireUUID</b> field to query operations.
     *
     */
    public final static SuplrEvalRspSectionField<UUID> SUPLR_EVAL_RSP_QUESTIONNAIRE_UUID =
        new SuplrEvalRspSectionField<UUID>("SuplrEvalRspQuestionnaireUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalReqSectionUUID</b>
     * </p>
     *
     * @return NodeID
     */
    @SerializedName( "SuplrEvalReqSectionUUID" )
    @JsonProperty( "SuplrEvalReqSectionUUID" )
    @Nullable
    @ODataField( odataName = "SuplrEvalReqSectionUUID" )
    private UUID suplrEvalReqSectionUUID;
    /**
     * Use with available fluent helpers to apply the <b>SuplrEvalReqSectionUUID</b> field to query operations.
     *
     */
    public final static SuplrEvalRspSectionField<UUID> SUPLR_EVAL_REQ_SECTION_UUID =
        new SuplrEvalRspSectionField<UUID>("SuplrEvalReqSectionUUID");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SupplierEvalResponseSection</b>
     * </p>
     *
     * @return SLC Object ID
     */
    @SerializedName( "SupplierEvalResponseSection" )
    @JsonProperty( "SupplierEvalResponseSection" )
    @Nullable
    @ODataField( odataName = "SupplierEvalResponseSection" )
    private String supplierEvalResponseSection;
    /**
     * Use with available fluent helpers to apply the <b>SupplierEvalResponseSection</b> field to query operations.
     *
     */
    public final static SuplrEvalRspSectionField<String> SUPPLIER_EVAL_RESPONSE_SECTION =
        new SuplrEvalRspSectionField<String>("SupplierEvalResponseSection");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SupplierEvalResponseSctnAltv</b>
     * </p>
     *
     * @return Alternative ID of a Section
     */
    @SerializedName( "SupplierEvalResponseSctnAltv" )
    @JsonProperty( "SupplierEvalResponseSctnAltv" )
    @Nullable
    @ODataField( odataName = "SupplierEvalResponseSctnAltv" )
    private Integer supplierEvalResponseSctnAltv;
    /**
     * Use with available fluent helpers to apply the <b>SupplierEvalResponseSctnAltv</b> field to query operations.
     *
     */
    public final static SuplrEvalRspSectionField<Integer> SUPPLIER_EVAL_RESPONSE_SCTN_ALTV =
        new SuplrEvalRspSectionField<Integer>("SupplierEvalResponseSctnAltv");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>QuestionnaireSectionName</b>
     * </p>
     *
     * @return Medium-Size Name
     */
    @SerializedName( "QuestionnaireSectionName" )
    @JsonProperty( "QuestionnaireSectionName" )
    @Nullable
    @ODataField( odataName = "QuestionnaireSectionName" )
    private String questionnaireSectionName;
    /**
     * Use with available fluent helpers to apply the <b>QuestionnaireSectionName</b> field to query operations.
     *
     */
    public final static SuplrEvalRspSectionField<String> QUESTIONNAIRE_SECTION_NAME =
        new SuplrEvalRspSectionField<String>("QuestionnaireSectionName");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>WeightingFactor</b>
     * </p>
     *
     * @return Value of Weighting Factor
     */
    @SerializedName( "WeightingFactor" )
    @JsonProperty( "WeightingFactor" )
    @Nullable
    @ODataField( odataName = "WeightingFactor" )
    private Short weightingFactor;
    /**
     * Use with available fluent helpers to apply the <b>WeightingFactor</b> field to query operations.
     *
     */
    public final static SuplrEvalRspSectionField<Short> WEIGHTING_FACTOR =
        new SuplrEvalRspSectionField<Short>("WeightingFactor");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MinimalScore</b>
     * </p>
     *
     * @return Minimum Score Accepted
     */
    @SerializedName( "MinimalScore" )
    @JsonProperty( "MinimalScore" )
    @Nullable
    @ODataField( odataName = "MinimalScore" )
    private Short minimalScore;
    /**
     * Use with available fluent helpers to apply the <b>MinimalScore</b> field to query operations.
     *
     */
    public final static SuplrEvalRspSectionField<Short> MINIMAL_SCORE =
        new SuplrEvalRspSectionField<Short>("MinimalScore");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>TargetScore</b>
     * </p>
     *
     * @return Target Score
     */
    @SerializedName( "TargetScore" )
    @JsonProperty( "TargetScore" )
    @Nullable
    @ODataField( odataName = "TargetScore" )
    private Short targetScore;
    /**
     * Use with available fluent helpers to apply the <b>TargetScore</b> field to query operations.
     *
     */
    public final static SuplrEvalRspSectionField<Short> TARGET_SCORE =
        new SuplrEvalRspSectionField<Short>("TargetScore");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CalculatedScore</b>
     * </p>
     *
     * @return Calculated Score
     */
    @SerializedName( "CalculatedScore" )
    @JsonProperty( "CalculatedScore" )
    @Nullable
    @ODataField( odataName = "CalculatedScore" )
    private Double calculatedScore;
    /**
     * Use with available fluent helpers to apply the <b>CalculatedScore</b> field to query operations.
     *
     */
    public final static SuplrEvalRspSectionField<Double> CALCULATED_SCORE =
        new SuplrEvalRspSectionField<Double>("CalculatedScore");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>NumberOfResponses</b>
     * </p>
     *
     * @return Number of Responses
     */
    @SerializedName( "NumberOfResponses" )
    @JsonProperty( "NumberOfResponses" )
    @Nullable
    @ODataField( odataName = "NumberOfResponses" )
    private Integer numberOfResponses;
    /**
     * Use with available fluent helpers to apply the <b>NumberOfResponses</b> field to query operations.
     *
     */
    public final static SuplrEvalRspSectionField<Integer> NUMBER_OF_RESPONSES =
        new SuplrEvalRspSectionField<Integer>("NumberOfResponses");
    /**
     * Navigation property <b>to_SuplrEvalRspQuestion</b> for <b>SuplrEvalRspSection</b> to multiple
     * <b>SuplrEvalRspQuestion</b>.
     *
     */
    @SerializedName( "to_SuplrEvalRspQuestion" )
    @JsonProperty( "to_SuplrEvalRspQuestion" )
    @ODataField( odataName = "to_SuplrEvalRspQuestion" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SuplrEvalRspQuestion> toSuplrEvalRspQuestion;
    /**
     * Navigation property <b>to_SuplrEvalRspSectionText</b> for <b>SuplrEvalRspSection</b> to multiple
     * <b>SuplrEvalRspSectionText</b>.
     *
     */
    @SerializedName( "to_SuplrEvalRspSectionText" )
    @JsonProperty( "to_SuplrEvalRspSectionText" )
    @ODataField( odataName = "to_SuplrEvalRspSectionText" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SuplrEvalRspSectionText> toSuplrEvalRspSectionText;
    /**
     * Use with available fluent helpers to apply the <b>to_SuplrEvalRspQuestion</b> navigation property to query
     * operations.
     *
     */
    public final static SuplrEvalRspSectionLink<SuplrEvalRspQuestion> TO_SUPLR_EVAL_RSP_QUESTION =
        new SuplrEvalRspSectionLink<SuplrEvalRspQuestion>("to_SuplrEvalRspQuestion");
    /**
     * Use with available fluent helpers to apply the <b>to_SuplrEvalRspSectionText</b> navigation property to query
     * operations.
     *
     */
    public final static SuplrEvalRspSectionLink<SuplrEvalRspSectionText> TO_SUPLR_EVAL_RSP_SECTION_TEXT =
        new SuplrEvalRspSectionLink<SuplrEvalRspSectionText>("to_SuplrEvalRspSectionText");

    @Nonnull
    @Override
    public Class<SuplrEvalRspSection> getType()
    {
        return SuplrEvalRspSection.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalRspSectionUUID</b>
     * </p>
     *
     * @param suplrEvalRspSectionUUID
     *            Evaluation Response Section UUID
     */
    public void setSuplrEvalRspSectionUUID( @Nullable final UUID suplrEvalRspSectionUUID )
    {
        rememberChangedField("SuplrEvalRspSectionUUID", this.suplrEvalRspSectionUUID);
        this.suplrEvalRspSectionUUID = suplrEvalRspSectionUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalRspUUID</b>
     * </p>
     *
     * @param suplrEvalRspUUID
     *            Evaluation Response UUID
     */
    public void setSuplrEvalRspUUID( @Nullable final UUID suplrEvalRspUUID )
    {
        rememberChangedField("SuplrEvalRspUUID", this.suplrEvalRspUUID);
        this.suplrEvalRspUUID = suplrEvalRspUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalRspQuestionnaireUUID</b>
     * </p>
     *
     * @param suplrEvalRspQuestionnaireUUID
     *            Evaluation Response Questionnaire UUID
     */
    public void setSuplrEvalRspQuestionnaireUUID( @Nullable final UUID suplrEvalRspQuestionnaireUUID )
    {
        rememberChangedField("SuplrEvalRspQuestionnaireUUID", this.suplrEvalRspQuestionnaireUUID);
        this.suplrEvalRspQuestionnaireUUID = suplrEvalRspQuestionnaireUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalReqSectionUUID</b>
     * </p>
     *
     * @param suplrEvalReqSectionUUID
     *            NodeID
     */
    public void setSuplrEvalReqSectionUUID( @Nullable final UUID suplrEvalReqSectionUUID )
    {
        rememberChangedField("SuplrEvalReqSectionUUID", this.suplrEvalReqSectionUUID);
        this.suplrEvalReqSectionUUID = suplrEvalReqSectionUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SupplierEvalResponseSection</b>
     * </p>
     *
     * @param supplierEvalResponseSection
     *            SLC Object ID
     */
    public void setSupplierEvalResponseSection( @Nullable final String supplierEvalResponseSection )
    {
        rememberChangedField("SupplierEvalResponseSection", this.supplierEvalResponseSection);
        this.supplierEvalResponseSection = supplierEvalResponseSection;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SupplierEvalResponseSctnAltv</b>
     * </p>
     *
     * @param supplierEvalResponseSctnAltv
     *            Alternative ID of a Section
     */
    public void setSupplierEvalResponseSctnAltv( @Nullable final Integer supplierEvalResponseSctnAltv )
    {
        rememberChangedField("SupplierEvalResponseSctnAltv", this.supplierEvalResponseSctnAltv);
        this.supplierEvalResponseSctnAltv = supplierEvalResponseSctnAltv;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>QuestionnaireSectionName</b>
     * </p>
     *
     * @param questionnaireSectionName
     *            Medium-Size Name
     */
    public void setQuestionnaireSectionName( @Nullable final String questionnaireSectionName )
    {
        rememberChangedField("QuestionnaireSectionName", this.questionnaireSectionName);
        this.questionnaireSectionName = questionnaireSectionName;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>WeightingFactor</b>
     * </p>
     *
     * @param weightingFactor
     *            Value of Weighting Factor
     */
    public void setWeightingFactor( @Nullable final Short weightingFactor )
    {
        rememberChangedField("WeightingFactor", this.weightingFactor);
        this.weightingFactor = weightingFactor;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MinimalScore</b>
     * </p>
     *
     * @param minimalScore
     *            Minimum Score Accepted
     */
    public void setMinimalScore( @Nullable final Short minimalScore )
    {
        rememberChangedField("MinimalScore", this.minimalScore);
        this.minimalScore = minimalScore;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>TargetScore</b>
     * </p>
     *
     * @param targetScore
     *            Target Score
     */
    public void setTargetScore( @Nullable final Short targetScore )
    {
        rememberChangedField("TargetScore", this.targetScore);
        this.targetScore = targetScore;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CalculatedScore</b>
     * </p>
     *
     * @param calculatedScore
     *            Calculated Score
     */
    public void setCalculatedScore( @Nullable final Double calculatedScore )
    {
        rememberChangedField("CalculatedScore", this.calculatedScore);
        this.calculatedScore = calculatedScore;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>NumberOfResponses</b>
     * </p>
     *
     * @param numberOfResponses
     *            Number of Responses
     */
    public void setNumberOfResponses( @Nullable final Integer numberOfResponses )
    {
        rememberChangedField("NumberOfResponses", this.numberOfResponses);
        this.numberOfResponses = numberOfResponses;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SuplrEvalRspSection";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SuplrEvalRspSectionUUID", getSuplrEvalRspSectionUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SuplrEvalRspSectionUUID", getSuplrEvalRspSectionUUID());
        values.put("SuplrEvalRspUUID", getSuplrEvalRspUUID());
        values.put("SuplrEvalRspQuestionnaireUUID", getSuplrEvalRspQuestionnaireUUID());
        values.put("SuplrEvalReqSectionUUID", getSuplrEvalReqSectionUUID());
        values.put("SupplierEvalResponseSection", getSupplierEvalResponseSection());
        values.put("SupplierEvalResponseSctnAltv", getSupplierEvalResponseSctnAltv());
        values.put("QuestionnaireSectionName", getQuestionnaireSectionName());
        values.put("WeightingFactor", getWeightingFactor());
        values.put("MinimalScore", getMinimalScore());
        values.put("TargetScore", getTargetScore());
        values.put("CalculatedScore", getCalculatedScore());
        values.put("NumberOfResponses", getNumberOfResponses());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SuplrEvalRspSectionUUID") ) {
                final Object value = values.remove("SuplrEvalRspSectionUUID");
                if( (value == null) || (!value.equals(getSuplrEvalRspSectionUUID())) ) {
                    setSuplrEvalRspSectionUUID(((UUID) value));
                }
            }
            if( values.containsKey("SuplrEvalRspUUID") ) {
                final Object value = values.remove("SuplrEvalRspUUID");
                if( (value == null) || (!value.equals(getSuplrEvalRspUUID())) ) {
                    setSuplrEvalRspUUID(((UUID) value));
                }
            }
            if( values.containsKey("SuplrEvalRspQuestionnaireUUID") ) {
                final Object value = values.remove("SuplrEvalRspQuestionnaireUUID");
                if( (value == null) || (!value.equals(getSuplrEvalRspQuestionnaireUUID())) ) {
                    setSuplrEvalRspQuestionnaireUUID(((UUID) value));
                }
            }
            if( values.containsKey("SuplrEvalReqSectionUUID") ) {
                final Object value = values.remove("SuplrEvalReqSectionUUID");
                if( (value == null) || (!value.equals(getSuplrEvalReqSectionUUID())) ) {
                    setSuplrEvalReqSectionUUID(((UUID) value));
                }
            }
            if( values.containsKey("SupplierEvalResponseSection") ) {
                final Object value = values.remove("SupplierEvalResponseSection");
                if( (value == null) || (!value.equals(getSupplierEvalResponseSection())) ) {
                    setSupplierEvalResponseSection(((String) value));
                }
            }
            if( values.containsKey("SupplierEvalResponseSctnAltv") ) {
                final Object value = values.remove("SupplierEvalResponseSctnAltv");
                if( (value == null) || (!value.equals(getSupplierEvalResponseSctnAltv())) ) {
                    setSupplierEvalResponseSctnAltv(((Integer) value));
                }
            }
            if( values.containsKey("QuestionnaireSectionName") ) {
                final Object value = values.remove("QuestionnaireSectionName");
                if( (value == null) || (!value.equals(getQuestionnaireSectionName())) ) {
                    setQuestionnaireSectionName(((String) value));
                }
            }
            if( values.containsKey("WeightingFactor") ) {
                final Object value = values.remove("WeightingFactor");
                if( (value == null) || (!value.equals(getWeightingFactor())) ) {
                    setWeightingFactor(((Short) value));
                }
            }
            if( values.containsKey("MinimalScore") ) {
                final Object value = values.remove("MinimalScore");
                if( (value == null) || (!value.equals(getMinimalScore())) ) {
                    setMinimalScore(((Short) value));
                }
            }
            if( values.containsKey("TargetScore") ) {
                final Object value = values.remove("TargetScore");
                if( (value == null) || (!value.equals(getTargetScore())) ) {
                    setTargetScore(((Short) value));
                }
            }
            if( values.containsKey("CalculatedScore") ) {
                final Object value = values.remove("CalculatedScore");
                if( (value == null) || (!value.equals(getCalculatedScore())) ) {
                    setCalculatedScore(((Double) value));
                }
            }
            if( values.containsKey("NumberOfResponses") ) {
                final Object value = values.remove("NumberOfResponses");
                if( (value == null) || (!value.equals(getNumberOfResponses())) ) {
                    setNumberOfResponses(((Integer) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_SuplrEvalRspQuestion") ) {
                final Object value = (values).remove("to_SuplrEvalRspQuestion");
                if( value instanceof Iterable ) {
                    if( toSuplrEvalRspQuestion == null ) {
                        toSuplrEvalRspQuestion = Lists.newArrayList();
                    } else {
                        toSuplrEvalRspQuestion = Lists.newArrayList(toSuplrEvalRspQuestion);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SuplrEvalRspQuestion entity;
                        if( toSuplrEvalRspQuestion.size() > i ) {
                            entity = toSuplrEvalRspQuestion.get(i);
                        } else {
                            entity = new SuplrEvalRspQuestion();
                            toSuplrEvalRspQuestion.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_SuplrEvalRspSectionText") ) {
                final Object value = (values).remove("to_SuplrEvalRspSectionText");
                if( value instanceof Iterable ) {
                    if( toSuplrEvalRspSectionText == null ) {
                        toSuplrEvalRspSectionText = Lists.newArrayList();
                    } else {
                        toSuplrEvalRspSectionText = Lists.newArrayList(toSuplrEvalRspSectionText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SuplrEvalRspSectionText entity;
                        if( toSuplrEvalRspSectionText.size() > i ) {
                            entity = toSuplrEvalRspSectionText.get(i);
                        } else {
                            entity = new SuplrEvalRspSectionText();
                            toSuplrEvalRspSectionText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SuplrEvalRspSectionField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SuplrEvalRspSectionField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SuplrEvalRspSectionField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SuplrEvalRspSectionField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierEvaluationResponseService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toSuplrEvalRspQuestion != null ) {
            (values).put("to_SuplrEvalRspQuestion", toSuplrEvalRspQuestion);
        }
        if( toSuplrEvalRspSectionText != null ) {
            (values).put("to_SuplrEvalRspSectionText", toSuplrEvalRspSectionText);
        }
        return values;
    }

    /**
     * Fetches the <b>SuplrEvalRspQuestion</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_SuplrEvalRspQuestion</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SuplrEvalRspQuestion</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SuplrEvalRspQuestion> fetchSuplrEvalRspQuestion()
    {
        return fetchFieldAsList("to_SuplrEvalRspQuestion", SuplrEvalRspQuestion.class);
    }

    /**
     * Retrieval of associated <b>SuplrEvalRspQuestion</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SuplrEvalRspQuestion</b>.
     * <p>
     * If the navigation property <b>to_SuplrEvalRspQuestion</b> of a queried <b>SuplrEvalRspSection</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SuplrEvalRspQuestion</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SuplrEvalRspQuestion> getSuplrEvalRspQuestionOrFetch()
    {
        if( toSuplrEvalRspQuestion == null ) {
            toSuplrEvalRspQuestion = fetchSuplrEvalRspQuestion();
        }
        return toSuplrEvalRspQuestion;
    }

    /**
     * Retrieval of associated <b>SuplrEvalRspQuestion</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SuplrEvalRspQuestion</b>.
     * <p>
     * If the navigation property for an entity <b>SuplrEvalRspSection</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SuplrEvalRspQuestion</b> is already loaded, the result
     *         will contain the <b>SuplrEvalRspQuestion</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SuplrEvalRspQuestion>> getSuplrEvalRspQuestionIfPresent()
    {
        return Option.of(toSuplrEvalRspQuestion);
    }

    /**
     * Overwrites the list of associated <b>SuplrEvalRspQuestion</b> entities for the loaded navigation property
     * <b>to_SuplrEvalRspQuestion</b>.
     * <p>
     * If the navigation property <b>to_SuplrEvalRspQuestion</b> of a queried <b>SuplrEvalRspSection</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SuplrEvalRspQuestion</b> entities.
     */
    public void setSuplrEvalRspQuestion( @Nonnull final List<SuplrEvalRspQuestion> value )
    {
        if( toSuplrEvalRspQuestion == null ) {
            toSuplrEvalRspQuestion = Lists.newArrayList();
        }
        toSuplrEvalRspQuestion.clear();
        toSuplrEvalRspQuestion.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SuplrEvalRspQuestion</b> entities. This corresponds to the OData
     * navigation property <b>to_SuplrEvalRspQuestion</b>.
     * <p>
     * If the navigation property <b>to_SuplrEvalRspQuestion</b> of a queried <b>SuplrEvalRspSection</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SuplrEvalRspQuestion</b> entities.
     */
    public void addSuplrEvalRspQuestion( SuplrEvalRspQuestion... entity )
    {
        if( toSuplrEvalRspQuestion == null ) {
            toSuplrEvalRspQuestion = Lists.newArrayList();
        }
        toSuplrEvalRspQuestion.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SuplrEvalRspSectionText</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_SuplrEvalRspSectionText</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SuplrEvalRspSectionText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SuplrEvalRspSectionText> fetchSuplrEvalRspSectionText()
    {
        return fetchFieldAsList("to_SuplrEvalRspSectionText", SuplrEvalRspSectionText.class);
    }

    /**
     * Retrieval of associated <b>SuplrEvalRspSectionText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SuplrEvalRspSectionText</b>.
     * <p>
     * If the navigation property <b>to_SuplrEvalRspSectionText</b> of a queried <b>SuplrEvalRspSection</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SuplrEvalRspSectionText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SuplrEvalRspSectionText> getSuplrEvalRspSectionTextOrFetch()
    {
        if( toSuplrEvalRspSectionText == null ) {
            toSuplrEvalRspSectionText = fetchSuplrEvalRspSectionText();
        }
        return toSuplrEvalRspSectionText;
    }

    /**
     * Retrieval of associated <b>SuplrEvalRspSectionText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SuplrEvalRspSectionText</b>.
     * <p>
     * If the navigation property for an entity <b>SuplrEvalRspSection</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SuplrEvalRspSectionText</b> is already loaded, the
     *         result will contain the <b>SuplrEvalRspSectionText</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SuplrEvalRspSectionText>> getSuplrEvalRspSectionTextIfPresent()
    {
        return Option.of(toSuplrEvalRspSectionText);
    }

    /**
     * Overwrites the list of associated <b>SuplrEvalRspSectionText</b> entities for the loaded navigation property
     * <b>to_SuplrEvalRspSectionText</b>.
     * <p>
     * If the navigation property <b>to_SuplrEvalRspSectionText</b> of a queried <b>SuplrEvalRspSection</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SuplrEvalRspSectionText</b> entities.
     */
    public void setSuplrEvalRspSectionText( @Nonnull final List<SuplrEvalRspSectionText> value )
    {
        if( toSuplrEvalRspSectionText == null ) {
            toSuplrEvalRspSectionText = Lists.newArrayList();
        }
        toSuplrEvalRspSectionText.clear();
        toSuplrEvalRspSectionText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SuplrEvalRspSectionText</b> entities. This corresponds to the OData
     * navigation property <b>to_SuplrEvalRspSectionText</b>.
     * <p>
     * If the navigation property <b>to_SuplrEvalRspSectionText</b> of a queried <b>SuplrEvalRspSection</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SuplrEvalRspSectionText</b> entities.
     */
    public void addSuplrEvalRspSectionText( SuplrEvalRspSectionText... entity )
    {
        if( toSuplrEvalRspSectionText == null ) {
            toSuplrEvalRspSectionText = Lists.newArrayList();
        }
        toSuplrEvalRspSectionText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of SuplrEvalRspSection instances.
     *
     */
    public final static class SuplrEvalRspSectionBuilder
    {

        private List<SuplrEvalRspQuestion> toSuplrEvalRspQuestion = Lists.newArrayList();
        private List<SuplrEvalRspSectionText> toSuplrEvalRspSectionText = Lists.newArrayList();

        private SuplrEvalRspSection.SuplrEvalRspSectionBuilder toSuplrEvalRspQuestion(
            final List<SuplrEvalRspQuestion> value )
        {
            toSuplrEvalRspQuestion.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SuplrEvalRspQuestion</b> for <b>SuplrEvalRspSection</b> to multiple
         * <b>SuplrEvalRspQuestion</b>.
         *
         * @param value
         *            The SuplrEvalRspQuestions to build this SuplrEvalRspSection with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SuplrEvalRspSection.SuplrEvalRspSectionBuilder suplrEvalRspQuestion( SuplrEvalRspQuestion... value )
        {
            return toSuplrEvalRspQuestion(Lists.newArrayList(value));
        }

        private SuplrEvalRspSection.SuplrEvalRspSectionBuilder toSuplrEvalRspSectionText(
            final List<SuplrEvalRspSectionText> value )
        {
            toSuplrEvalRspSectionText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SuplrEvalRspSectionText</b> for <b>SuplrEvalRspSection</b> to multiple
         * <b>SuplrEvalRspSectionText</b>.
         *
         * @param value
         *            The SuplrEvalRspSectionTexts to build this SuplrEvalRspSection with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SuplrEvalRspSection.SuplrEvalRspSectionBuilder suplrEvalRspSectionText(
            SuplrEvalRspSectionText... value )
        {
            return toSuplrEvalRspSectionText(Lists.newArrayList(value));
        }

    }

}
