/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.selectable.SuplrEvalRspSectionSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspSection
 * SuplrEvalRspSection} entity using key fields. This fluent helper allows methods which modify the underlying query to
 * be called before executing the query itself.
 *
 */
public class SuplrEvalRspSectionByKeyFluentHelper
    extends
    FluentHelperByKey<SuplrEvalRspSectionByKeyFluentHelper, SuplrEvalRspSection, SuplrEvalRspSectionSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspSection
     * SuplrEvalRspSection} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SuplrEvalRspSection}
     * @param suplrEvalRspSectionUUID
     *            Evaluation Response Section UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code SuplrEvalRspSection}
     */
    public SuplrEvalRspSectionByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final UUID suplrEvalRspSectionUUID )
    {
        super(servicePath, entityCollection);
        this.key.put("SuplrEvalRspSectionUUID", suplrEvalRspSectionUUID);
    }

    @Override
    @Nonnull
    protected Class<SuplrEvalRspSection> getEntityClass()
    {
        return SuplrEvalRspSection.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
