/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperRead;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.selectable.SuplrEvalRspSectionSelectable;

/**
 * Fluent helper to fetch multiple
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspSection
 * SuplrEvalRspSection} entities. This fluent helper allows methods which modify the underlying query to be called
 * before executing the query itself.
 *
 */
public class SuplrEvalRspSectionFluentHelper
    extends
    FluentHelperRead<SuplrEvalRspSectionFluentHelper, SuplrEvalRspSection, SuplrEvalRspSectionSelectable>
{

    /**
     * Creates a fluent helper using the specified service path and entity collection to send the read requests.
     *
     * @param entityCollection
     *            The entity collection to direct the requests to.
     * @param servicePath
     *            The service path to direct the read requests to.
     */
    public SuplrEvalRspSectionFluentHelper( @Nonnull final String servicePath, @Nonnull final String entityCollection )
    {
        super(servicePath, entityCollection);
    }

    @Override
    @Nonnull
    protected Class<SuplrEvalRspSection> getEntityClass()
    {
        return SuplrEvalRspSection.class;
    }

}
