/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse;

import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.field.SuplrEvalRspStrucQnaireField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.link.SuplrEvalRspStrucQnaireLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.selectable.SuplrEvalRspStrucQnaireSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Structure Questionnaire
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SuplrEvalRspStrucQnaireType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SuplrEvalRspStrucQnaire extends VdmEntity<SuplrEvalRspStrucQnaire>
{

    /**
     * Selector for all available fields of SuplrEvalRspStrucQnaire.
     *
     */
    public final static SuplrEvalRspStrucQnaireSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalRspQuestionnaireUUID</b>
     * </p>
     *
     * @return Evaluation Response Questionnaire UUID
     */
    @Key
    @SerializedName( "SuplrEvalRspQuestionnaireUUID" )
    @JsonProperty( "SuplrEvalRspQuestionnaireUUID" )
    @Nullable
    @ODataField( odataName = "SuplrEvalRspQuestionnaireUUID" )
    private UUID suplrEvalRspQuestionnaireUUID;
    /**
     * Use with available fluent helpers to apply the <b>SuplrEvalRspQuestionnaireUUID</b> field to query operations.
     *
     */
    public final static SuplrEvalRspStrucQnaireField<UUID> SUPLR_EVAL_RSP_QUESTIONNAIRE_UUID =
        new SuplrEvalRspStrucQnaireField<UUID>("SuplrEvalRspQuestionnaireUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalRspRootQnaireUUID</b>
     * </p>
     *
     * @return Supplier Evaluation Response Parent Hierarchy UUID
     */
    @SerializedName( "SuplrEvalRspRootQnaireUUID" )
    @JsonProperty( "SuplrEvalRspRootQnaireUUID" )
    @Nullable
    @ODataField( odataName = "SuplrEvalRspRootQnaireUUID" )
    private UUID suplrEvalRspRootQnaireUUID;
    /**
     * Use with available fluent helpers to apply the <b>SuplrEvalRspRootQnaireUUID</b> field to query operations.
     *
     */
    public final static SuplrEvalRspStrucQnaireField<UUID> SUPLR_EVAL_RSP_ROOT_QNAIRE_UUID =
        new SuplrEvalRspStrucQnaireField<UUID>("SuplrEvalRspRootQnaireUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalRspUUID</b>
     * </p>
     *
     * @return Evaluation Response UUID
     */
    @SerializedName( "SuplrEvalRspUUID" )
    @JsonProperty( "SuplrEvalRspUUID" )
    @Nullable
    @ODataField( odataName = "SuplrEvalRspUUID" )
    private UUID suplrEvalRspUUID;
    /**
     * Use with available fluent helpers to apply the <b>SuplrEvalRspUUID</b> field to query operations.
     *
     */
    public final static SuplrEvalRspStrucQnaireField<UUID> SUPLR_EVAL_RSP_UUID =
        new SuplrEvalRspStrucQnaireField<UUID>("SuplrEvalRspUUID");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>QuestionnaireName</b>
     * </p>
     *
     * @return Medium-Size Name
     */
    @SerializedName( "QuestionnaireName" )
    @JsonProperty( "QuestionnaireName" )
    @Nullable
    @ODataField( odataName = "QuestionnaireName" )
    private String questionnaireName;
    /**
     * Use with available fluent helpers to apply the <b>QuestionnaireName</b> field to query operations.
     *
     */
    public final static SuplrEvalRspStrucQnaireField<String> QUESTIONNAIRE_NAME =
        new SuplrEvalRspStrucQnaireField<String>("QuestionnaireName");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CalculatedScore</b>
     * </p>
     *
     * @return Calculated Score
     */
    @SerializedName( "CalculatedScore" )
    @JsonProperty( "CalculatedScore" )
    @Nullable
    @ODataField( odataName = "CalculatedScore" )
    private Double calculatedScore;
    /**
     * Use with available fluent helpers to apply the <b>CalculatedScore</b> field to query operations.
     *
     */
    public final static SuplrEvalRspStrucQnaireField<Double> CALCULATED_SCORE =
        new SuplrEvalRspStrucQnaireField<Double>("CalculatedScore");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsScoringRelevant</b>
     * </p>
     *
     * @return Scoring Indicator
     */
    @SerializedName( "IsScoringRelevant" )
    @JsonProperty( "IsScoringRelevant" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsScoringRelevant" )
    private Boolean isScoringRelevant;
    /**
     * Use with available fluent helpers to apply the <b>IsScoringRelevant</b> field to query operations.
     *
     */
    public final static SuplrEvalRspStrucQnaireField<Boolean> IS_SCORING_RELEVANT =
        new SuplrEvalRspStrucQnaireField<Boolean>("IsScoringRelevant");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MinimalScore</b>
     * </p>
     *
     * @return Minimum Score Accepted
     */
    @SerializedName( "MinimalScore" )
    @JsonProperty( "MinimalScore" )
    @Nullable
    @ODataField( odataName = "MinimalScore" )
    private Short minimalScore;
    /**
     * Use with available fluent helpers to apply the <b>MinimalScore</b> field to query operations.
     *
     */
    public final static SuplrEvalRspStrucQnaireField<Short> MINIMAL_SCORE =
        new SuplrEvalRspStrucQnaireField<Short>("MinimalScore");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>NumberOfResponses</b>
     * </p>
     *
     * @return Number of Responses
     */
    @SerializedName( "NumberOfResponses" )
    @JsonProperty( "NumberOfResponses" )
    @Nullable
    @ODataField( odataName = "NumberOfResponses" )
    private Integer numberOfResponses;
    /**
     * Use with available fluent helpers to apply the <b>NumberOfResponses</b> field to query operations.
     *
     */
    public final static SuplrEvalRspStrucQnaireField<Integer> NUMBER_OF_RESPONSES =
        new SuplrEvalRspStrucQnaireField<Integer>("NumberOfResponses");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalOrdinalNumber</b>
     * </p>
     *
     * @return Ordinal Number Value
     */
    @SerializedName( "SuplrEvalOrdinalNumber" )
    @JsonProperty( "SuplrEvalOrdinalNumber" )
    @Nullable
    @ODataField( odataName = "SuplrEvalOrdinalNumber" )
    private Integer suplrEvalOrdinalNumber;
    /**
     * Use with available fluent helpers to apply the <b>SuplrEvalOrdinalNumber</b> field to query operations.
     *
     */
    public final static SuplrEvalRspStrucQnaireField<Integer> SUPLR_EVAL_ORDINAL_NUMBER =
        new SuplrEvalRspStrucQnaireField<Integer>("SuplrEvalOrdinalNumber");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>TargetScore</b>
     * </p>
     *
     * @return Target Score
     */
    @SerializedName( "TargetScore" )
    @JsonProperty( "TargetScore" )
    @Nullable
    @ODataField( odataName = "TargetScore" )
    private Short targetScore;
    /**
     * Use with available fluent helpers to apply the <b>TargetScore</b> field to query operations.
     *
     */
    public final static SuplrEvalRspStrucQnaireField<Short> TARGET_SCORE =
        new SuplrEvalRspStrucQnaireField<Short>("TargetScore");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>WeightingFactor</b>
     * </p>
     *
     * @return Value of Weighting Factor
     */
    @SerializedName( "WeightingFactor" )
    @JsonProperty( "WeightingFactor" )
    @Nullable
    @ODataField( odataName = "WeightingFactor" )
    private Short weightingFactor;
    /**
     * Use with available fluent helpers to apply the <b>WeightingFactor</b> field to query operations.
     *
     */
    public final static SuplrEvalRspStrucQnaireField<Short> WEIGHTING_FACTOR =
        new SuplrEvalRspStrucQnaireField<Short>("WeightingFactor");
    /**
     * Navigation property <b>to_SuplrEvalRspSection</b> for <b>SuplrEvalRspStrucQnaire</b> to multiple
     * <b>SuplrEvalRspSection</b>.
     *
     */
    @SerializedName( "to_SuplrEvalRspSection" )
    @JsonProperty( "to_SuplrEvalRspSection" )
    @ODataField( odataName = "to_SuplrEvalRspSection" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SuplrEvalRspSection> toSuplrEvalRspSection;
    /**
     * Use with available fluent helpers to apply the <b>to_SuplrEvalRspSection</b> navigation property to query
     * operations.
     *
     */
    public final static SuplrEvalRspStrucQnaireLink<SuplrEvalRspSection> TO_SUPLR_EVAL_RSP_SECTION =
        new SuplrEvalRspStrucQnaireLink<SuplrEvalRspSection>("to_SuplrEvalRspSection");

    @Nonnull
    @Override
    public Class<SuplrEvalRspStrucQnaire> getType()
    {
        return SuplrEvalRspStrucQnaire.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalRspQuestionnaireUUID</b>
     * </p>
     *
     * @param suplrEvalRspQuestionnaireUUID
     *            Evaluation Response Questionnaire UUID
     */
    public void setSuplrEvalRspQuestionnaireUUID( @Nullable final UUID suplrEvalRspQuestionnaireUUID )
    {
        rememberChangedField("SuplrEvalRspQuestionnaireUUID", this.suplrEvalRspQuestionnaireUUID);
        this.suplrEvalRspQuestionnaireUUID = suplrEvalRspQuestionnaireUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalRspRootQnaireUUID</b>
     * </p>
     *
     * @param suplrEvalRspRootQnaireUUID
     *            Supplier Evaluation Response Parent Hierarchy UUID
     */
    public void setSuplrEvalRspRootQnaireUUID( @Nullable final UUID suplrEvalRspRootQnaireUUID )
    {
        rememberChangedField("SuplrEvalRspRootQnaireUUID", this.suplrEvalRspRootQnaireUUID);
        this.suplrEvalRspRootQnaireUUID = suplrEvalRspRootQnaireUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalRspUUID</b>
     * </p>
     *
     * @param suplrEvalRspUUID
     *            Evaluation Response UUID
     */
    public void setSuplrEvalRspUUID( @Nullable final UUID suplrEvalRspUUID )
    {
        rememberChangedField("SuplrEvalRspUUID", this.suplrEvalRspUUID);
        this.suplrEvalRspUUID = suplrEvalRspUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>QuestionnaireName</b>
     * </p>
     *
     * @param questionnaireName
     *            Medium-Size Name
     */
    public void setQuestionnaireName( @Nullable final String questionnaireName )
    {
        rememberChangedField("QuestionnaireName", this.questionnaireName);
        this.questionnaireName = questionnaireName;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CalculatedScore</b>
     * </p>
     *
     * @param calculatedScore
     *            Calculated Score
     */
    public void setCalculatedScore( @Nullable final Double calculatedScore )
    {
        rememberChangedField("CalculatedScore", this.calculatedScore);
        this.calculatedScore = calculatedScore;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsScoringRelevant</b>
     * </p>
     *
     * @param isScoringRelevant
     *            Scoring Indicator
     */
    public void setIsScoringRelevant( @Nullable final Boolean isScoringRelevant )
    {
        rememberChangedField("IsScoringRelevant", this.isScoringRelevant);
        this.isScoringRelevant = isScoringRelevant;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MinimalScore</b>
     * </p>
     *
     * @param minimalScore
     *            Minimum Score Accepted
     */
    public void setMinimalScore( @Nullable final Short minimalScore )
    {
        rememberChangedField("MinimalScore", this.minimalScore);
        this.minimalScore = minimalScore;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>NumberOfResponses</b>
     * </p>
     *
     * @param numberOfResponses
     *            Number of Responses
     */
    public void setNumberOfResponses( @Nullable final Integer numberOfResponses )
    {
        rememberChangedField("NumberOfResponses", this.numberOfResponses);
        this.numberOfResponses = numberOfResponses;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalOrdinalNumber</b>
     * </p>
     *
     * @param suplrEvalOrdinalNumber
     *            Ordinal Number Value
     */
    public void setSuplrEvalOrdinalNumber( @Nullable final Integer suplrEvalOrdinalNumber )
    {
        rememberChangedField("SuplrEvalOrdinalNumber", this.suplrEvalOrdinalNumber);
        this.suplrEvalOrdinalNumber = suplrEvalOrdinalNumber;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>TargetScore</b>
     * </p>
     *
     * @param targetScore
     *            Target Score
     */
    public void setTargetScore( @Nullable final Short targetScore )
    {
        rememberChangedField("TargetScore", this.targetScore);
        this.targetScore = targetScore;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>WeightingFactor</b>
     * </p>
     *
     * @param weightingFactor
     *            Value of Weighting Factor
     */
    public void setWeightingFactor( @Nullable final Short weightingFactor )
    {
        rememberChangedField("WeightingFactor", this.weightingFactor);
        this.weightingFactor = weightingFactor;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SuplrEvalRspStrucQnaire";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SuplrEvalRspQuestionnaireUUID", getSuplrEvalRspQuestionnaireUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SuplrEvalRspQuestionnaireUUID", getSuplrEvalRspQuestionnaireUUID());
        values.put("SuplrEvalRspRootQnaireUUID", getSuplrEvalRspRootQnaireUUID());
        values.put("SuplrEvalRspUUID", getSuplrEvalRspUUID());
        values.put("QuestionnaireName", getQuestionnaireName());
        values.put("CalculatedScore", getCalculatedScore());
        values.put("IsScoringRelevant", getIsScoringRelevant());
        values.put("MinimalScore", getMinimalScore());
        values.put("NumberOfResponses", getNumberOfResponses());
        values.put("SuplrEvalOrdinalNumber", getSuplrEvalOrdinalNumber());
        values.put("TargetScore", getTargetScore());
        values.put("WeightingFactor", getWeightingFactor());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SuplrEvalRspQuestionnaireUUID") ) {
                final Object value = values.remove("SuplrEvalRspQuestionnaireUUID");
                if( (value == null) || (!value.equals(getSuplrEvalRspQuestionnaireUUID())) ) {
                    setSuplrEvalRspQuestionnaireUUID(((UUID) value));
                }
            }
            if( values.containsKey("SuplrEvalRspRootQnaireUUID") ) {
                final Object value = values.remove("SuplrEvalRspRootQnaireUUID");
                if( (value == null) || (!value.equals(getSuplrEvalRspRootQnaireUUID())) ) {
                    setSuplrEvalRspRootQnaireUUID(((UUID) value));
                }
            }
            if( values.containsKey("SuplrEvalRspUUID") ) {
                final Object value = values.remove("SuplrEvalRspUUID");
                if( (value == null) || (!value.equals(getSuplrEvalRspUUID())) ) {
                    setSuplrEvalRspUUID(((UUID) value));
                }
            }
            if( values.containsKey("QuestionnaireName") ) {
                final Object value = values.remove("QuestionnaireName");
                if( (value == null) || (!value.equals(getQuestionnaireName())) ) {
                    setQuestionnaireName(((String) value));
                }
            }
            if( values.containsKey("CalculatedScore") ) {
                final Object value = values.remove("CalculatedScore");
                if( (value == null) || (!value.equals(getCalculatedScore())) ) {
                    setCalculatedScore(((Double) value));
                }
            }
            if( values.containsKey("IsScoringRelevant") ) {
                final Object value = values.remove("IsScoringRelevant");
                if( (value == null) || (!value.equals(getIsScoringRelevant())) ) {
                    setIsScoringRelevant(((Boolean) value));
                }
            }
            if( values.containsKey("MinimalScore") ) {
                final Object value = values.remove("MinimalScore");
                if( (value == null) || (!value.equals(getMinimalScore())) ) {
                    setMinimalScore(((Short) value));
                }
            }
            if( values.containsKey("NumberOfResponses") ) {
                final Object value = values.remove("NumberOfResponses");
                if( (value == null) || (!value.equals(getNumberOfResponses())) ) {
                    setNumberOfResponses(((Integer) value));
                }
            }
            if( values.containsKey("SuplrEvalOrdinalNumber") ) {
                final Object value = values.remove("SuplrEvalOrdinalNumber");
                if( (value == null) || (!value.equals(getSuplrEvalOrdinalNumber())) ) {
                    setSuplrEvalOrdinalNumber(((Integer) value));
                }
            }
            if( values.containsKey("TargetScore") ) {
                final Object value = values.remove("TargetScore");
                if( (value == null) || (!value.equals(getTargetScore())) ) {
                    setTargetScore(((Short) value));
                }
            }
            if( values.containsKey("WeightingFactor") ) {
                final Object value = values.remove("WeightingFactor");
                if( (value == null) || (!value.equals(getWeightingFactor())) ) {
                    setWeightingFactor(((Short) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_SuplrEvalRspSection") ) {
                final Object value = (values).remove("to_SuplrEvalRspSection");
                if( value instanceof Iterable ) {
                    if( toSuplrEvalRspSection == null ) {
                        toSuplrEvalRspSection = Lists.newArrayList();
                    } else {
                        toSuplrEvalRspSection = Lists.newArrayList(toSuplrEvalRspSection);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SuplrEvalRspSection entity;
                        if( toSuplrEvalRspSection.size() > i ) {
                            entity = toSuplrEvalRspSection.get(i);
                        } else {
                            entity = new SuplrEvalRspSection();
                            toSuplrEvalRspSection.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SuplrEvalRspStrucQnaireField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SuplrEvalRspStrucQnaireField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SuplrEvalRspStrucQnaireField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SuplrEvalRspStrucQnaireField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierEvaluationResponseService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toSuplrEvalRspSection != null ) {
            (values).put("to_SuplrEvalRspSection", toSuplrEvalRspSection);
        }
        return values;
    }

    /**
     * Fetches the <b>SuplrEvalRspSection</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_SuplrEvalRspSection</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SuplrEvalRspSection</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SuplrEvalRspSection> fetchSuplrEvalRspSection()
    {
        return fetchFieldAsList("to_SuplrEvalRspSection", SuplrEvalRspSection.class);
    }

    /**
     * Retrieval of associated <b>SuplrEvalRspSection</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SuplrEvalRspSection</b>.
     * <p>
     * If the navigation property <b>to_SuplrEvalRspSection</b> of a queried <b>SuplrEvalRspStrucQnaire</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SuplrEvalRspSection</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SuplrEvalRspSection> getSuplrEvalRspSectionOrFetch()
    {
        if( toSuplrEvalRspSection == null ) {
            toSuplrEvalRspSection = fetchSuplrEvalRspSection();
        }
        return toSuplrEvalRspSection;
    }

    /**
     * Retrieval of associated <b>SuplrEvalRspSection</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SuplrEvalRspSection</b>.
     * <p>
     * If the navigation property for an entity <b>SuplrEvalRspStrucQnaire</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SuplrEvalRspSection</b> is already loaded, the result
     *         will contain the <b>SuplrEvalRspSection</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SuplrEvalRspSection>> getSuplrEvalRspSectionIfPresent()
    {
        return Option.of(toSuplrEvalRspSection);
    }

    /**
     * Overwrites the list of associated <b>SuplrEvalRspSection</b> entities for the loaded navigation property
     * <b>to_SuplrEvalRspSection</b>.
     * <p>
     * If the navigation property <b>to_SuplrEvalRspSection</b> of a queried <b>SuplrEvalRspStrucQnaire</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SuplrEvalRspSection</b> entities.
     */
    public void setSuplrEvalRspSection( @Nonnull final List<SuplrEvalRspSection> value )
    {
        if( toSuplrEvalRspSection == null ) {
            toSuplrEvalRspSection = Lists.newArrayList();
        }
        toSuplrEvalRspSection.clear();
        toSuplrEvalRspSection.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SuplrEvalRspSection</b> entities. This corresponds to the OData
     * navigation property <b>to_SuplrEvalRspSection</b>.
     * <p>
     * If the navigation property <b>to_SuplrEvalRspSection</b> of a queried <b>SuplrEvalRspStrucQnaire</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SuplrEvalRspSection</b> entities.
     */
    public void addSuplrEvalRspSection( SuplrEvalRspSection... entity )
    {
        if( toSuplrEvalRspSection == null ) {
            toSuplrEvalRspSection = Lists.newArrayList();
        }
        toSuplrEvalRspSection.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of SuplrEvalRspStrucQnaire instances.
     *
     */
    public final static class SuplrEvalRspStrucQnaireBuilder
    {

        private List<SuplrEvalRspSection> toSuplrEvalRspSection = Lists.newArrayList();

        private SuplrEvalRspStrucQnaire.SuplrEvalRspStrucQnaireBuilder toSuplrEvalRspSection(
            final List<SuplrEvalRspSection> value )
        {
            toSuplrEvalRspSection.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SuplrEvalRspSection</b> for <b>SuplrEvalRspStrucQnaire</b> to multiple
         * <b>SuplrEvalRspSection</b>.
         *
         * @param value
         *            The SuplrEvalRspSections to build this SuplrEvalRspStrucQnaire with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SuplrEvalRspStrucQnaire.SuplrEvalRspStrucQnaireBuilder suplrEvalRspSection(
            SuplrEvalRspSection... value )
        {
            return toSuplrEvalRspSection(Lists.newArrayList(value));
        }

    }

}
